/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.constraint;

import com.netscape.certsrv.profile.ERejectException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.constraint.EnrollConstraint;
import com.netscape.cms.profile.def.NoDefault;
import com.netscape.cms.profile.def.PolicyDefault;
import com.netscape.cms.profile.def.SigningAlgDefault;
import com.netscape.cms.profile.def.UserSigningAlgDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateAlgorithmId;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SigningAlgConstraint
extends EnrollConstraint {
    public static Logger logger = LoggerFactory.getLogger(SigningAlgConstraint.class);
    public static final String CONFIG_ALGORITHMS_ALLOWED = "signingAlgsAllowed";
    private static StringBuffer sb = new StringBuffer("");
    public static final String DEF_CONFIG_ALGORITHMS;

    public SigningAlgConstraint() {
        this.addConfigName(CONFIG_ALGORITHMS_ALLOWED);
    }

    @Override
    public void setConfig(String name, String value) throws EPropertyException {
        if (this.mConfig.getSubStore("params") == null) {
            logger.debug("SigningAlgConstraint: mConfig.getSubStore is null");
        } else {
            logger.debug("SigningAlgConstraint: setConfig name=" + name + " value=" + value);
            if (name.equals(CONFIG_ALGORITHMS_ALLOWED)) {
                StringTokenizer st = new StringTokenizer(value, ",");
                while (st.hasMoreTokens()) {
                    String v = st.nextToken();
                    if (DEF_CONFIG_ALGORITHMS.indexOf(v) != -1) continue;
                    logger.error("SigningAlgConstraint: Unsupported signing algorithm: " + v);
                    throw new EPropertyException("Unsupported signing algorithm: " + v);
                }
            }
            this.mConfig.getSubStore("params").putString(name, value);
        }
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals(CONFIG_ALGORITHMS_ALLOWED)) {
            return new Descriptor("string", null, DEF_CONFIG_ALGORITHMS, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SIGNING_ALGORITHMS_ALLOWED", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void validate(Request request, X509CertInfo info) throws ERejectException {
        CertificateAlgorithmId algId = null;
        try {
            algId = (CertificateAlgorithmId)info.get("algorithmID");
            AlgorithmId id = (AlgorithmId)algId.get("algorithm");
            Vector<String> mCache = new Vector<String>();
            StringTokenizer st = new StringTokenizer(this.getConfig(CONFIG_ALGORITHMS_ALLOWED), ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                mCache.addElement(token);
            }
            if (!mCache.contains(id.getName())) {
                throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_SIGNING_ALGORITHM_NOT_MATCHED", (String[])new String[]{id.toString()}));
            }
        }
        catch (Exception e) {
            if (e instanceof ERejectException) {
                throw (ERejectException)e;
            }
            logger.error("SigningAlgConstraint: " + e.getMessage(), (Throwable)e);
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_SIGNING_ALGORITHM_NOT_FOUND", (String[])new String[0]));
        }
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CONSTRAINT_SIGNING_ALG_TEXT", (String[])new String[]{this.getConfig(CONFIG_ALGORITHMS_ALLOWED)});
    }

    @Override
    public boolean isApplicable(PolicyDefault def) {
        if (def instanceof NoDefault) {
            return true;
        }
        if (def instanceof UserSigningAlgDefault) {
            return true;
        }
        return def instanceof SigningAlgDefault;
    }

    static {
        for (int i = 0; i < AlgorithmId.ALL_SIGNING_ALGORITHMS.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(AlgorithmId.ALL_SIGNING_ALGORITHMS[i]);
        }
        DEF_CONFIG_ALGORITHMS = new String(sb);
    }
}

