/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollExtDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.util.Locale;
import org.mozilla.jss.netscape.security.extensions.OCSPNoCheckExtension;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPNoCheckExtDefault
extends EnrollExtDefault {
    public static Logger logger = LoggerFactory.getLogger(OCSPNoCheckExtDefault.class);
    public static final String CONFIG_CRITICAL = "ocspNoCheckCritical";
    public static final String VAL_CRITICAL = "ocspNoCheckCritical";

    public OCSPNoCheckExtDefault() {
        this.addValueName("ocspNoCheckCritical");
        this.addConfigName("ocspNoCheckCritical");
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals("ocspNoCheckCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals("ocspNoCheckCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        boolean val;
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        OCSPNoCheckExtension ext = (OCSPNoCheckExtension)this.getExtension("1.3.6.1.5.5.7.48.1.5", info);
        if (ext == null) {
            try {
                this.populate(null, info);
            }
            catch (EProfileException e) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        if (name.equals("ocspNoCheckCritical")) {
            ext = (OCSPNoCheckExtension)this.getExtension("1.3.6.1.5.5.7.48.1.5", info);
            val = Boolean.parseBoolean(value);
            if (ext == null) {
                return;
            }
        } else {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        ext.setCritical(val);
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        OCSPNoCheckExtension ext = (OCSPNoCheckExtension)this.getExtension("1.3.6.1.5.5.7.48.1.5", info);
        if (ext == null) {
            try {
                this.populate(null, info);
            }
            catch (EProfileException e) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        if (name.equals("ocspNoCheckCritical")) {
            ext = (OCSPNoCheckExtension)this.getExtension("1.3.6.1.5.5.7.48.1.5", info);
            if (ext == null) {
                return null;
            }
            return ext.isCritical() ? "true" : "false";
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_OCSP_NO_CHECK_EXT", (String[])new String[]{this.getConfig("ocspNoCheckCritical")});
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        OCSPNoCheckExtension ext = this.createExtension();
        this.addExtension("1.3.6.1.5.5.7.48.1.5", (Extension)ext, info);
    }

    public OCSPNoCheckExtension createExtension() {
        OCSPNoCheckExtension ext = null;
        try {
            ext = new OCSPNoCheckExtension();
        }
        catch (Exception e) {
            logger.warn("OCSPNoCheckExtDefault:  createExtension " + e.getMessage(), (Throwable)e);
            return null;
        }
        boolean critical = this.getConfigBoolean("ocspNoCheckCritical");
        ext.setCritical(critical);
        return ext;
    }
}

