/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.ca.CRLIssuingPoint;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertRecordList;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.ldap.CAPublisherProcessor;
import com.netscape.cmscore.request.CertRequestRepository;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestQueue;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.CRLExtensions;
import org.mozilla.jss.netscape.security.x509.CRLReasonExtension;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.InvalidityDateExtension;
import org.mozilla.jss.netscape.security.x509.RevocationReason;
import org.mozilla.jss.netscape.security.x509.RevokedCertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChallengeRevocationServlet1
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(ChallengeRevocationServlet1.class);
    private static final long serialVersionUID = 1253319999546210407L;
    public static final String GETCERTS_FOR_CHALLENGE_REQUEST = "getCertsForChallenge";
    public static final String TOKEN_CERT_SERIAL = "certSerialToRevoke";
    private static final String TPL_FILE = "revocationResult.template";
    private CertificateRepository mCertDB;
    private String mFormPath = null;
    private RequestQueue mQueue;
    private CAPublisherProcessor mPublisherProcessor;
    private String mRequestID = null;
    public static final String SERIAL_NO = "certSerialToRevoke";
    public static final String REASON_CODE = "reasonCode";
    public static final String CHALLENGE_PHRASE = "challengePhrase";
    public static final String SERIALNO_ARRAY = "serialNoArray";

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        CAEngine engine = CAEngine.getInstance();
        this.mFormPath = "/ca/revocationResult.template";
        this.mTemplates.remove(CMSRequest.SUCCESS);
        this.mCertDB = engine.getCertificateRepository();
        this.mPublisherProcessor = engine.getPublisherProcessor();
        this.mQueue = engine.getRequestQueue();
    }

    protected void process(CMSRequest cmsReq) throws EBaseException {
        ArgBlock httpParams = cmsReq.getHttpParams();
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository cr = engine.getCertificateRepository();
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_DISPLAY_TEMPLATE", (Object[])new Object[0]), (Throwable)e);
            throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_ERROR_DISPLAY_TEMPLATE", (Object[])new Object[0]), (Exception)e);
        }
        ArgBlock header = new ArgBlock();
        ArgBlock ctx = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, ctx);
        AuthToken authToken = this.authenticate(cmsReq);
        String authMgr = "noAuthManager";
        BigInteger[] serialNoArray = null;
        if (authToken != null) {
            serialNoArray = authToken.getInBigIntegerArray("certSerialToRevoke");
        }
        int reasonCode = httpParams.getValueAsInt(REASON_CODE, 0);
        String comments = req.getParameter("csrRequestorComments");
        Date invalidityDate = null;
        String revokeAll = null;
        int totalRecordCount = serialNoArray != null ? serialNoArray.length : 0;
        int verifiedRecordCount = serialNoArray != null ? serialNoArray.length : 0;
        X509CertImpl[] certs = null;
        Object initiative = null;
        if (this.mAuthMgr != null && this.mAuthMgr.equals("certUserDBAuthMgr")) {
            if (authToken != null) {
                authMgr = authToken.getInString("authMgrInstName");
                String agentID = authToken.getInString("userid");
                initiative = "fromAgent agentID: " + agentID + " authenticated by " + authMgr;
            }
        } else {
            initiative = "fromUser";
        }
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "revoke");
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        if (serialNoArray != null && serialNoArray.length > 0) {
            int i;
            certs = new X509CertImpl[serialNoArray.length];
            for (i = 0; i < serialNoArray.length; ++i) {
                certs[i] = cr.getX509Certificate(serialNoArray[i]);
            }
            header.addIntegerValue("totalRecordCount", serialNoArray.length);
            header.addIntegerValue("verifiedRecordCount", serialNoArray.length);
            for (i = 0; i < serialNoArray.length; ++i) {
                ArgBlock rarg = new ArgBlock();
                rarg.addBigIntegerValue("serialNumber", serialNoArray[i], 16);
                rarg.addStringValue("subject", certs[i].getSubjectName().toString());
                rarg.addLongValue("validNotBefore", certs[i].getNotBefore().getTime() / 1000L);
                rarg.addLongValue("validNotAfter", certs[i].getNotAfter().getTime() / 1000L);
            }
            revokeAll = "(|(certRecordId=" + serialNoArray[0].toString() + "))";
            this.process(argSet, header, reasonCode, invalidityDate, (String)initiative, req, resp, verifiedRecordCount, revokeAll, totalRecordCount, comments, locale[0]);
        } else {
            header.addIntegerValue("totalRecordCount", 0);
            header.addIntegerValue("verifiedRecordCount", 0);
        }
        try {
            EBaseException ee;
            ServletOutputStream out = resp.getOutputStream();
            if (serialNoArray == null) {
                logger.warn("ChallengeRevcationServlet1::process() - serialNoArray is null!");
                ee = new EBaseException("No matched certificate is found");
                cmsReq.setError(ee);
                return;
            }
            if (serialNoArray.length == 0) {
                cmsReq.setStatus(CMSRequest.ERROR);
                ee = new EBaseException("No matched certificate is found");
                cmsReq.setError(ee);
            } else {
                String xmlOutput = req.getParameter("xml");
                if (xmlOutput != null && xmlOutput.equals("true")) {
                    this.outputXML(resp, argSet);
                } else {
                    resp.setContentType("text/html");
                    form.renderOutput((OutputStream)out, argSet);
                    cmsReq.setStatus(CMSRequest.SUCCESS);
                }
            }
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"ADMIN_SRVLT_ERR_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_ERROR_DISPLAY_TEMPLATE", (Object[])new Object[0]), (Exception)e);
        }
    }

    private void process(CMSTemplateParams argSet, ArgBlock header, int reason, Date invalidityDate, String initiative, HttpServletRequest req, HttpServletResponse resp, int verifiedRecordCount, String revokeAll, int totalRecordCount, String comments, Locale locale) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        try {
            int count = 0;
            Vector<X509CertImpl> oldCertsV = new Vector<X509CertImpl>();
            Vector<RevokedCertImpl> revCertImplsV = new Vector<RevokedCertImpl>();
            RevocationReason revReason = RevocationReason.valueOf((int)reason);
            CRLReasonExtension crlReasonExtn = new CRLReasonExtension(revReason);
            InvalidityDateExtension invalidityDateExtn = null;
            if (invalidityDate != null) {
                invalidityDateExtn = new InvalidityDateExtension(invalidityDate);
            }
            CRLExtensions entryExtn = new CRLExtensions();
            if (crlReasonExtn != null) {
                entryExtn.set(crlReasonExtn.getName(), (Extension)crlReasonExtn);
            }
            if (invalidityDateExtn != null) {
                entryExtn.set(invalidityDateExtn.getName(), (Extension)invalidityDateExtn);
            }
            CertRecordList list = this.mCertDB.findCertRecordsInList(revokeAll, null, totalRecordCount);
            Enumeration e = list.getCertRecords(0, totalRecordCount - 1);
            while (e != null && e.hasMoreElements()) {
                CertRecord rec = (CertRecord)e.nextElement();
                X509CertImpl cert = rec.getCertificate();
                ArgBlock rarg = new ArgBlock();
                rarg.addBigIntegerValue("serialNumber", cert.getSerialNumber(), 16);
                if (rec.getStatus().equals("REVOKED")) {
                    rarg.addStringValue("error", "Certificate " + cert.getSerialNumber().toString() + " is already revoked.");
                } else {
                    oldCertsV.addElement(cert);
                    RevokedCertImpl revCertImpl = new RevokedCertImpl(cert.getSerialNumber(), new Date(), entryExtn);
                    revCertImplsV.addElement(revCertImpl);
                    ++count;
                    rarg.addStringValue("error", null);
                }
                argSet.addRepeatRecord(rarg);
            }
            header.addIntegerValue("totalRecordCount", count);
            X509CertImpl[] oldCerts = new X509CertImpl[count];
            RevokedCertImpl[] revCertImpls = new RevokedCertImpl[count];
            for (int i = 0; i < count; ++i) {
                oldCerts[i] = (X509CertImpl)oldCertsV.elementAt(i);
                revCertImpls[i] = (RevokedCertImpl)revCertImplsV.elementAt(i);
            }
            CertRequestRepository requestRepository = engine.getCertRequestRepository();
            Request revReq = requestRepository.createRequest("revocation");
            revReq.setExtData("CERT_INFO", revCertImpls);
            revReq.setExtData("requestType", "revocation");
            revReq.setExtData("requestorType", "Agent");
            revReq.setExtData("OLD_CERTS", oldCerts);
            if (comments != null) {
                revReq.setExtData("csrRequestorComments", comments);
            }
            this.mQueue.processRequest(revReq);
            RequestStatus stat = revReq.getRequestStatus();
            if (stat == RequestStatus.COMPLETE) {
                Integer result = revReq.getExtDataInInteger("Result");
                if (result.equals(Request.RES_ERROR)) {
                    String[] svcErrors = revReq.getExtDataInStringArray("serviceErrors");
                    if (svcErrors != null && svcErrors.length > 0) {
                        for (int i = 0; i < svcErrors.length; ++i) {
                            String err = svcErrors[i];
                            if (err == null) continue;
                            for (int j = 0; j < count; ++j) {
                                if (oldCerts[j] == null) continue;
                                logger.info("Revocation request reqID {} {} is {}. DN requested: {} serial number: 0x{} revocation reason: {}", new Object[]{revReq.getRequestId(), initiative, "completed with error: " + err, oldCerts[j].getSubjectName(), oldCerts[j].getSerialNumber().toString(16), RevocationReason.valueOf((int)reason)});
                            }
                        }
                    }
                    return;
                }
                for (int j = 0; j < count; ++j) {
                    if (oldCerts[j] == null) continue;
                    logger.info("Revocation request reqID {} {} is {}. DN requested: {} serial number: 0x{} revocation reason: {}", new Object[]{revReq.getRequestId(), initiative, "completed", oldCerts[j].getSubjectName(), oldCerts[j].getSerialNumber().toString(16), RevocationReason.valueOf((int)reason)});
                }
                header.addStringValue("revoked", "yes");
                Integer updateCRLResult = revReq.getExtDataInInteger("crlUpdateStatus");
                if (updateCRLResult != null) {
                    header.addStringValue("updateCRL", "yes");
                    if (updateCRLResult.equals(Request.RES_SUCCESS)) {
                        header.addStringValue("updateCRLSuccess", "yes");
                    } else {
                        header.addStringValue("updateCRLSuccess", "no");
                        String crlError = revReq.getExtDataInString("crlUpdateError");
                        if (crlError != null) {
                            header.addStringValue("updateCRLError", crlError);
                        }
                    }
                    Integer publishCRLResult = revReq.getExtDataInInteger("crlPublishStatus");
                    if (publishCRLResult != null) {
                        if (publishCRLResult.equals(Request.RES_SUCCESS)) {
                            header.addStringValue("publishCRLSuccess", "yes");
                        } else {
                            header.addStringValue("publishCRLSuccess", "no");
                            String publError = revReq.getExtDataInString("crlPublishError");
                            if (publError != null) {
                                header.addStringValue("publishCRLError", publError);
                            }
                        }
                    }
                }
                for (CRLIssuingPoint crl : engine.getCRLIssuingPoints()) {
                    String publishStatusStr;
                    Integer publishResult;
                    String updateStatusStr;
                    Integer updateResult;
                    String crlId = crl.getId();
                    if (crlId.equals("MasterCRL") || (updateResult = revReq.getExtDataInInteger(updateStatusStr = crl.getCrlUpdateStatusStr())) == null) continue;
                    if (updateResult.equals(Request.RES_SUCCESS)) {
                        logger.debug("ChallengeRevcationServlet1: " + CMS.getLogMessage((String)"ADMIN_SRVLT_ADDING_HEADER", (Object[])new Object[]{updateStatusStr}));
                        header.addStringValue(updateStatusStr, "yes");
                    } else {
                        String updateErrorStr = crl.getCrlUpdateErrorStr();
                        logger.debug("ChallengeRevcationServlet1: " + CMS.getLogMessage((String)"ADMIN_SRVLT_ADDING_HEADER_NO", (Object[])new Object[]{updateStatusStr}));
                        header.addStringValue(updateStatusStr, "no");
                        String error = revReq.getExtDataInString(updateErrorStr);
                        if (error != null) {
                            header.addStringValue(updateErrorStr, error);
                        }
                    }
                    if ((publishResult = revReq.getExtDataInInteger(publishStatusStr = crl.getCrlPublishStatusStr())) == null) continue;
                    if (publishResult.equals(Request.RES_SUCCESS)) {
                        header.addStringValue(publishStatusStr, "yes");
                        continue;
                    }
                    String publishErrorStr = crl.getCrlPublishErrorStr();
                    header.addStringValue(publishStatusStr, "no");
                    String error = revReq.getExtDataInString(publishErrorStr);
                    if (error == null) continue;
                    header.addStringValue(publishErrorStr, error);
                }
                if (this.mPublisherProcessor != null && this.mPublisherProcessor.ldapEnabled()) {
                    header.addStringValue("dirEnabled", "yes");
                    Integer[] ldapPublishStatus = revReq.getExtDataInIntegerArray("ldapPublishStatus");
                    int certsToUpdate = 0;
                    int certsUpdated = 0;
                    if (ldapPublishStatus != null) {
                        certsToUpdate = ldapPublishStatus.length;
                        for (int i = 0; i < certsToUpdate; ++i) {
                            if (ldapPublishStatus[i] != Request.RES_SUCCESS) continue;
                            ++certsUpdated;
                        }
                    }
                    header.addIntegerValue("certsUpdated", certsUpdated);
                    header.addIntegerValue("certsToUpdate", certsToUpdate);
                    String publError = revReq.getExtDataInString("crlPublishError");
                    if (publError != null) {
                        header.addStringValue("crlPublishError", publError);
                    }
                } else {
                    header.addStringValue("dirEnabled", "no");
                }
                header.addStringValue("error", null);
            } else if (stat == RequestStatus.PENDING) {
                header.addStringValue("error", "Request Pending");
                header.addStringValue("revoked", "pending");
                for (int j = 0; j < count; ++j) {
                    if (oldCerts[j] == null) continue;
                    logger.info("Revocation request reqID {} {} is {}. DN requested: {} serial number: 0x{} revocation reason: {}", new Object[]{revReq.getRequestId(), initiative, "pending", oldCerts[j].getSubjectName(), oldCerts[j].getSerialNumber().toString(16), RevocationReason.valueOf((int)reason)});
                }
            } else {
                Vector errors = revReq.getExtDataInStringVector("errors");
                StringBuffer errorStr = new StringBuffer();
                if (errors != null && errors.size() > 0) {
                    for (int ii = 0; ii < errors.size(); ++ii) {
                        errorStr.append((String)errors.elementAt(ii));
                    }
                }
                header.addStringValue("error", errorStr.toString());
                header.addStringValue("revoked", "no");
                for (int j = 0; j < count; ++j) {
                    if (oldCerts[j] == null) continue;
                    logger.info("Revocation request reqID {} {} is {}. DN requested: {} serial number: 0x{} revocation reason: {}", new Object[]{revReq.getRequestId(), initiative, stat, oldCerts[j].getSubjectName(), oldCerts[j].getSerialNumber().toString(16), RevocationReason.valueOf((int)reason)});
                }
            }
        }
        catch (EBaseException e) {
            logger.error("ChallengeRevocationServlet1: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_MARKING_CERT_REVOKED", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_ERROR_MARKING_CERT_REVOKED", (Object[])new Object[0]), (Exception)e);
        }
        catch (Exception e) {
            logger.warn("ChallengeRevocationServlet1: " + e.getMessage(), (Throwable)e);
        }
    }
}

