/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.DBAttrMapper;
import com.netscape.certsrv.dbs.EDBException;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertRecordMapper
extends DBAttrMapper {
    public static Logger logger = LoggerFactory.getLogger(CertRecordMapper.class);
    private CertificateRepository mDB;

    public CertRecordMapper(CertificateRepository db) {
        this.mDB = db;
    }

    public Enumeration<String> getSupportedLDAPAttributeNames() {
        Vector<String> v = new Vector<String>();
        v.addElement("certRecordId");
        return v.elements();
    }

    public void mapObjectToLDAPAttributeSet(IDBObj parent, String name, Object obj, LDAPAttributeSet attrs) throws EBaseException {
        if (obj == null) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_DBS_SERIALIZE_FAILED", (String[])new String[]{name}));
        }
        CertRecord rec = (CertRecord)obj;
        logger.debug("CertRecordMapper: Mapping " + name + " to certRecordId");
        attrs.add(new LDAPAttribute("certRecordId", rec.getSerialNumber().toString()));
    }

    public void mapLDAPAttributeSetToObject(LDAPAttributeSet attrs, String name, IDBObj parent) throws EBaseException {
        try {
            LDAPAttribute attr = attrs.getAttribute("certRecordId");
            if (attr == null) {
                return;
            }
            String serialno = (String)attr.getStringValues().nextElement();
            CertRecord rec = this.mDB.readCertificateRecord(new BigInteger(serialno));
            parent.set(name, (Object)rec);
        }
        catch (Exception e) {
            logger.error("CertRecordMapper: " + e.getMessage(), (Throwable)e);
            throw new EDBException(CMS.getUserMessage((String)"CMS_DBS_DESERIALIZE_FAILED", (String[])new String[]{name}));
        }
    }

    public String mapSearchFilter(String name, String op, String value) throws EBaseException {
        return name + op + value;
    }
}

