/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.ca.CRLIssuingPoint;
import com.netscape.ca.CertRecordProcessor;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertRecordList;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.dbs.ElementProcessor;
import java.util.Date;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.dogtagpki.server.ca.CAEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertStatusUpdateTask
implements Runnable {
    public static Logger logger = LoggerFactory.getLogger(CertStatusUpdateTask.class);
    CertificateRepository repository;
    int interval;
    int pageSize = 200;
    int maxRecords = 1000000;
    ScheduledExecutorService executorService;

    public CertStatusUpdateTask(CertificateRepository repository, int interval, int pageSize, int maxRecords) {
        this.repository = repository;
        this.interval = interval;
        this.pageSize = pageSize;
        this.maxRecords = maxRecords;
    }

    public void start() {
        this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "CertStatusUpdateTask");
            }
        });
        this.executorService.scheduleWithFixedDelay(this, 0L, this.interval, TimeUnit.SECONDS);
    }

    public void updateInvalidCertificates() throws Exception {
        logger.info("CertStatusUpdateTask: Updating invalid certs to valid");
        Date now = new Date();
        CertRecordList recordList = this.repository.getInvalidCertsByNotBeforeDate(now, -1 * this.pageSize);
        int totalSize = recordList.getSize();
        logger.debug("CertStatusUpdateTask: - total size: " + totalSize);
        if (totalSize <= 0) {
            logger.debug("CertStatusUpdateTask: No invalid certs");
            return;
        }
        int listSize = recordList.getSizeBeforeJumpTo();
        listSize = Math.min(listSize, this.maxRecords);
        logger.debug("CertStatusUpdateTask: - list size: " + listSize);
        Vector<CertId> list = new Vector<CertId>(listSize);
        for (int i = 0; i < listSize; ++i) {
            CertRecord certRecord = recordList.getCertRecord(i);
            CertId certID = new CertId(certRecord.getSerialNumber());
            Date notBefore = certRecord.getNotBefore();
            if (notBefore.after(now)) {
                logger.debug("CertStatusUpdateTask: Cert " + certID.toHexString() + " not yet valid");
                continue;
            }
            logger.debug("CertStatusUpdateTask: Cert " + certID.toHexString() + " has become valid");
            list.add(certID);
        }
        this.repository.updateStatus(list, "VALID");
    }

    public void updateValidCertificates() throws Exception {
        logger.info("CertStatusUpdateTask: Updating valid certs to expired");
        Date now = new Date();
        CertRecordList recordList = this.repository.getValidCertsByNotAfterDate(now, -1 * this.pageSize);
        int totalSize = recordList.getSize();
        logger.debug("CertStatusUpdateTask: - total size: " + totalSize);
        if (totalSize <= 0) {
            logger.debug("CertStatusUpdateTask: No invalid certs");
            return;
        }
        int listSize = recordList.getSizeBeforeJumpTo();
        listSize = Math.min(listSize, this.maxRecords);
        logger.debug("CertStatusUpdateTask: - list size: " + listSize);
        Vector<CertId> list = new Vector<CertId>(listSize);
        for (int i = 0; i < listSize; ++i) {
            CertRecord certRecord = recordList.getCertRecord(i);
            CertId certID = new CertId(certRecord.getSerialNumber());
            Date notAfter = certRecord.getNotAfter();
            if (notAfter.after(now)) {
                logger.debug("CertStatusUpdateTask: Cert " + certID.toHexString() + " not yet expired");
                continue;
            }
            logger.debug("CertStatusUpdateTask: Cert " + certID.toHexString() + " has become expired");
            list.add(certID);
        }
        this.repository.updateStatus(list, "EXPIRED");
    }

    public void updateRevokedExpiredCertificates() throws EBaseException {
        int i;
        logger.info("CertStatusUpdateTask: Updating revoked certs to expired");
        CAEngine engine = CAEngine.getInstance();
        Date now = new Date();
        CertRecordList recordList = this.repository.getRevokedCertsByNotAfterDate(now, -1 * this.pageSize);
        int totalSize = recordList.getSize();
        logger.debug("CertStatusUpdateTask: - total size: " + totalSize);
        if (totalSize <= 0) {
            logger.debug("CertStatusUpdateTask: No invalid certs");
            return;
        }
        int listSize = recordList.getSizeBeforeJumpTo();
        listSize = Math.min(listSize, this.maxRecords);
        logger.debug("CertStatusUpdateTask: - list size: " + listSize);
        Vector<CertId> list = new Vector<CertId>(listSize);
        for (i = 0; i < listSize; ++i) {
            CertRecord certRecord = recordList.getCertRecord(i);
            CertId certID = new CertId(certRecord.getSerialNumber());
            Date notAfter = certRecord.getNotAfter();
            if (notAfter.after(now)) {
                logger.debug("CertStatusUpdateTask: Cert " + certID.toHexString() + " not yet expired");
                continue;
            }
            logger.debug("CertStatusUpdateTask: Cert " + certID.toHexString() + " has become expired");
            list.add(certID);
        }
        this.repository.updateStatus(list, "REVOKED_EXPIRED");
        for (i = 0; i < list.size(); ++i) {
            CertId certID = list.elementAt(i);
            for (CRLIssuingPoint issuingPoint : engine.getCRLIssuingPoints()) {
                issuingPoint.addExpiredCert(certID.toBigInteger());
            }
        }
    }

    public synchronized void updateCertStatus() throws Exception {
        logger.info("CertStatusUpdateTask: Updating cert status");
        logger.debug(CMS.getLogMessage((String)"CMSCORE_DBS_START_VALID_SEARCH", (Object[])new Object[0]));
        this.updateInvalidCertificates();
        logger.debug(CMS.getLogMessage((String)"CMSCORE_DBS_FINISH_VALID_SEARCH", (Object[])new Object[0]));
        logger.debug(CMS.getLogMessage((String)"CMSCORE_DBS_START_EXPIRED_SEARCH", (Object[])new Object[0]));
        this.updateValidCertificates();
        logger.debug(CMS.getLogMessage((String)"CMSCORE_DBS_FINISH_EXPIRED_SEARCH", (Object[])new Object[0]));
        logger.debug(CMS.getLogMessage((String)"CMSCORE_DBS_START_REVOKED_EXPIRED_SEARCH", (Object[])new Object[0]));
        this.updateRevokedExpiredCertificates();
        logger.debug(CMS.getLogMessage((String)"CMSCORE_DBS_FINISH_REVOKED_EXPIRED_SEARCH", (Object[])new Object[0]));
    }

    public synchronized void processRevokedCerts(CertRecordProcessor cp, String filter, int pageSize) throws EBaseException {
        logger.info("CertStatusUpdateTask: Processing revoked certs");
        CertRecordList list = this.repository.findCertRecordsInList(filter, new String[]{"certRecordId", "certRevoInfo", "objectclass"}, "serialno", pageSize);
        int totalSize = list.getSize();
        list.processCertRecords(0, totalSize - 1, (ElementProcessor)cp);
        logger.info("CertStatusUpdateTask: Done processing revoked certs");
    }

    @Override
    public void run() {
        try {
            this.updateCertStatus();
        }
        catch (Exception e) {
            logger.warn("CertStatusUpdateTask: " + e.getMessage(), (Throwable)e);
        }
    }

    public void stop() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }
}

