/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.extensions;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.cert.CertUtils;
import com.netscape.cmscore.request.Request;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.mozilla.jss.netscape.security.extensions.GenericASN1Extension;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.OIDMap;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericASN1Ext
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(GenericASN1Ext.class);
    protected static final int MAX_ATTR = 10;
    protected static final String PROP_CRITICAL = "critical";
    protected static final String PROP_NAME = "name";
    protected static final String PROP_OID = "oid";
    protected static final String PROP_PATTERN = "pattern";
    protected static final String PROP_ATTRIBUTE = "attribute";
    protected static final String PROP_TYPE = "type";
    protected static final String PROP_SOURCE = "source";
    protected static final String PROP_VALUE = "value";
    protected static final String PROP_PREDICATE = "predicate";
    protected static final String PROP_ENABLE = "enable";
    public ConfigStore mConfig;
    private String pattern = null;

    public String[] getExtendedPluginInfo() {
        String[] s = new String[]{"enable;boolean;Enable this policy", "predicate;string;", "critical;boolean;", "name;string;Name for this extension.", "oid;string;OID number for this extension. It should be unique.", "pattern;string;Pattern for extension; {012}34", "attribute.0.type;choice(Integer,IA5String,OctetString,PrintableString,VisibleString,UTCTime,OID,Boolean);Attribute type for extension", "attribute.0.source;choice(Value,File);Data Source for the extension. You can specify the value here or file name has value.", "attribute.0.value;string;If data source is 'value', specity value here. If data source is 'file', specify the file name with full path.", "attribute.1.type;choice(Integer,IA5String,OctetString,PrintableString,VisibleString,UTCTime,OID,Boolean);Attribute type for extension", "attribute.1.source;choice(Value,File);Data Source for the extension. You can specify the value here or file name has value.", "attribute.1.value;string;If data source is 'value', specity value here. If data source is 'file', specify the file name with full path.", "attribute.2.type;choice(Integer,IA5String,OctetString,PrintableString,VisibleString,UTCTime,OID,Boolean);Attribute type for extension", "attribute.2.source;choice(Value,File);Data Source for the extension. You can specify the value here or file name has value.", "attribute.2.value;string;If data source is 'value', specity value here. If data source is 'file', specify the file name with full path.", "attribute.3.type;choice(Integer,IA5String,OctetString,PrintableString,VisibleString,UTCTime,OID,Boolean);Attribute type for extension", "attribute.3.source;choice(Value,File);Data Source for the extension. You can specify the value here or file name has value.", "attribute.3.value;string;If data source is 'value', specity value here. If data source is 'file', specify the file name with full path.", "attribute.4.type;choice(Integer,IA5String,OctetString,PrintableString,VisibleString,UTCTime,OID,Boolean);Attribute type for extension", "attribute.4.source;choice(Value,File);Data Source for the extension. You can specify the value here or file name has value.", "attribute.4.value;string;If data source is 'value', specity value here. If data source is 'file', specify the file name with full path.", "attribute.5.type;choice(Integer,IA5String,OctetString,PrintableString,VisibleString,UTCTime,OID,Boolean);Attribute type for extension", "attribute.5.source;choice(Value,File);Data Source for the extension. You can specify the value here or file name has value.", "attribute.5.value;string;If data source is 'value', specity value here. If data source is 'file', specify the file name with full path.", "attribute.6.type;choice(Integer,IA5String,OctetString,PrintableString,VisibleString,UTCTime,OID,Boolean);Attribute type for extension", "attribute.6.source;choice(Value,File);Data Source for the extension. You can specify the value here or file name has value.", "attribute.6.value;string;If data source is 'value', specity value here. If data source is 'file', specify the file name with full path.", "attribute.7.type;choice(Integer,IA5String,OctetString,PrintableString,VisibleString,UTCTime,OID,Boolean);Attribute type for extension", "attribute.7.source;choice(Value,File);Data Source for the extension. You can specify the value here or file name has value.", "attribute.7.value;string;If data source is 'value', specity value here. If data source is 'file', specify the file name with full path.", "attribute.8.type;choice(Integer,IA5String,OctetString,PrintableString,VisibleString,UTCTime,OID,Boolean);Attribute type for extension", "attribute.8.source;choice(Value,File);Data Source for the extension. You can specify the value here or file name has value.", "attribute.8.value;string;If data source is 'value', specity value here. If data source is 'file', specify the file name with full path.", "attribute.9.type;choice(Integer,IA5String,OctetString,PrintableString,VisibleString,UTCTime,OID,Boolean);Attribute type for extension", "attribute.9.source;choice(Value,File);Data Source for the extension. You can specify the value here or file name has value.", "attribute.9.value;string;If data source is 'value', specity value here. If data source is 'file', specify the file name with full path.", "HELP_TOKEN;configuration-policyrules-genericasn1ext", "HELP_TEXT;Adds Private extension based on ASN1. See manual"};
        return s;
    }

    public GenericASN1Ext() {
        this.NAME = "GenericASN1Ext";
        this.DESC = "Sets Generic extension for certificates";
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EBaseException {
        this.mConfig = config;
        if (this.mConfig == null) {
            logger.error(CMS.getLogMessage((String)"POLICY_INIT_ERROR", (Object[])new Object[0]));
            return;
        }
        boolean enable = this.mConfig.getBoolean(PROP_ENABLE, false);
        if (!enable) {
            return;
        }
        String oid = this.mConfig.getString(PROP_OID, null);
        if (oid == null || oid.length() == 0) {
            logger.error(CMS.getLogMessage((String)"POLICY_INIT_ERROR", (Object[])new Object[0]));
            return;
        }
        String name = this.mConfig.getString(PROP_NAME, null);
        if (name == null || name.length() == 0) {
            logger.error(CMS.getLogMessage((String)"POLICY_INIT_ERROR", (Object[])new Object[0]));
            return;
        }
        try {
            if (File.separatorChar == '\\') {
                this.pattern = this.mConfig.getString(PROP_PATTERN, null);
                this.checkFilename(0);
            }
        }
        catch (IOException e) {
            logger.error("GenericASN1Ext: " + e.getMessage(), (Throwable)e);
        }
        catch (EBaseException e) {
            logger.error("GenericASN1Ext: " + e.getMessage(), (Throwable)e);
        }
        CertUtils.checkOID((String)name, (String)oid);
        this.pattern = this.mConfig.getString(PROP_PATTERN, null);
        this.checkOID(0);
        try {
            ObjectIdentifier tmpid = new ObjectIdentifier(oid);
            if (OIDMap.getName((ObjectIdentifier)tmpid) == null) {
                OIDMap.addAttribute((String)"org.mozilla.jss.netscape.security.extensions.GenericASN1Extension", (String)oid, (String)name);
            }
        }
        catch (CertificateException e) {
            logger.warn("GenericASN1Ext: " + e.getMessage(), (Throwable)e);
        }
    }

    private int checkFilename(int index) throws IOException, EBaseException {
        String source = null;
        while (index < this.pattern.length()) {
            char ch = this.pattern.charAt(index);
            switch (ch) {
                case '{': {
                    ++index;
                    index = this.checkFilename(index);
                    break;
                }
                case '}': {
                    return index;
                }
                default: {
                    source = this.mConfig.getString("attribute." + ch + ".source", null);
                    if (source == null || !source.equalsIgnoreCase("file")) break;
                    String oValue = this.mConfig.getString("attribute." + ch + ".value", null);
                    String nValue = oValue.replace('\\', '/');
                    this.mConfig.putString("attribute." + ch + ".value", nValue);
                    FileInputStream fis = new FileInputStream(nValue);
                    fis.close();
                }
            }
            ++index;
        }
        return index;
    }

    private int checkOID(int index) throws EBaseException {
        String type = null;
        String oid = null;
        while (index < this.pattern.length()) {
            char ch = this.pattern.charAt(index);
            switch (ch) {
                case '{': {
                    ++index;
                    index = this.checkOID(index);
                    break;
                }
                case '}': {
                    return index;
                }
                default: {
                    type = this.mConfig.getString("attribute." + ch + ".type", null);
                    if (type == null || !type.equalsIgnoreCase("OID")) break;
                    oid = this.mConfig.getString("attribute." + ch + ".value", null);
                    CertUtils.checkOID((String)oid, (String)oid);
                }
            }
            ++index;
        }
        return index;
    }

    public PolicyResult apply(Request req) {
        PolicyResult res = PolicyResult.ACCEPTED;
        X509CertInfo[] ci = req.getExtDataInCertInfoArray("CERT_INFO");
        if (ci == null) {
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[0]), this.NAME);
            return PolicyResult.REJECTED;
        }
        for (int j = 0; j < ci.length; ++j) {
            X509CertInfo certInfo = ci[j];
            if (certInfo == null) {
                logger.error(CMS.getLogMessage((String)"CA_CERT_INFO_ERROR", (Object[])new Object[]{""}));
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, "Configuration Info Error");
                return PolicyResult.REJECTED;
            }
            try {
                CertificateExtensions extensions = (CertificateExtensions)certInfo.get("extensions");
                if (extensions == null) {
                    certInfo.set("version", (Object)new CertificateVersion(2));
                    extensions = new CertificateExtensions();
                    certInfo.set("extensions", (Object)extensions);
                } else {
                    try {
                        extensions.delete(this.mConfig.getString(PROP_NAME, ""));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                GenericASN1Extension priExt = this.mkExtension();
                extensions.set(priExt.getName(), (Object)priExt);
                continue;
            }
            catch (IOException e) {
                logger.error(CMS.getLogMessage((String)"BASE_IO_ERROR", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, e.getMessage());
                return PolicyResult.REJECTED;
            }
            catch (EBaseException e) {
                logger.error(CMS.getLogMessage((String)"CA_CERT_INFO_ERROR", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, "Configuration Info Error");
                return PolicyResult.REJECTED;
            }
            catch (CertificateException e) {
                logger.error(CMS.getLogMessage((String)"CA_CERT_INFO_ERROR", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, "Certificate Info Error");
                return PolicyResult.REJECTED;
            }
            catch (ParseException e) {
                logger.error(CMS.getLogMessage((String)"BASE_EXTENSION_ERROR", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, "Pattern parsing error");
                return PolicyResult.REJECTED;
            }
            catch (Exception e) {
                logger.error(CMS.getLogMessage((String)"BASE_UNKNOWN_EXCEPTION", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, "Unknown Error");
                return PolicyResult.REJECTED;
            }
        }
        return res;
    }

    protected GenericASN1Extension mkExtension() throws IOException, EBaseException, ParseException {
        Hashtable<Object, String> h = new Hashtable<Object, String>();
        Enumeration e = this.mConfig.getPropertyNames();
        while (e.hasMoreElements()) {
            String n = (String)e.nextElement();
            h.put(n, this.mConfig.getString(n));
        }
        for (int idx = 0; idx < 10; ++idx) {
            String proptype = "attribute." + idx + ".type";
            String propsource = "attribute." + idx + ".source";
            String propvalue = "attribute." + idx + ".value";
            h.put(proptype, this.mConfig.getString(proptype, null));
            h.put(propsource, this.mConfig.getString(propsource, null));
            h.put(propvalue, this.mConfig.getString(propvalue, null));
        }
        GenericASN1Extension ext = new GenericASN1Extension(h);
        return ext;
    }

    public Vector<String> getInstanceParams() {
        int idx = 0;
        Vector<String> params = new Vector<String>();
        try {
            params.addElement("critical=" + this.mConfig.getBoolean(PROP_CRITICAL, false));
            params.addElement("name=" + this.mConfig.getString(PROP_NAME, null));
            params.addElement("oid=" + this.mConfig.getString(PROP_OID, null));
            params.addElement("pattern=" + this.mConfig.getString(PROP_PATTERN, null));
            for (idx = 0; idx < 10; ++idx) {
                String proptype = "attribute." + idx + ".type";
                String propsource = "attribute." + idx + ".source";
                String propvalue = "attribute." + idx + ".value";
                params.addElement(proptype + "=" + this.mConfig.getString(proptype, null));
                params.addElement(propsource + "=" + this.mConfig.getString(propsource, null));
                params.addElement(propvalue + "=" + this.mConfig.getString(propvalue, null));
            }
            params.addElement("predicate=" + this.mConfig.getString(PROP_PREDICATE, null));
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        return params;
    }

    public Vector<String> getDefaultParams() {
        int idx = 0;
        Vector<String> defParams = new Vector<String>();
        defParams.addElement("critical=false");
        defParams.addElement("name=");
        defParams.addElement("oid=");
        defParams.addElement("pattern=");
        for (idx = 0; idx < 10; ++idx) {
            defParams.addElement("attribute." + idx + ".type=");
            defParams.addElement("attribute." + idx + ".source=");
            defParams.addElement("attribute." + idx + ".value=");
        }
        return defParams;
    }
}

