/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.ca.rest;

import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.cert.CertData;
import com.netscape.certsrv.cert.CertDataInfo;
import com.netscape.certsrv.cert.CertDataInfos;
import com.netscape.certsrv.cert.CertNotFoundException;
import com.netscape.certsrv.cert.CertResource;
import com.netscape.certsrv.cert.CertRetrievalRequest;
import com.netscape.certsrv.cert.CertSearchRequest;
import com.netscape.certsrv.dbs.EDBRecordNotFoundException;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.cms.servlet.base.PKIService;
import com.netscape.cms.servlet.cert.FilterBuilder;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertRecordList;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.dbs.RevocationInfo;
import com.netscape.cmscore.security.JssSubsystem;
import com.netscape.cmsutil.ldap.LDAPUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.dogtag.util.cert.CertUtil;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.pkcs.ContentInfo;
import org.mozilla.jss.netscape.security.pkcs.PKCS7;
import org.mozilla.jss.netscape.security.pkcs.SignerInfo;
import org.mozilla.jss.netscape.security.provider.RSAPublicKey;
import org.mozilla.jss.netscape.security.util.CertPrettyPrint;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.CRLExtensions;
import org.mozilla.jss.netscape.security.x509.CRLReasonExtension;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509ExtensionException;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertService
extends PKIService
implements CertResource {
    public static final Logger logger = LoggerFactory.getLogger(CertService.class);
    CertificateRepository repo;
    SecureRandom random;
    public static final int DEFAULT_MAXTIME = 0;
    public static final int DEFAULT_MAXRESULTS = 20;

    public CertService() {
        CAEngine engine = CAEngine.getInstance();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        if (engine.getEnableNonces()) {
            this.random = jssSubsystem.getRandomNumberGenerator();
        }
        this.repo = engine.getCertificateRepository();
    }

    public Response getCert(CertId id) {
        logger.info("Getting certificate " + id.toHexString());
        return this.createOKResponse(this.getCertData(id));
    }

    CertData getCertData(CertId id) {
        return this.getCertData(id, false);
    }

    CertData getCertData(CertId id, boolean generateNonce) {
        if (id == null) {
            throw new BadRequestException("Unable to get certificate: Missing certificate ID");
        }
        CertRetrievalRequest data = new CertRetrievalRequest(id);
        CertData certData = null;
        try {
            certData = this.getCert(data, generateNonce);
        }
        catch (EDBRecordNotFoundException e) {
            throw new CertNotFoundException(id);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage(), (Throwable)e);
        }
        return certData;
    }

    String createSearchFilter(String status) {
        Object filter = status == null ? "(certstatus=*)" : "(certStatus=" + LDAPUtil.escapeFilter((Object)status) + ")";
        return filter;
    }

    String createSearchFilter(CertSearchRequest data) {
        if (data == null) {
            return null;
        }
        FilterBuilder builder = new FilterBuilder(data);
        return builder.buildFilter();
    }

    public Response listCerts(String status, Integer maxResults, Integer maxTime, Integer start, Integer size) {
        logger.info("Listing certificates");
        maxResults = maxResults == null ? 20 : maxResults;
        maxTime = maxTime == null ? 0 : maxTime;
        start = start == null ? 0 : start;
        size = size == null ? 20 : size;
        String filter = this.createSearchFilter(status);
        logger.info("Search filter: " + filter);
        CertDataInfos infos = new CertDataInfos();
        try {
            Enumeration<CertRecord> e = this.repo.searchCertificates(filter, (int)maxResults, maxTime);
            if (e == null) {
                throw new EBaseException("search results are null");
            }
            ArrayList<CertDataInfo> results = new ArrayList<CertDataInfo>();
            while (e.hasMoreElements()) {
                CertRecord rec = e.nextElement();
                if (rec == null) continue;
                results.add(this.createCertDataInfo(rec));
            }
            int total = results.size();
            logger.info("Search results: " + total);
            infos.setTotal(total);
            for (int i = start.intValue(); i < start + size && i < total; ++i) {
                infos.addEntry((Object)((CertDataInfo)results.get(i)));
            }
        }
        catch (Exception e) {
            logger.error("Unable to list certificates: " + e.getMessage(), (Throwable)e);
            throw new PKIException("Unable to list certificates: " + e.getMessage(), (Throwable)e);
        }
        return this.createOKResponse(infos);
    }

    public Response searchCerts(String searchRequest, Integer start, Integer size) {
        logger.info("Searching for certificates");
        CertSearchRequest data = (CertSearchRequest)this.unmarshall(searchRequest, CertSearchRequest.class);
        if (data == null) {
            throw new BadRequestException("Search request is null");
        }
        start = start == null ? 0 : start;
        size = size == null ? 20 : size;
        String filter = this.createSearchFilter(data);
        logger.info("Search filter: " + filter);
        CertDataInfos infos = new CertDataInfos();
        try {
            CertRecordList list = this.repo.findCertRecordsInList(filter, null, "serialno", size);
            int total = list.getSize();
            logger.info("Search results: " + total);
            for (int i = start.intValue(); i < start + size && i < total; ++i) {
                CertRecord record = list.getCertRecord(i);
                if (record == null) {
                    logger.warn("Certificate record not found");
                    throw new PKIException("Certificate record not found");
                }
                infos.addEntry((Object)this.createCertDataInfo(record));
            }
            infos.setTotal(total);
        }
        catch (Exception e) {
            logger.error("Unable to search for certificates: " + e.getMessage(), (Throwable)e);
            throw new PKIException("Unable to search for certificates: " + e.getMessage(), (Throwable)e);
        }
        return this.createOKResponse(infos);
    }

    CertData getCert(CertRetrievalRequest data, boolean generateNonce) throws Exception {
        CRLExtensions revExts;
        Date notAfter;
        X500Name subjectDN;
        CAEngine engine = CAEngine.getInstance();
        CertId certId = data.getCertId();
        CertRecord record = this.repo.readCertificateRecord(certId.toBigInteger());
        X509CertImpl cert = record.getCertificate();
        CertData certData = new CertData();
        certData.setSerialNumber(certId);
        X500Name issuerDN = cert.getIssuerName();
        if (issuerDN != null) {
            certData.setIssuerDN(issuerDN.toString());
        }
        if ((subjectDN = cert.getSubjectName()) != null) {
            certData.setSubjectDN(subjectDN.toString());
        }
        String base64 = CertUtil.toPEM((X509Certificate)cert);
        certData.setEncoded(base64);
        CertPrettyPrint print = new CertPrettyPrint((Certificate)cert);
        certData.setPrettyPrint(print.toString(this.getLocale(this.headers)));
        X509Certificate[] certChain = engine.getCertChain((X509Certificate)cert);
        PKCS7 pkcs7 = new PKCS7(new AlgorithmId[0], new ContentInfo(new byte[0]), certChain, new SignerInfo[0]);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        pkcs7.encodeSignedData((OutputStream)bos, false);
        byte[] p7Bytes = bos.toByteArray();
        String p7Str = Utils.base64encode((byte[])p7Bytes, (boolean)true);
        certData.setPkcs7CertChain(p7Str);
        Date notBefore = cert.getNotBefore();
        if (notBefore != null) {
            certData.setNotBefore(notBefore.toString());
        }
        if ((notAfter = cert.getNotAfter()) != null) {
            certData.setNotAfter(notAfter.toString());
        }
        certData.setRevokedOn(record.getRevokedOn());
        certData.setRevokedBy(record.getRevokedBy());
        RevocationInfo revInfo = record.getRevocationInfo();
        if (revInfo != null && (revExts = revInfo.getCRLEntryExtensions()) != null) {
            try {
                CRLReasonExtension ext = (CRLReasonExtension)revExts.get("CRLReason");
                certData.setRevocationReason(Integer.valueOf(ext.getReason().getCode()));
            }
            catch (X509ExtensionException x509ExtensionException) {
                // empty catch block
            }
        }
        certData.setStatus(record.getStatus());
        if (engine.getEnableNonces() && generateNonce) {
            long n = this.random.nextLong();
            Map<Object, Long> nonces = engine.getNonces(this.servletRequest, "cert-revoke");
            nonces.put(certId.toBigInteger(), n);
            certData.setNonce(Long.valueOf(n));
        }
        return certData;
    }

    CertDataInfo createCertDataInfo(CertRecord record) throws EBaseException, InvalidKeyException {
        CertDataInfo info = new CertDataInfo();
        CertId id = new CertId(record.getSerialNumber());
        info.setID(id);
        X509CertImpl cert = record.getCertificate();
        info.setIssuerDN(cert.getIssuerDN().toString());
        info.setSubjectDN(cert.getSubjectDN().toString());
        info.setStatus(record.getStatus());
        info.setVersion(Integer.valueOf(cert.getVersion()));
        info.setType(cert.getType());
        PublicKey key = cert.getPublicKey();
        if (key instanceof X509Key) {
            X509Key x509Key = (X509Key)key;
            info.setKeyAlgorithmOID(x509Key.getAlgorithmId().getOID().toString());
            if (x509Key.getAlgorithmId().toString().equalsIgnoreCase("RSA")) {
                RSAPublicKey rsaKey = new RSAPublicKey(x509Key.getEncoded());
                info.setKeyLength(Integer.valueOf(rsaKey.getKeySize()));
            }
        }
        info.setNotValidBefore(cert.getNotBefore());
        info.setNotValidAfter(cert.getNotAfter());
        info.setIssuedOn(record.getCreateTime());
        info.setIssuedBy(record.getIssuedBy());
        info.setRevokedOn(record.getRevokedOn());
        info.setRevokedBy(record.getRevokedBy());
        return info;
    }
}

