/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.authentication;

import com.netscape.certsrv.authentication.EAuthException;
import com.netscape.cms.authentication.RDNPattern;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.Vector;
import netscape.ldap.LDAPEntry;

public class DNPattern {
    private String[] mLdapAttrs = null;
    protected RDNPattern[] mRDNPatterns = null;
    protected String mPatternString = null;
    protected String mTestDN = null;

    public DNPattern(String pattern) throws EAuthException {
        if (pattern == null || pattern.equals("")) {
            this.mLdapAttrs = new String[]{"dn"};
        } else {
            this.mPatternString = pattern;
            PushbackReader in = new PushbackReader(new StringReader(pattern));
            this.parse(in);
        }
    }

    public DNPattern(PushbackReader in) throws EAuthException {
        this.parse(in);
    }

    private void parse(PushbackReader in) throws EAuthException {
        Vector<RDNPattern> rdnPatterns = new Vector<RDNPattern>();
        RDNPattern rdnPattern = null;
        int lastChar = -1;
        do {
            rdnPattern = new RDNPattern(in);
            rdnPatterns.addElement(rdnPattern);
            try {
                lastChar = in.read();
            }
            catch (IOException e) {
                throw new EAuthException("CMS_AUTHENTICATION_INTERNAL_ERROR", (Exception)e);
            }
        } while (lastChar == 44);
        this.mRDNPatterns = new RDNPattern[rdnPatterns.size()];
        rdnPatterns.copyInto(this.mRDNPatterns);
        Vector<String> ldapAttrs = new Vector<String>();
        for (int i = 0; i < this.mRDNPatterns.length; ++i) {
            String[] rdnAttrs = this.mRDNPatterns[i].getLdapAttrs();
            if (rdnAttrs == null || rdnAttrs.length <= 0) continue;
            for (int j = 0; j < rdnAttrs.length; ++j) {
                ldapAttrs.addElement(rdnAttrs[j]);
            }
        }
        this.mLdapAttrs = new String[ldapAttrs.size()];
        ldapAttrs.copyInto(this.mLdapAttrs);
    }

    public String formDN(LDAPEntry entry) throws EAuthException {
        StringBuffer formedDN = new StringBuffer();
        for (int i = 0; i < this.mRDNPatterns.length; ++i) {
            String rdn;
            if (this.mTestDN != null) {
                this.mRDNPatterns[i].mTestDN = this.mTestDN;
            }
            if ((rdn = this.mRDNPatterns[i].formRDN(entry)) == null || rdn == null || rdn.length() == 0) continue;
            if (formedDN.length() != 0) {
                formedDN.append(",");
            }
            formedDN.append(rdn);
        }
        return formedDN.toString();
    }

    public String[] getLdapAttrs() {
        return (String[])this.mLdapAttrs.clone();
    }
}

