/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.realm;

import com.netscape.cms.realm.PKIPrincipal;
import com.netscape.cms.realm.RealmCommon;
import com.netscape.cmscore.usrgrp.User;
import java.io.FileReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.MessageDigestCredentialHandler;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKIPostgreSQLRealm
extends RealmCommon {
    public static final Logger logger = LoggerFactory.getLogger(PKIPostgreSQLRealm.class);
    Properties info;
    String url;
    Properties statements;
    Connection connection;
    MessageDigestCredentialHandler handler;

    public void initInternal() throws LifecycleException {
        logger.info("Initializing PostgreSQL realm");
        this.info = new Properties();
        for (String name : this.config.getParameterNames()) {
            String value = this.config.getParameter(name);
            if (!"password".equals(name)) {
                logger.info("- " + name + ": " + value);
            }
            this.info.put(name, value);
        }
        this.url = (String)this.info.remove("url");
        String statementsFilename = this.info.getProperty("statements");
        logger.info("Loading statements from " + statementsFilename);
        this.statements = new Properties();
        try (FileReader reader = new FileReader(statementsFilename);){
            this.statements.load(reader);
        }
        catch (Exception e) {
            throw new LifecycleException("Cannot read statements file: " + statementsFilename, (Throwable)e);
        }
        for (String name : this.statements.stringPropertyNames()) {
            String value = this.statements.getProperty(name);
            logger.info("- " + name + ": " + value);
        }
        logger.info("Initializing credential handler:");
        String algorithm = this.info.getProperty("credentialHandler.algorithm");
        if (algorithm == null) {
            algorithm = "SHA-512";
        }
        logger.info("- algorithm: " + algorithm);
        String encoding = this.info.getProperty("credentialHandler.encoding");
        logger.info("- encoding: " + encoding);
        String iterations = this.info.getProperty("credentialHandler.iterations");
        logger.info("- iterations: " + iterations);
        String saltLength = this.info.getProperty("credentialHandler.saltLength");
        logger.info("- salt length: " + saltLength);
        this.handler = new MessageDigestCredentialHandler();
        try {
            this.handler.setAlgorithm(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new LifecycleException("No such algorithm: " + algorithm, (Throwable)e);
        }
        if (encoding != null) {
            this.handler.setEncoding(encoding);
        }
        if (iterations != null) {
            this.handler.setIterations(Integer.parseInt(iterations));
        }
        if (saltLength != null) {
            this.handler.setSaltLength(Integer.parseInt(saltLength));
        }
    }

    public void setup() throws Exception {
        String[] stats;
        logger.info("Setting up PostgreSQL realm");
        String filename = "/usr/share/pki/acme/realm/postgresql/create.sql";
        String content = new String(Files.readAllBytes(Paths.get(filename, new String[0])));
        for (String sql : stats = content.split(";")) {
            if (StringUtils.isEmpty((CharSequence)(sql = sql.trim()))) continue;
            logger.info("SQL: " + sql);
            try (PreparedStatement ps = this.connection.prepareStatement(sql);){
                ps.executeUpdate();
            }
            catch (SQLException e) {
                String sqlState = e.getSQLState();
                if ("42P07".equals(sqlState)) continue;
                logger.error("Unable to set up PostgreSQL realm: " + e.getMessage());
                logger.error("SQL state: " + sqlState);
                throw e;
            }
        }
    }

    public void connect() throws Exception {
        if (this.connection == null) {
            logger.info("Connecting to " + this.url);
            this.connection = DriverManager.getConnection(this.url, this.info);
            this.setup();
            return;
        }
        try (Statement st = this.connection.createStatement();){
            ResultSet rs = st.executeQuery("SELECT 1");
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            if (this.connection.isClosed()) {
                logger.info("Reconnecting to " + this.url);
                this.connection = DriverManager.getConnection(this.url, this.info);
                return;
            }
            logger.error("Unable to access database: " + e.getMessage());
            logger.error("SQL state: " + e.getSQLState());
            throw e;
        }
    }

    public User createUser(ResultSet rs) throws Exception {
        User user = new User();
        String userID = rs.getString("id");
        user.setUserID(userID);
        String fullName = rs.getString("full_name");
        user.setFullName(fullName);
        String password = rs.getString("password");
        user.setPassword(password);
        return user;
    }

    public User getUserByID(String userID) throws Exception {
        logger.info("Getting user " + userID);
        String sql = this.statements.getProperty("getUserByID");
        logger.info("SQL: " + sql);
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            User user;
            block16: {
                ResultSet rs;
                block14: {
                    User user2;
                    block15: {
                        ps.setString(1, userID);
                        rs = ps.executeQuery();
                        try {
                            if (rs.next()) break block14;
                            user2 = null;
                            if (rs == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return user2;
                }
                user = this.createUser(rs);
                if (rs == null) break block16;
                rs.close();
            }
            return user;
        }
    }

    public String getCertID(X509Certificate cert) {
        return cert.getVersion() + ";" + cert.getSerialNumber() + ";" + cert.getIssuerDN() + ";" + cert.getSubjectDN();
    }

    public User getUserByCertID(String certID) throws Exception {
        logger.info("Getting user for cert " + certID);
        String sql = this.statements.getProperty("getUserByCertID");
        logger.info("SQL: " + sql);
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            User user;
            block16: {
                ResultSet rs;
                block14: {
                    User user2;
                    block15: {
                        ps.setString(1, certID);
                        rs = ps.executeQuery();
                        try {
                            if (rs.next()) break block14;
                            user2 = null;
                            if (rs == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return user2;
                }
                user = this.createUser(rs);
                if (rs == null) break block16;
                rs.close();
            }
            return user;
        }
    }

    public List<X509Certificate> getUserCerts(String userID) throws Exception {
        logger.info("Getting certs for user " + userID);
        String sql = this.statements.getProperty("getUserCerts");
        logger.info("SQL: " + sql);
        ArrayList<X509Certificate> results = new ArrayList<X509Certificate>();
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            ps.setString(1, userID);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    byte[] data = rs.getBytes("data");
                    results.add((X509Certificate)new X509CertImpl(data));
                }
            }
        }
        return results;
    }

    public List<String> getUserRoles(String userID) throws Exception {
        logger.info("Getting roles for user " + userID);
        String sql = this.statements.getProperty("getUserRoles");
        logger.info("SQL: " + sql);
        ArrayList<String> roles = new ArrayList<String>();
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            ps.setString(1, userID);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String rolename = rs.getString("group_id");
                    roles.add(rolename);
                }
            }
        }
        return roles;
    }

    @Override
    public Principal authenticate(String username, String credentials) {
        logger.info("Authenticating user " + username + " with password");
        try {
            this.connect();
            logger.info("Searching for user " + username);
            User user = this.getUserByID(username);
            if (user == null) {
                logger.warn("Unable to authenticate user " + username + ": User not found");
                return null;
            }
            logger.info("Validating password for user " + username);
            String storedCredentials = user.getPassword();
            if (!this.handler.matches(credentials, storedCredentials)) {
                logger.warn("Unable to authenticate user " + username + ": Invalid password");
                return null;
            }
            logger.info("User " + username + " authenticated");
            List<String> roles = this.getUserRoles(username);
            return new PKIPrincipal(user, null, roles);
        }
        catch (Exception e) {
            logger.error("Problem to verify user credentials: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Principal authenticate(X509Certificate[] certChain) {
        try {
            certChain = Cert.sortCertificateChain((X509Certificate[])certChain, (boolean)true);
            X509Certificate cert = certChain[0];
            String certID = this.getCertID(cert);
            logger.info("Authenticating user with certificate " + certID);
            this.connect();
            logger.info("Searching for user with certificate " + certID);
            User user = this.getUserByCertID(certID);
            if (user == null) {
                logger.warn("Unable to authenticate user with certificate " + certID + ": User not found");
                return null;
            }
            logger.info("Searching for matching certificates in user " + user.getUserID());
            List<X509Certificate> certs = this.getUserCerts(user.getUserID());
            if (certs == null || certs.isEmpty()) {
                logger.warn("Unable to authenticate user " + user.getUserID() + ": User has no certificates");
                return null;
            }
            boolean found = false;
            byte[] data = cert.getEncoded();
            for (X509Certificate c : certs) {
                if (!Arrays.equals(data, c.getEncoded())) continue;
                found = true;
                break;
            }
            if (!found) {
                logger.warn("Unable to authenticate user " + user.getUserID() + ": No matching certificate");
                return null;
            }
            logger.info("User " + user.getUserID() + " authenticated");
            List<String> roles = this.getUserRoles(user.getUserID());
            return new PKIPrincipal(user, null, roles);
        }
        catch (Exception e) {
            logger.error("Problem to verify the certificate", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void stopInternal() throws LifecycleException {
        logger.info("Shutting down PostgreSQL realm");
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception e) {
                throw new LifecycleException("Cannot close the DB connection: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

