/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.admin;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.logging.ELogException;
import com.netscape.certsrv.logging.ELogNotFound;
import com.netscape.certsrv.logging.ELogPluginNotFound;
import com.netscape.certsrv.logging.LogEventListener;
import com.netscape.certsrv.logging.LogPlugin;
import com.netscape.certsrv.logging.event.ConfigSignedAuditEvent;
import com.netscape.cms.servlet.admin.AdminServlet;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.logging.LogSubsystem;
import com.netscape.cmscore.logging.LoggerConfig;
import com.netscape.cmscore.logging.LoggerPluginsConfig;
import com.netscape.cmscore.logging.LoggersConfig;
import com.netscape.cmscore.logging.LoggingConfig;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogAdminServlet
extends AdminServlet {
    public static Logger logger = LoggerFactory.getLogger(LogAdminServlet.class);
    private static final long serialVersionUID = -99699953656847603L;
    private static final String INFO = "LogAdminServlet";
    private LogSubsystem logSubsystem;
    private static final String SIGNED_AUDIT_LOG_TYPE = "SignedAudit";

    public static Hashtable<String, String> toHashtable(HttpServletRequest req) {
        Hashtable<String, String> httpReqHash = new Hashtable<String, String>();
        Enumeration names = req.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            httpReqHash.put(name, req.getParameter(name));
        }
        return httpReqHash;
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        CMSEngine engine = this.getCMSEngine();
        this.logSubsystem = engine.getLogSubsystem();
    }

    public String getServletInfo() {
        return INFO;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
        op = req.getParameter("OP_TYPE");
        if (op == null) {
            this.sendResponse(LogAdminServlet.ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_INVALID_PROTOCOL", new String[0]), null, resp);
            return;
        }
        super.authenticate(req);
        try {
            block44: {
                scope = req.getParameter("OP_SCOPE");
                if (scope == null) return;
                LogAdminServlet.AUTHZ_RES_NAME = "certServer.log.configuration";
                if (!scope.equals("extendedPluginInfo")) ** GOTO lbl29
                this.mOp = "read";
                this.mToken = super.authorize(req);
                if (this.mToken != null) break block44;
                this.sendResponse(LogAdminServlet.ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                return;
                {
                    catch (EBaseException e) {
                        this.sendResponse(LogAdminServlet.ERROR, e.toString(this.getLocale(req)), null, resp);
                        return;
                    }
                }
            }
            try {
                this.getExtendedPluginInfo(req, resp);
                return;
            }
            catch (EBaseException e) {
                this.sendResponse(LogAdminServlet.ERROR, e.toString(this.getLocale(req)), null, resp);
                return;
lbl29:
                // 1 sources

                if (op.equals("OP_READ")) {
                    this.mOp = "read";
                    this.mToken = super.authorize(req);
                    if (this.mToken == null) {
                        this.sendResponse(LogAdminServlet.ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                        return;
                    }
                    if (scope.equals("logImpls")) {
                        this.getConfig(req, resp);
                        return;
                    }
                    if (scope.equals("logRule")) {
                        this.getInstConfig(req, resp);
                        return;
                    }
                    if (scope.equals("general")) {
                        this.getGeneralConfig(req, resp);
                        return;
                    }
                    this.sendResponse(LogAdminServlet.ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_INVALID_OP_SCOPE", new String[0]), null, resp);
                    return;
                }
                if (op.equals("OP_DELETE")) {
                    this.mOp = "modify";
                    this.mToken = super.authorize(req);
                    if (this.mToken == null) {
                        this.sendResponse(LogAdminServlet.ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                        return;
                    }
                    if (scope.equals("logImpls")) {
                        this.delLogPlugin(req, resp, scope);
                        return;
                    }
                    if (scope.equals("logRule")) {
                        this.delLogInst(req, resp, scope);
                        return;
                    }
                    this.sendResponse(LogAdminServlet.ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_INVALID_OP_SCOPE", new String[0]), null, resp);
                    return;
                }
                if (op.equals("OP_ADD")) {
                    this.mOp = "modify";
                    this.mToken = super.authorize(req);
                    if (this.mToken == null) {
                        this.sendResponse(LogAdminServlet.ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                        return;
                    }
                    if (scope.equals("logImpls")) {
                        this.addLogPlugin(req, resp, scope);
                        return;
                    }
                    if (scope.equals("logRule")) {
                        this.addLogInst(req, resp, scope);
                        return;
                    }
                    this.sendResponse(LogAdminServlet.ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_INVALID_OP_SCOPE", new String[0]), null, resp);
                    return;
                }
                if (op.equals("OP_MODIFY")) {
                    LogAdminServlet.AUTHZ_RES_NAME = "certServer.log.configuration";
                    this.mOp = "modify";
                    this.mToken = super.authorize(req);
                    if (this.mToken == null) {
                        this.sendResponse(LogAdminServlet.ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                        return;
                    }
                    if (scope.equals("logRule")) {
                        this.modLogInst(req, resp, scope);
                        return;
                    }
                    if (scope.equals("general")) {
                        this.setGeneralConfig(req, resp);
                        return;
                    }
                    this.sendResponse(LogAdminServlet.ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_INVALID_OP_SCOPE", new String[0]), null, resp);
                    return;
                }
                if (!op.equals("OP_SEARCH")) {
                    this.sendResponse(LogAdminServlet.ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_INVALID_OP_TYPE", new String[]{op}), null, resp);
                    return;
                }
                this.mOp = "read";
                this.mToken = super.authorize(req);
                if (this.mToken == null) {
                    this.sendResponse(LogAdminServlet.ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                    return;
                }
                if (scope.equals("logImpls")) {
                    this.listLogPlugins(req, resp);
                    return;
                }
                if (scope.equals("logRule")) {
                    this.listLogInsts(req, resp, true);
                    return;
                }
                if (scope.equals("log_instances")) {
                    this.listLogInsts(req, resp, false);
                    return;
                }
                if (scope.equals("log_content")) {
                    instName = req.getParameter("instanceName");
                    if (instName.equals("System")) {
                        LogAdminServlet.AUTHZ_RES_NAME = "certServer.log.content.system";
                    } else if (instName.equals("Transactions")) {
                        LogAdminServlet.AUTHZ_RES_NAME = "certServer.log.content.transactions";
                    } else if (instName.equals("SignedAudit")) {
                        LogAdminServlet.AUTHZ_RES_NAME = "certServer.log.content.signedAudit";
                    }
                    this.mOp = "read";
                    this.mToken = super.authorize(req);
                    if (this.mToken == null) {
                        this.sendResponse(LogAdminServlet.ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                        return;
                    }
                    loginst = this.logSubsystem.getLogInstance(instName);
                    if (loginst == null) return;
                    nvps = loginst.retrieveLogContent(LogAdminServlet.toHashtable(req));
                    this.sendResponse(LogAdminServlet.SUCCESS, null, nvps, resp);
                    return;
                }
                if (!scope.equals("logArch")) {
                    this.sendResponse(LogAdminServlet.ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_INVALID_OP_SCOPE", new String[0]), null, resp);
                    return;
                }
                instName = req.getParameter("instanceName");
                if (instName.equals("System")) {
                    LogAdminServlet.AUTHZ_RES_NAME = "certServer.log.content.system";
                } else if (instName.equals("Transactions")) {
                    LogAdminServlet.AUTHZ_RES_NAME = "certServer.log.content.transactions";
                } else if (instName.equals("SignedAudit")) {
                    LogAdminServlet.AUTHZ_RES_NAME = "certServer.log.content.signedAudit";
                }
                this.mOp = "read";
                this.mToken = super.authorize(req);
                if (this.mToken == null) {
                    this.sendResponse(LogAdminServlet.ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                    return;
                }
                loginst = this.logSubsystem.getLogInstance(instName);
                if (loginst == null) return;
                nvps = loginst.retrieveLogList(LogAdminServlet.toHashtable(req));
                this.sendResponse(LogAdminServlet.SUCCESS, null, nvps, resp);
                return;
            }
        }
        catch (Exception e) {
            System.out.println("XXX >>>" + e.toString() + "<<<");
            e.printStackTrace();
            this.sendResponse(LogAdminServlet.ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_INVALID_PROTOCOL", new String[0]), null, resp);
        }
    }

    private synchronized void listLogInsts(HttpServletRequest req, HttpServletResponse resp, boolean all) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        CMSEngine engine = this.getCMSEngine();
        Enumeration<String> e = this.logSubsystem.getLogInsts().keys();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            LogEventListener value = this.logSubsystem.getLogInstance(name);
            if (value == null) continue;
            String pName = this.logSubsystem.getLogPluginName(value);
            LogPlugin pClass = this.logSubsystem.getLogPlugins().get(pName);
            String c = pClass.getClassPath();
            if (!all && (all || c.endsWith("NTEventLog"))) continue;
            params.put((Object)name, (Object)(pName + ";visible"));
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void getExtendedPluginInfo(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        String id = req.getParameter("RS_ID");
        int colon = id.indexOf(58);
        String implName = id.substring(colon + 1);
        NameValuePairs params = this.getExtendedPluginInfo(implName);
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private NameValuePairs getExtendedPluginInfo(String implName) {
        IExtendedPluginInfo ext_info = null;
        IExtendedPluginInfo impl = null;
        LogPlugin lp = this.logSubsystem.getLogPlugins().get(implName);
        if (lp != null) {
            impl = LogAdminServlet.getClassByNameAsExtendedPluginInfo(lp.getClassPath());
        }
        if (impl != null && impl instanceof IExtendedPluginInfo) {
            ext_info = impl;
        }
        NameValuePairs nvps = null;
        nvps = ext_info == null ? new NameValuePairs() : this.convertStringArrayToNVPairs(ext_info.getExtendedPluginInfo());
        return nvps;
    }

    private synchronized void addLogPlugin(HttpServletRequest req, HttpServletResponse resp, String scope) throws ServletException, IOException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        try {
            String id;
            String logType = null;
            logType = id = req.getParameter("RS_ID");
            if (logType == null) {
                logType = SIGNED_AUDIT_LOG_TYPE;
            }
            if (id == null) {
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
                return;
            }
            if (this.logSubsystem.getLogPlugins().containsKey(id)) {
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, new ELogException(CMS.getUserMessage(this.getLocale(req), "CMS_LOG_SRVLT_ILL_PLUGIN_ID", id)).toString(), null, resp);
                return;
            }
            String classPath = req.getParameter("class");
            if (classPath == null) {
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_LOG_SRVLT_NULL_CLASS", new String[0]), null, resp);
                return;
            }
            LoggingConfig destStore = this.mConfig.getLoggingConfig();
            LoggerPluginsConfig instancesConfig = destStore.getLoggerPluginsConfig();
            Class<?> newImpl = null;
            try {
                newImpl = Class.forName(classPath);
            }
            catch (ClassNotFoundException e) {
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_LOG_SRVLT_NO_CLASS", new String[0]), null, resp);
                return;
            }
            catch (IllegalArgumentException e) {
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_LOG_SRVLT_NO_CLASS", new String[0]), null, resp);
                return;
            }
            try {
                if (!LogEventListener.class.isAssignableFrom(newImpl)) {
                    if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                        auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                    }
                    this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_LOG_SRVLT_ILL_CLASS", new String[0]), null, resp);
                    return;
                }
            }
            catch (NullPointerException e) {
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_LOG_SRVLT_ILL_CLASS", new String[0]), null, resp);
                return;
            }
            ConfigStore substore = instancesConfig.makeSubStore(id);
            substore.put("class", classPath);
            try {
                this.mConfig.commit(true);
            }
            catch (EBaseException e) {
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_COMMIT_FAILED", new String[0]), null, resp);
                return;
            }
            LogPlugin plugin = new LogPlugin(id, classPath);
            this.logSubsystem.getLogPlugins().put(id, plugin);
            NameValuePairs params = new NameValuePairs();
            if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Success", this.auditParams(req)));
            }
            this.sendResponse(SUCCESS, null, params, resp);
            return;
        }
        catch (IOException eAudit2) {
            auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
            throw eAudit2;
        }
    }

    private boolean isValidID(String id) {
        if (id == null) {
            return false;
        }
        for (int i = 0; i < id.length(); ++i) {
            if (Character.isLetterOrDigit(id.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private synchronized void addLogInst(HttpServletRequest req, HttpServletResponse resp, String scope) throws ServletException, IOException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        try {
            String id;
            String logType = null;
            logType = id = req.getParameter("RS_ID");
            if (logType == null) {
                logType = SIGNED_AUDIT_LOG_TYPE;
            }
            if (id == null) {
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
                return;
            }
            if (!this.isValidID(id)) {
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, "Invalid ID '" + id + "'", null, resp);
                return;
            }
            if (this.logSubsystem.getLogInsts().containsKey(id)) {
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_LOG_SRVLT_ILL_INST_ID", new String[0]), null, resp);
                return;
            }
            String implname = req.getParameter("implName");
            if (implname == null) {
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_LOG_SRVLT_ADD_MISSING_PARAMS", new String[0]), null, resp);
                return;
            }
            LogPlugin plugin = this.logSubsystem.getLogPlugins().get(implname);
            if (plugin == null) {
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, new ELogPluginNotFound(CMS.getUserMessage(this.getLocale(req), "CMS_LOG_PLUGIN_NOT_FOUND", implname)).toString(), null, resp);
                return;
            }
            Vector<String> configParams = this.logSubsystem.getLogDefaultParams(implname);
            LoggingConfig destStore = this.mConfig.getLoggingConfig();
            LoggersConfig instancesConfig = destStore.getLoggersConfig();
            LoggerConfig loggerConfig = instancesConfig.createLoggerConfig(id);
            if (configParams != null) {
                for (int i = 0; i < configParams.size(); ++i) {
                    int index;
                    String kv = configParams.elementAt(i);
                    String key = kv.substring(0, index = kv.indexOf(61));
                    String val = req.getParameter(key);
                    if (val == null) {
                        val = kv.substring(index + 1);
                    }
                    loggerConfig.put(key, val);
                }
            }
            loggerConfig.put("pluginName", implname);
            loggerConfig.put("expirationTime", "0");
            String className = plugin.getClassPath();
            LogEventListener logInst = null;
            try {
                logInst = (LogEventListener)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                instancesConfig.removeSubStore(id);
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, new ELogException(CMS.getUserMessage(this.getLocale(req), "CMS_LOG_LOAD_CLASS_FAIL", className)).toString(), null, resp);
                return;
            }
            try {
                logInst.setCMSEngine(engine);
                logInst.init(this.logSubsystem, loggerConfig);
            }
            catch (EBaseException e) {
                instancesConfig.removeSubStore(id);
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, e.toString(this.getLocale(req)), null, resp);
                return;
            }
            catch (Throwable e) {
                instancesConfig.removeSubStore(id);
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, e.toString(), null, resp);
                return;
            }
            try {
                this.mConfig.commit(true);
            }
            catch (EBaseException e) {
                instancesConfig.removeSubStore(id);
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_COMMIT_FAILED", new String[0]), null, resp);
                return;
            }
            this.logSubsystem.getLogInsts().put(id, logInst);
            NameValuePairs params = new NameValuePairs();
            params.put((Object)"implName", (Object)implname);
            if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Success", this.auditParams(req)));
            }
            this.sendResponse(SUCCESS, null, params, resp);
            return;
        }
        catch (IOException eAudit2) {
            auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
            throw eAudit2;
        }
    }

    private synchronized void listLogPlugins(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        Enumeration<String> e = this.logSubsystem.getLogPlugins().keys();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            LogPlugin value = this.logSubsystem.getLogPlugins().get(name);
            String c = value.getClassPath();
            String desc = "unknown";
            try {
                LogEventListener lp = (LogEventListener)Class.forName(c).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                desc = lp.getDescription();
            }
            catch (Exception exp) {
                this.sendResponse(ERROR, exp.toString(), null, resp);
                return;
            }
            params.put((Object)name, (Object)(value.getClassPath() + "," + desc));
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    public String getLogPluginName(LogEventListener log) {
        ConfigStore cs = log.getConfigStore();
        try {
            return cs.getString("pluginName", "");
        }
        catch (EBaseException e) {
            return "";
        }
    }

    private synchronized void delLogInst(HttpServletRequest req, HttpServletResponse resp, String scope) throws ServletException, IOException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        try {
            String id;
            String logType = null;
            NameValuePairs params = new NameValuePairs();
            logType = id = req.getParameter("RS_ID");
            if (logType == null) {
                logType = SIGNED_AUDIT_LOG_TYPE;
            }
            if (id == null) {
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
                return;
            }
            if (!this.logSubsystem.getLogInsts().containsKey(id)) {
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, new ELogNotFound(CMS.getUserMessage(this.getLocale(req), "CMS_LOG_INSTANCE_NOT_FOUND", id)).toString(), null, resp);
                return;
            }
            this.logSubsystem.getLogInsts().remove(id);
            LoggingConfig destStore = this.mConfig.getLoggingConfig();
            LoggersConfig instancesConfig = destStore.getLoggersConfig();
            instancesConfig.removeLoggerConfig(id);
            try {
                this.mConfig.commit(true);
            }
            catch (EBaseException e) {
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_COMMIT_FAILED", new String[0]), null, resp);
                return;
            }
            if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Success", this.auditParams(req)));
            }
            this.sendResponse(SUCCESS, null, params, resp);
            return;
        }
        catch (IOException eAudit2) {
            auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
            throw eAudit2;
        }
    }

    private synchronized void delLogPlugin(HttpServletRequest req, HttpServletResponse resp, String scope) throws ServletException, IOException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        try {
            String id;
            String logType = null;
            NameValuePairs params = new NameValuePairs();
            logType = id = req.getParameter("RS_ID");
            if (logType == null) {
                logType = SIGNED_AUDIT_LOG_TYPE;
            }
            if (id == null) {
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
                return;
            }
            if (!this.logSubsystem.getLogPlugins().containsKey(id)) {
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, new ELogPluginNotFound(CMS.getUserMessage(this.getLocale(req), "CMS_LOG_PLUGIN_NOT_FOUND", id)).toString(), null, resp);
                return;
            }
            Enumeration<String> e = this.logSubsystem.getLogInsts().keys();
            while (e.hasMoreElements()) {
                String name = e.nextElement();
                LogEventListener log = this.logSubsystem.getLogInstance(name);
                if (this.getLogPluginName(log) != id) continue;
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_LOG_SRVLT_IN_USE", new String[0]), null, resp);
                return;
            }
            this.logSubsystem.getLogPlugins().remove(id);
            LoggingConfig destStore = this.mConfig.getLoggingConfig();
            LoggerPluginsConfig instancesConfig = destStore.getLoggerPluginsConfig();
            instancesConfig.removeSubStore(id);
            try {
                this.mConfig.commit(true);
            }
            catch (EBaseException e2) {
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_COMMIT_FAILED", new String[0]), null, resp);
                return;
            }
            if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Success", this.auditParams(req)));
            }
            this.sendResponse(SUCCESS, null, params, resp);
            return;
        }
        catch (IOException eAudit2) {
            auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
            throw eAudit2;
        }
    }

    private synchronized void modLogInst(HttpServletRequest req, HttpServletResponse resp, String scope) throws ServletException, IOException, EBaseException {
        String origExpirationTime;
        String origLogPath;
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        String logType = null;
        String newLogPath = origLogPath = req.getParameter("fileName");
        String newExpirationTime = origExpirationTime = req.getParameter("expirationTime");
        try {
            String id;
            logType = id = req.getParameter("RS_ID");
            if (logType == null) {
                logType = SIGNED_AUDIT_LOG_TYPE;
            }
            if (origLogPath != null) {
                origLogPath = origLogPath.trim();
                newLogPath = newLogPath.trim();
            } else {
                origLogPath = "";
                newLogPath = "";
            }
            if (origExpirationTime != null) {
                origExpirationTime = origExpirationTime.trim();
                newExpirationTime = newExpirationTime.trim();
            } else {
                origExpirationTime = "";
                newExpirationTime = "";
            }
            if (id == null) {
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
                return;
            }
            if (!this.logSubsystem.getLogInsts().containsKey(id)) {
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_LOG_SRVLT_ILL_INST_ID", new String[0]), null, resp);
                return;
            }
            String implname = req.getParameter("implName");
            if (implname == null) {
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_LOG_SRVLT_ADD_MISSING_PARAMS", new String[0]), null, resp);
                return;
            }
            LogPlugin plugin = this.logSubsystem.getLogPlugins().get(implname);
            if (plugin == null) {
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, new ELogPluginNotFound(CMS.getUserMessage(this.getLocale(req), "CMS_LOG_PLUGIN_NOT_FOUND", implname)).toString(), null, resp);
                return;
            }
            LogEventListener oldinst = this.logSubsystem.getLogInstance(id);
            Vector<String> oldConfigParms = oldinst.getInstanceParams();
            NameValuePairs saveParams = new NameValuePairs();
            saveParams.put((Object)"pluginName", (Object)implname);
            if (oldConfigParms != null) {
                for (int i = 0; i < oldConfigParms.size(); ++i) {
                    String kv = oldConfigParms.elementAt(i);
                    int index = kv.indexOf(61);
                    saveParams.put((Object)kv.substring(0, index), (Object)kv.substring(index + 1));
                }
            }
            LoggingConfig destStore = this.mConfig.getLoggingConfig();
            LoggersConfig instancesConfig = destStore.getLoggersConfig();
            Vector<String> configParams = this.logSubsystem.getLogInstanceParams(id);
            LoggerConfig substore = instancesConfig.createLoggerConfig(id);
            substore.put("pluginName", implname);
            substore.put("expirationTime", "0");
            newLogPath = origLogPath = substore.getString("fileName");
            if (origLogPath != null) {
                origLogPath = origLogPath.trim();
                newLogPath = newLogPath.trim();
            } else {
                origLogPath = "";
                newLogPath = "";
            }
            newExpirationTime = origExpirationTime = substore.getString("expirationTime");
            if (origExpirationTime != null) {
                origExpirationTime = origExpirationTime.trim();
                newExpirationTime = newExpirationTime.trim();
            } else {
                origExpirationTime = "";
                newExpirationTime = "";
            }
            if (configParams != null) {
                for (int i = 0; i < configParams.size(); ++i) {
                    AUTHZ_RES_NAME = "certServer.log.configuration";
                    String kv = configParams.elementAt(i);
                    int index = kv.indexOf(61);
                    String key = kv.substring(0, index);
                    String val = req.getParameter(key);
                    if (key.equals("level")) {
                        if (val.equals("Debug")) {
                            val = "0";
                        } else if (val.equals("Information")) {
                            val = "1";
                        } else if (val.equals("Warning")) {
                            val = "2";
                        } else if (val.equals("Failure")) {
                            val = "3";
                        } else if (val.equals("Misconfiguration")) {
                            val = "4";
                        } else if (val.equals("Catastrophe")) {
                            val = "5";
                        } else if (val.equals("Security")) {
                            val = "6";
                        }
                    }
                    if (key.equals("rolloverInterval")) {
                        if (val.equals("Hourly")) {
                            val = Integer.toString(3600);
                        } else if (val.equals("Daily")) {
                            val = Integer.toString(86400);
                        } else if (val.equals("Weekly")) {
                            val = Integer.toString(604800);
                        } else if (val.equals("Monthly")) {
                            val = Integer.toString(2592000);
                        } else if (val.equals("Yearly")) {
                            val = Integer.toString(31536000);
                        }
                    }
                    if (val == null) continue;
                    if (key.equals("fileName")) {
                        String origVal = substore.getString(key);
                        newLogPath = val = val.trim();
                        if (!val.equals(origVal.trim())) {
                            AUTHZ_RES_NAME = "certServer.log.configuration.fileName";
                            this.mOp = "modify";
                            this.mToken = super.authorize(req);
                            if (this.mToken == null) {
                                if (!newLogPath.equals(origLogPath)) {
                                    auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_LOG_PATH_CHANGE_4", auditSubjectID, "Failure", logType, newLogPath);
                                    auditor.log(auditMessage);
                                }
                                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                                }
                                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                                return;
                            }
                        }
                    }
                    substore.put(key, val);
                }
            }
            String className = plugin.getClassPath();
            LogEventListener newMgrInst = null;
            try {
                newMgrInst = (LogEventListener)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                newLogPath = this.auditCheckLogPath(req);
                LogAdminServlet.restore(instancesConfig, id, saveParams);
                if (!newLogPath.equals(origLogPath)) {
                    auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_LOG_PATH_CHANGE_4", auditSubjectID, "Failure", logType, newLogPath);
                    auditor.log(auditMessage);
                }
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, new ELogException(CMS.getUserMessage(this.getLocale(req), "CMS_LOG_LOAD_CLASS_FAIL", className)).toString(), null, resp);
                return;
            }
            try {
                this.mConfig.commit(true);
            }
            catch (EBaseException e) {
                newLogPath = this.auditCheckLogPath(req);
                LogAdminServlet.restore(instancesConfig, id, saveParams);
                if (!newLogPath.equals(origLogPath)) {
                    auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_LOG_PATH_CHANGE_4", auditSubjectID, "Failure", logType, newLogPath);
                    auditor.log(auditMessage);
                }
                if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                    auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
                }
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_COMMIT_FAILED", new String[0]), null, resp);
                return;
            }
            NameValuePairs params = new NameValuePairs();
            newLogPath = this.auditCheckLogPath(req);
            if (!newLogPath.equals(origLogPath)) {
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_LOG_PATH_CHANGE_4", auditSubjectID, "Success", logType, newLogPath);
                auditor.log(auditMessage);
            }
            if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Success", this.auditParams(req)));
            }
            this.sendResponse(RESTART, null, params, resp);
            return;
        }
        catch (EBaseException eAudit1) {
            newLogPath = this.auditCheckLogPath(req);
            if (!newLogPath.equals(origLogPath)) {
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_LOG_PATH_CHANGE_4", auditSubjectID, "Failure", logType, newLogPath);
                auditor.log(auditMessage);
            }
            if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
            }
            throw eAudit1;
        }
        catch (IOException eAudit2) {
            newLogPath = this.auditCheckLogPath(req);
            if (!newLogPath.equals(origLogPath)) {
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_LOG_PATH_CHANGE_4", auditSubjectID, "Failure", logType, newLogPath);
                auditor.log(auditMessage);
            }
            if (logType.equals(SIGNED_AUDIT_LOG_TYPE)) {
                auditor.log(new ConfigSignedAuditEvent(auditSubjectID, "Failure", this.auditParams(req)));
            }
            throw eAudit2;
        }
    }

    private synchronized void getConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        String implname = req.getParameter("RS_ID");
        if (implname == null) {
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
            return;
        }
        Vector<String> configParams = this.logSubsystem.getLogDefaultParams(implname);
        NameValuePairs params = new NameValuePairs();
        params.put((Object)"implName", (Object)"");
        if (configParams != null) {
            for (int i = 0; i < configParams.size(); ++i) {
                String kv = configParams.elementAt(i);
                int index = kv.indexOf(61);
                if (index == -1) {
                    params.put((Object)kv, (Object)"");
                    continue;
                }
                params.put((Object)kv.substring(0, index), (Object)kv.substring(index + 1));
            }
        }
        this.sendResponse(0, null, params, resp);
    }

    private synchronized void getInstConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        String id = req.getParameter("RS_ID");
        if (id == null) {
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
            return;
        }
        if (!this.logSubsystem.getLogInsts().containsKey(id)) {
            this.sendResponse(ERROR, new ELogNotFound(CMS.getUserMessage(this.getLocale(req), "CMS_LOG_INSTANCE_NOT_FOUND", id)).toString(), null, resp);
            return;
        }
        LogEventListener logInst = this.logSubsystem.getLogInstance(id);
        Vector<String> configParams = logInst.getInstanceParams();
        NameValuePairs params = new NameValuePairs();
        params.put((Object)"implName", (Object)this.getLogPluginName(logInst));
        if (configParams != null) {
            for (int i = 0; i < configParams.size(); ++i) {
                String kv = configParams.elementAt(i);
                int index = kv.indexOf(61);
                params.put((Object)kv.substring(0, index), (Object)kv.substring(index + 1));
            }
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private static void restore(LoggersConfig store, String id, NameValuePairs saveParams) {
        store.removeLoggerConfig(id);
        LoggerConfig rstore = store.createLoggerConfig(id);
        for (String key : saveParams.keySet()) {
            String value = (String)saveParams.get((Object)key);
            if (value == null) continue;
            rstore.put(key, value);
        }
    }

    private String auditCheckLogPath(HttpServletRequest req) {
        String logPath = req.getParameter("fileName");
        if (logPath == null) {
            logPath = "";
        }
        logPath = logPath.trim();
        return logPath;
    }

    private void getGeneralConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        String value = this.mConfig.getString("debug.level", "10");
        params.put((Object)"debug.level", (Object)value);
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void setGeneralConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        Enumeration enum1 = req.getParameterNames();
        boolean restart = false;
        while (enum1.hasMoreElements()) {
            String key = (String)enum1.nextElement();
            String value = req.getParameter(key);
            if (!key.equals("debug.level")) continue;
            try {
                Integer.parseInt(value);
                this.mConfig.putString("debug.level", value);
            }
            catch (NumberFormatException e) {
                logger.error("setGeneralConfig: Invalid value for debug.level: " + value + ": " + e.getMessage(), (Throwable)e);
                throw new EBaseException("Invalid value for debug.level");
            }
        }
        this.mConfig.commit(true);
        if (restart) {
            this.sendResponse(RESTART, null, null, resp);
        } else {
            this.sendResponse(SUCCESS, null, null, resp);
        }
    }
}

