/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.certsrv.authentication.AuthMgrPlugin;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.authentication.AuthSubsystem;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.base.ConfigStore;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.authentication.AuthManagerConfig;
import org.dogtagpki.server.authentication.AuthManagersConfig;
import org.dogtagpki.server.authentication.AuthenticationConfig;

public class RemoteAuthConfig
extends CMSServlet {
    private static final long serialVersionUID = -5803015919915253940L;
    private static final String TPL_FILE = "remoteAuthConfig.template";
    private static final String ENABLE_REMOTE_CONFIG = "enableRemoteConfiguration";
    private static final String REMOTELY_SET_INSTANCES = "remotelySetInstances";
    private static final String MEMBER_OF = "memberOf";
    private static final String UNIQUE_MEMBER = "uniqueMember";
    private String mFormPath = null;
    private AuthSubsystem mAuthSubsystem;
    private AuthenticationConfig mAuthConfig = null;
    private ConfigStore mFileConfig;
    private Vector<String> mRemotelySetInstances = new Vector();
    private boolean mEnableRemoteConfiguration = false;

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        CMSEngine engine = this.getCMSEngine();
        EngineConfig cs = engine.getConfig();
        this.mFormPath = "/" + this.mAuthority.getId() + "/remoteAuthConfig.template";
        this.mFileConfig = cs;
        this.mAuthConfig = cs.getAuthenticationConfig();
        try {
            this.mEnableRemoteConfiguration = this.mAuthConfig.getBoolean(ENABLE_REMOTE_CONFIG, false);
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        String remoteList = null;
        try {
            remoteList = this.mAuthConfig.getString(REMOTELY_SET_INSTANCES, null);
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        if (remoteList != null) {
            StringTokenizer s = new StringTokenizer(remoteList, ",");
            while (s.hasMoreTokens()) {
                String token = s.nextToken();
                if (token == null || token.trim().length() <= 0) continue;
                this.mRemotelySetInstances.add(token.trim());
            }
        }
        this.mAuthSubsystem = engine.getAuthSubsystem();
        this.mTemplates.remove(CMSRequest.SUCCESS);
    }

    @Override
    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        this.authenticate(cmsReq);
        ArgBlock header = new ArgBlock();
        ArgBlock ctx = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, ctx);
        String host = req.getParameter("host");
        String port = req.getParameter("port");
        String adminDN = req.getParameter("adminDN");
        String uid = req.getParameter("uid");
        String baseDN = req.getParameter("baseDN");
        String password = req.getParameter("password");
        String replyTo = req.getParameter("replyTo");
        if (replyTo != null && replyTo.length() > 0) {
            ctx.addStringValue("replyTo", replyTo);
        }
        if (this.mEnableRemoteConfiguration) {
            String errMsg = null;
            errMsg = adminDN != null && adminDN.length() > 0 ? this.authenticateRemoteAdmin(host, port, adminDN, password) : this.authenticateRemoteAdmin(host, port, uid, baseDN, password);
            if (errMsg == null || errMsg.length() == 0) {
                if (this.mAuthSubsystem != null && this.mAuthConfig != null) {
                    String op = req.getParameter("op");
                    if (op == null || op.length() == 0) {
                        header.addStringValue("error", "Undefined operation");
                    } else {
                        header.addStringValue("op", op);
                        if (op.equals("delete")) {
                            plugin = req.getParameter("of");
                            if (this.isPluginListed(plugin)) {
                                String instance = req.getParameter("instance");
                                if (this.isInstanceListed(instance)) {
                                    errMsg = this.deleteInstance(instance);
                                    if (errMsg != null && errMsg.length() > 0) {
                                        header.addStringValue("error", errMsg);
                                    } else {
                                        header.addStringValue("plugin", plugin);
                                        header.addStringValue("instance", instance);
                                    }
                                } else {
                                    header.addStringValue("error", "Unknown instance " + instance + ".");
                                }
                            } else {
                                header.addStringValue("error", "Unknown plugin name: " + plugin);
                            }
                        } else if (op.equals("add")) {
                            plugin = req.getParameter("of");
                            if (this.isPluginListed(plugin)) {
                                String instance = req.getParameter("instance");
                                if (instance == null || instance.length() == 0) {
                                    instance = this.makeInstanceName();
                                }
                                if (this.isInstanceListed(instance)) {
                                    header.addStringValue("error", "Instance name " + instance + " is already in use.");
                                } else {
                                    errMsg = this.addInstance(instance, plugin, host, port, baseDN, req.getParameter("dnPattern"));
                                    if (errMsg != null && errMsg.length() > 0) {
                                        header.addStringValue("error", errMsg);
                                    } else {
                                        header.addStringValue("plugin", plugin);
                                        header.addStringValue("instance", instance);
                                    }
                                }
                            } else {
                                header.addStringValue("error", "Unknown plugin name: " + plugin);
                            }
                        } else {
                            header.addStringValue("error", "Unsupported operation: " + op);
                        }
                    }
                } else {
                    header.addStringValue("error", "Invalid configuration data.");
                }
            } else {
                header.addStringValue("error", errMsg);
            }
        } else {
            header.addStringValue("error", "Remote configuration is disabled.");
        }
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage("CMSGW_ERR_GET_TEMPLATE", e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_DISPLAY_TEMPLATE_ERROR", new String[0]), e);
        }
        try {
            ServletOutputStream out = resp.getOutputStream();
            resp.setContentType("text/html");
            form.renderOutput((OutputStream)out, argSet);
            cmsReq.setStatus(CMSRequest.SUCCESS);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage("CMSGW_ERR_STREAM_TEMPLATE", e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_DISPLAY_TEMPLATE_ERROR", new String[0]), e);
        }
    }

    private String authenticateRemoteAdmin(String host, String port, String adminDN, String password) {
        if (host == null || host.length() == 0) {
            return "Missing host name.";
        }
        if (port == null || port.length() == 0 || port.trim().length() == 0) {
            return "Missing port number.";
        }
        if (adminDN == null || adminDN.length() == 0) {
            return "Missing admin DN.";
        }
        if (password == null || password.length() == 0) {
            return "Missing password.";
        }
        int p = 0;
        try {
            p = Integer.parseInt(port.trim());
        }
        catch (NumberFormatException e) {
            return "Invalid port number: " + port + " (" + e.toString() + ")";
        }
        boolean connected = false;
        LDAPConnection c = new LDAPConnection();
        try {
            block15: {
                c.connect(host, p);
                connected = true;
                try {
                    c.authenticate(adminDN, password);
                    LDAPEntry entry = c.read(adminDN);
                    LDAPAttribute attr = entry.getAttribute(MEMBER_OF);
                    if (attr != null) {
                        Enumeration eVals = attr.getStringValues();
                        while (eVals.hasMoreElements()) {
                            LDAPAttribute gAttr;
                            String nextValue = (String)eVals.nextElement();
                            if (nextValue.indexOf("Administrator") <= -1) continue;
                            LDAPEntry groupEntry = c.read(nextValue);
                            if (groupEntry != null && (gAttr = groupEntry.getAttribute(UNIQUE_MEMBER)) != null) {
                                Enumeration eValues = gAttr.getStringValues();
                                while (eValues.hasMoreElements()) {
                                    String value = (String)eValues.nextElement();
                                    if (!value.equals(entry.getDN())) continue;
                                    c.disconnect();
                                    return null;
                                }
                            }
                            break block15;
                        }
                        break block15;
                    }
                    c.disconnect();
                    return null;
                }
                catch (LDAPException e) {
                    c.disconnect();
                    return "LDAP error: " + e.toString();
                }
            }
            if (connected) {
                c.disconnect();
            }
        }
        catch (LDAPException e) {
            return "LDAP error: " + e.toString();
        }
        return "Access unauthorized";
    }

    private String authenticateRemoteAdmin(String host, String port, String uid, String baseDN, String password) {
        if (host == null || host.length() == 0) {
            return "Missing host name.";
        }
        if (port == null || port.length() == 0 || port.trim().length() == 0) {
            return "Missing port number.";
        }
        if (uid == null || uid.length() == 0) {
            return "Missing UID.";
        }
        if (uid.indexOf(42) > -1) {
            return "Invalid UID: " + uid;
        }
        if (password == null || password.length() == 0) {
            return "Missing password.";
        }
        int p = 0;
        try {
            p = Integer.parseInt(port.trim());
        }
        catch (NumberFormatException e) {
            return "Invalid port number: " + port + " (" + e.toString() + ")";
        }
        if (baseDN == null || baseDN.length() == 0) {
            return "Missing base DN.";
        }
        boolean connected = false;
        LDAPConnection c = new LDAPConnection();
        try {
            c.connect(host, p);
            connected = true;
            boolean memberOf = false;
            LDAPSearchResults results = c.search(baseDN, 2, "(uid=" + uid + ")", null, false);
            block12: while (results.hasMoreElements()) {
                LDAPEntry entry = null;
                try {
                    entry = results.next();
                    c.authenticate(entry.getDN(), password);
                    LDAPAttribute attr = entry.getAttribute(MEMBER_OF);
                    if (attr == null) continue;
                    memberOf = true;
                    Enumeration eVals = attr.getStringValues();
                    while (eVals.hasMoreElements()) {
                        LDAPAttribute gAttr;
                        String nextValue = (String)eVals.nextElement();
                        if (nextValue.indexOf("Administrator") <= -1) continue;
                        LDAPEntry groupEntry = c.read(nextValue);
                        if (groupEntry == null || (gAttr = groupEntry.getAttribute(UNIQUE_MEMBER)) == null) continue block12;
                        Enumeration eValues = gAttr.getStringValues();
                        while (eValues.hasMoreElements()) {
                            String value = (String)eValues.nextElement();
                            if (!value.equals(entry.getDN())) continue;
                            c.disconnect();
                            return null;
                        }
                        continue block12;
                    }
                }
                catch (LDAPException e) {
                    switch (e.getLDAPResultCode()) {
                        case 32: {
                            continue block12;
                        }
                        case 49: {
                            continue block12;
                        }
                        case 50: {
                            continue block12;
                        }
                        case 9: {
                            continue block12;
                        }
                    }
                }
            }
            if (connected) {
                c.disconnect();
            }
            if (!memberOf) {
                return null;
            }
        }
        catch (LDAPException e) {
            return "LDAP error: " + e.toString();
        }
        return "Access unauthorized";
    }

    private String addInstance(String instance, String plugin, String host, String port, String baseDN, String dnPattern) {
        if (host == null || host.length() == 0) {
            return "Missing host name.";
        }
        if (port == null || port.length() == 0) {
            return "Missing port number.";
        }
        AuthManagersConfig c0 = this.mAuthConfig.getAuthManagersConfig();
        AuthManagerConfig c1 = c0.createAuthManagerConfig(instance);
        c1.putString("dnpattern", dnPattern);
        c1.putString("ldapByteAttributes", "");
        c1.putString("ldapStringAttributes", "");
        c1.putString("pluginName", plugin);
        if (baseDN != null && baseDN.length() > 0) {
            c1.putString("ldap.basedn", baseDN);
        }
        c1.putString("ldap.minConns", "");
        c1.putString("ldap.maxConns", "");
        c1.putString("ldap.ldapconn.host", host);
        c1.putString("ldap.ldapconn.port", port);
        c1.putString("ldap.ldapconn.secureConn", "false");
        c1.putString("ldap.ldapconn.version", "3");
        this.mRemotelySetInstances.add(instance);
        AuthManager authMgrInst = this.mAuthSubsystem.getAuthManagerPlugin(plugin);
        if (authMgrInst != null) {
            try {
                CMSEngine engine = this.getCMSEngine();
                authMgrInst.setCMSEngine(engine);
                authMgrInst.init(this.mAuthConfig, instance, plugin, c1);
            }
            catch (EBaseException e) {
                c0.removeSubStore(instance);
                this.mRemotelySetInstances.remove(instance);
                return e.toString();
            }
            this.mAuthSubsystem.add(instance, authMgrInst);
        }
        StringBuffer list = new StringBuffer();
        for (int i = 0; i < this.mRemotelySetInstances.size(); ++i) {
            if (i > 0) {
                list.append(",");
            }
            list.append(this.mRemotelySetInstances.elementAt(i));
        }
        this.mAuthConfig.putString(REMOTELY_SET_INSTANCES, list.toString());
        try {
            this.mFileConfig.commit(false);
        }
        catch (EBaseException e) {
            c0.removeSubStore(instance);
            this.mRemotelySetInstances.remove(instance);
            return e.toString();
        }
        return null;
    }

    private String deleteInstance(String instance) {
        AuthManagersConfig c = this.mAuthConfig.getAuthManagersConfig();
        c.removeSubStore(instance);
        if (this.mRemotelySetInstances.remove(instance)) {
            StringBuffer list = new StringBuffer();
            for (int i = 0; i < this.mRemotelySetInstances.size(); ++i) {
                if (i > 0) {
                    list.append(",");
                }
                list.append(this.mRemotelySetInstances.elementAt(i));
            }
            this.mAuthConfig.putString(REMOTELY_SET_INSTANCES, list.toString());
        }
        try {
            this.mFileConfig.commit(false);
        }
        catch (EBaseException e) {
            return e.toString();
        }
        this.mAuthSubsystem.delete(instance);
        return null;
    }

    private boolean isPluginListed(String pluginName) {
        boolean isListed = false;
        if (pluginName != null && pluginName.length() > 0) {
            Enumeration<AuthMgrPlugin> e = this.mAuthSubsystem.getAuthManagerPlugins();
            while (e.hasMoreElements()) {
                AuthMgrPlugin plugin = e.nextElement();
                if (!pluginName.equals(plugin.getId())) continue;
                isListed = true;
                break;
            }
        }
        return isListed;
    }

    private boolean isInstanceListed(String instanceName) {
        boolean isListed = false;
        if (instanceName != null && instanceName.length() > 0) {
            Enumeration<AuthManager> e = this.mAuthSubsystem.getAuthManagers();
            while (e.hasMoreElements()) {
                AuthManager authManager = e.nextElement();
                if (!instanceName.equals(authManager.getName())) continue;
                isListed = true;
                break;
            }
        }
        return isListed;
    }

    private String makeInstanceName() {
        Calendar now = Calendar.getInstance();
        int y = now.get(1);
        String name = "R" + y;
        if (now.get(2) < 10) {
            name = name + "0";
        }
        name = name + now.get(2);
        if (now.get(5) < 10) {
            name = name + "0";
        }
        name = name + now.get(5);
        if (now.get(11) < 10) {
            name = name + "0";
        }
        name = name + now.get(11);
        if (now.get(12) < 10) {
            name = name + "0";
        }
        name = name + now.get(12);
        if (now.get(13) < 10) {
            name = name + "0";
        }
        name = name + now.get(13);
        return name;
    }
}

