/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.request;

import com.netscape.certsrv.request.RequestListener;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestNotifier;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunListeners
implements Runnable {
    public static Logger logger = LoggerFactory.getLogger(RunListeners.class);
    Request mRequest = null;
    Enumeration<RequestListener> mListeners = null;
    RequestNotifier mRequestNotifier;

    public RunListeners(Request r, Enumeration<RequestListener> listeners) {
        this.mRequest = r;
        this.mListeners = listeners;
    }

    public RunListeners(RequestNotifier requestNotifier) {
        this.mRequestNotifier = requestNotifier;
        this.mListeners = this.mRequestNotifier.getListeners();
    }

    @Override
    public void run() {
        logger.info("RunListeners: Running listeners:");
        logger.info("RunListeners: - queue: " + (this.mRequestNotifier != null ? Integer.valueOf(this.mRequestNotifier.getNumberOfRequests()) : null));
        logger.info("RunListeners: - request: " + (this.mRequest != null ? this.mRequest.getRequestId().toHexString() : null));
        do {
            if (this.mRequestNotifier != null) {
                this.mRequest = this.mRequestNotifier.getRequest();
            }
            if (this.mListeners != null && this.mRequest != null) {
                logger.info("RunListeners: Processing request " + this.mRequest.getRequestId().toHexString());
                while (this.mListeners.hasMoreElements()) {
                    RequestListener l = this.mListeners.nextElement();
                    logger.info("RunListeners: Processing request " + this.mRequest.getRequestId().toHexString() + " with " + l.getClass().getSimpleName());
                    l.accept(this.mRequest);
                }
                if (this.mRequestNotifier != null) {
                    logger.info("RunListeners: Updating publishing status for request " + this.mRequest.getRequestId().toHexString());
                    this.mRequestNotifier.updatePublishingStatus(this.mRequest.getRequestId().toString());
                }
            }
            logger.info("RunListeners: Running listeners:");
            logger.info("RunListeners: - queue: " + (this.mRequestNotifier != null ? Integer.valueOf(this.mRequestNotifier.getNumberOfRequests()) : null));
            logger.info("RunListeners: - request: " + (this.mRequest != null ? this.mRequest.getRequestId().toHexString() : null));
            if (this.mRequestNotifier == null) continue;
            this.mListeners = this.mRequestNotifier.getListeners();
        } while (this.mRequestNotifier != null && this.mRequestNotifier.getNumberOfRequests() > 0);
        if (this.mRequestNotifier != null) {
            this.mRequestNotifier.removeNotifierThread(Thread.currentThread());
        }
    }
}

