/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmsutil.http;

import com.netscape.cmsutil.http.HttpEofException;
import com.netscape.cmsutil.http.HttpProtocolException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class HttpMessage {
    protected String mLine = null;
    protected Hashtable<String, String> mHeaders = new Hashtable();
    protected String mContent = null;

    public void setHeader(String name, String value) {
        if (this.mHeaders == null) {
            this.mHeaders = new Hashtable();
        }
        this.mHeaders.put(name.toLowerCase(), value);
    }

    public String getHeader(String name) {
        return this.mHeaders.get(name.toLowerCase());
    }

    public void writeHeaders(OutputStreamWriter writer) throws IOException {
        if (this.mHeaders != null) {
            Enumeration<String> keys = this.mHeaders.keys();
            while (keys.hasMoreElements()) {
                String header = keys.nextElement();
                String value = this.mHeaders.get(header);
                writer.write(header + ":" + value + "\r\n");
            }
        }
        writer.write("\r\n");
    }

    public void readHeaders(BufferedReader reader) throws IOException {
        String line;
        this.mHeaders = new Hashtable();
        while ((line = reader.readLine()) != null && !line.equals("")) {
            int colon = line.indexOf(58);
            if (colon == -1) {
                this.mHeaders = null;
                throw new HttpProtocolException("Bad Http header format");
            }
            String key = line.substring(0, colon);
            String value = line.substring(colon + 1);
            this.mHeaders.put(key.toLowerCase(), value.trim());
        }
    }

    public void write(OutputStreamWriter writer) throws IOException {
        writer.write(this.mLine + "\r\n");
        this.writeHeaders(writer);
        writer.flush();
        if (this.mContent != null) {
            writer.write(this.mContent);
        }
        writer.flush();
    }

    public void parse(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line == null) {
            throw new HttpEofException("End of stream reached");
        }
        if (line.equals("")) {
            throw new HttpProtocolException("Bad Http req/resp line " + line);
        }
        this.mLine = line;
        this.readHeaders(reader);
        String lenstr = this.mHeaders.get("content-length");
        if (lenstr != null) {
            int done;
            int len = Integer.parseInt(lenstr);
            char[] cbuf = new char[len];
            for (int total = done = reader.read(cbuf, 0, cbuf.length); done >= 0 && total < len; total += done) {
                done = reader.read(cbuf, total, len - total);
            }
            this.mContent = new String(cbuf);
        } else {
            int charsRead;
            char[] cbuf = new char[8192];
            StringWriter sw = new StringWriter();
            while ((charsRead = reader.read(cbuf)) != -1) {
                sw.write(cbuf, 0, charsRead);
            }
            if (sw.getBuffer().length() > 0) {
                this.mContent = sw.toString();
            }
        }
    }

    public void reset() {
        this.mLine = null;
        this.mHeaders = null;
        this.mContent = null;
    }

    public void setContent(String content) {
        this.mContent = content;
    }

    public String getContent() {
        return this.mContent;
    }
}

