/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.tps.main;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import org.dogtagpki.tps.main.Util;

public class TPSBuffer {
    private byte[] buf;

    public TPSBuffer() {
        this.buf = new byte[0];
    }

    public TPSBuffer(String str) {
        this.buf = str != null ? Util.str2ByteArray(str) : new byte[0];
    }

    public TPSBuffer(int len, byte b) {
        this.buf = new byte[len];
        Arrays.fill(this.buf, b);
    }

    public TPSBuffer(byte b) {
        this.buf = new byte[1];
        this.buf[0] = b;
    }

    public TPSBuffer(int len) {
        this.buf = new byte[len];
        Arrays.fill(this.buf, (byte)0);
        len = 0;
    }

    public TPSBuffer(byte[] inBuf) {
        if (inBuf == null) {
            this.buf = new byte[0];
        }
        this.buf = new byte[inBuf.length];
        System.arraycopy(inBuf, 0, this.buf, 0, inBuf.length);
    }

    public TPSBuffer(TPSBuffer cpy) {
        if (cpy == null) {
            this.buf = new byte[0];
            return;
        }
        byte[] srcBytes = cpy.toBytesArray();
        int srcLen = srcBytes.length;
        this.buf = new byte[srcLen];
        System.arraycopy(srcBytes, 0, this.buf, 0, srcLen);
    }

    public byte at(int i) {
        if (i < 0 || i >= this.size()) {
            return 0;
        }
        return this.buf[i];
    }

    public void setAt(int i, byte value) {
        if (i < 0 || i >= this.size()) {
            return;
        }
        this.buf[i] = value;
    }

    public boolean equals(TPSBuffer cmp) {
        byte[] cmpBytes = cmp.toBytesArray();
        if (cmpBytes == null) {
            return false;
        }
        return Arrays.equals(this.buf, cmpBytes);
    }

    public void prepend(TPSBuffer prepend) {
        if (prepend == null) {
            return;
        }
        byte[] preBytes = prepend.toBytesArray();
        this.prependBytes(preBytes);
    }

    public void add(TPSBuffer addend) {
        if (addend == null) {
            return;
        }
        byte[] addBytes = addend.toBytesArray();
        this.addBytes(addBytes);
    }

    public void set(TPSBuffer newContents) {
        if (newContents == null) {
            return;
        }
        this.buf = newContents.toBytesArray();
    }

    public void set(byte[] newContents) {
        if (newContents == null) {
            return;
        }
        this.buf = newContents;
    }

    public void add(byte b) {
        byte[] addBytes = new byte[]{b};
        this.addBytes(addBytes);
    }

    public void prependBytes(byte[] preBytes) {
        if (preBytes == null) {
            return;
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        bytes.write(preBytes, 0, preBytes.length);
        bytes.write(this.buf, 0, this.buf.length);
        this.buf = bytes.toByteArray();
    }

    public void addBytes(byte[] addBytes) {
        if (addBytes == null) {
            return;
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        bytes.write(this.buf, 0, this.buf.length);
        bytes.write(addBytes, 0, addBytes.length);
        this.buf = bytes.toByteArray();
    }

    public byte[] toBytesArray() {
        return this.buf;
    }

    public int size() {
        return this.buf.length;
    }

    public void zeroize() {
        Arrays.fill(this.buf, (byte)0);
    }

    public void resize(int newLen) {
        byte[] tmp = new byte[this.buf.length];
        System.arraycopy(this.buf, 0, tmp, 0, this.buf.length);
        this.buf = new byte[newLen];
        System.arraycopy(tmp, 0, this.buf, 0, tmp.length);
    }

    public TPSBuffer substr(int start, int theLen) {
        if (start < 0 || theLen <= 0 || start + theLen > this.buf.length) {
            return null;
        }
        byte[] tmp = new byte[theLen];
        System.arraycopy(this.buf, start, tmp, 0, theLen);
        TPSBuffer ret = new TPSBuffer(tmp);
        return ret;
    }

    public TPSBuffer substr(int start) {
        return this.substr(start, this.buf.length - 2);
    }

    public void dump() {
        String newLine = System.getProperty("line.separator");
        System.out.println(newLine + "Buffer Contents: " + newLine);
        for (int i = 0; i < this.buf.length; ++i) {
            int val = this.buf[i] & 0xFF;
            System.out.print(Util.intToHex(val) + " ");
            if (i % 8 != 7) continue;
            System.out.print(newLine);
        }
        System.out.print(newLine);
    }

    public String toHexString() {
        String HEX_DIGITS = "0123456789ABCDEF";
        StringBuffer result = new StringBuffer(this.buf.length * 2);
        for (int i = 0; i < this.buf.length; ++i) {
            char c = (char)this.buf[i];
            result.append("0123456789ABCDEF".charAt((c & 0xF0) >> 4));
            result.append("0123456789ABCDEF".charAt(c & 0xF));
            result.append("%");
        }
        return result.toString();
    }

    public String toHexStringPlain() {
        String HEX_DIGITS = "0123456789ABCDEF";
        StringBuffer result = new StringBuffer(this.buf.length * 2);
        for (int i = 0; i < this.buf.length; ++i) {
            char c = (char)this.buf[i];
            result.append("0123456789ABCDEF".charAt((c & 0xF0) >> 4));
            result.append("0123456789ABCDEF".charAt(c & 0xF));
        }
        return result.toString();
    }

    public int getIntFrom1Byte(int offset) {
        if (offset < 0 || offset >= this.size()) {
            return 0;
        }
        int result = this.at(offset) & 0xFF;
        return result;
    }

    public int getIntFrom2Bytes(int offset) {
        if (offset < 0 || offset >= this.size() - 1) {
            return 0;
        }
        int i1 = (this.at(offset) & 0xFF) << 8;
        int i2 = this.at(offset + 1) & 0xFF;
        return i1 + i2;
    }

    public void addLong4Bytes(long value) {
        this.add((byte)(value >> 24 & 0xFFL));
        this.add((byte)(value >> 16 & 0xFFL));
        this.add((byte)(value >> 8 & 0xFFL));
        this.add((byte)(value & 0xFFL));
    }

    public void addInt2Bytes(int value) {
        this.add((byte)(value >> 8 & 0xFF));
        this.add((byte)(value & 0xFF));
    }

    public long getLongFrom4Bytes(int offset) {
        if (offset < 0 || offset >= this.size() - 3) {
            return 0L;
        }
        long l1 = (long)(this.at(offset + 0) & 0xFF) << 24;
        long l2 = (long)(this.at(offset + 1) & 0xFF) << 16;
        long l3 = (long)(this.at(offset + 2) & 0xFF) << 8;
        long l4 = this.at(offset + 3) & 0xFF;
        return l1 + l2 + l3 + l4;
    }

    public void reset() {
        this.buf = new byte[0];
    }

    public static void main(String[] args) {
        byte[] first = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74};
        byte[] second = new byte[]{81, 82, 83, 84, 85, 86, 87, 88, 89, 90};
        byte[] third = new byte[]{97, 98, 99, 100, 101, 102, 103, 104, 105, 106};
        TPSBuffer b1 = new TPSBuffer(first);
        TPSBuffer b2 = new TPSBuffer(second);
        System.out.println("Buffer b1");
        b1.dump();
        System.out.println("Buffer b2");
        b2.dump();
        b1.addBytes(second);
        System.out.println("Buffer b1 + byte array: ");
        b1.dump();
        b1.add(b2);
        System.out.println("Buffer b1 with b2 added to it: ");
        b1.dump();
        TPSBuffer b3 = new TPSBuffer(third);
        System.out.println("Buffer b3: ");
        b3.dump();
        TPSBuffer b4 = b3.substr(1, 4);
        System.out.println("Substr of Buffer b3 from 1 length 4: ");
        b4.dump();
        TPSBuffer b5 = new TPSBuffer(b4);
        System.out.println("Buffer b5 instantiated from Buffer b4");
        b5.dump();
        TPSBuffer b6 = new TPSBuffer("A0000000030000");
        b6.dump();
        TPSBuffer empty = new TPSBuffer();
        int emptySize = empty.size();
        System.out.println("empty buffer size: " + emptySize);
    }
}

