/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools;

import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.spec.MGF1ParameterSpec;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.InvalidKeyFormatException;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.KeyWrapper;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenCertificate;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.provider.RSAPublicKey;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.pkcs11.PK11PubKey;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.PasswordCallback;

public class KRATool {
    private static final boolean FAILURE = false;
    private static final boolean SUCCESS = true;
    private static final String COLON = ":";
    private static final String COMMA = ",";
    private static final String DOT = ".";
    private static final String EQUAL_SIGN = "=";
    private static final String LEFT_BRACE = "[";
    private static final String NEWLINE = "\n";
    private static final String PLUS = "+";
    private static final String RIGHT_BRACE = "]";
    private static final String SPACE = " ";
    private static final String TIC = "'";
    private static final String DATE_OF_MODIFY_PATTERN = "yyyyMMddHHmmss'Z'";
    private static final String LOGGING_DATE_PATTERN = "dd/MMM/yyyy:HH:mm:ss z";
    private static final int ID_OFFSET_NAME_VALUE_PAIRS = 1;
    private static final int PWDFILE_NAME_VALUE_PAIRS = 1;
    private static final int NAMING_CONTEXT_NAME_VALUE_PAIRS = 2;
    private static final int MANDATORY_NAME_VALUE_PAIRS = 4;
    private static final int REWRAP_NAME_VALUE_PAIRS = 4;
    private static final int ID_OFFSET_ARGS = 10;
    private static final int REWRAP_ARGS = 16;
    private static final int REWRAP_AND_ID_OFFSET_ARGS = 18;
    private static final String KRA_TOOL = "KRATool";
    private static final String KRATOOL_CFG_FILE = "-kratool_config_file";
    private static final String KRATOOL_CFG_DESCRIPTION = " <complete path to the kratool config file\n          ending with the kratool config file name>";
    private static final String KRATOOL_CFG_FILE_EXAMPLE = "-kratool_config_file /usr/share/pki/tools/KRATool.cfg";
    private static final String SOURCE_LDIF_FILE = "-source_ldif_file";
    private static final String SOURCE_LDIF_DESCRIPTION = " <complete path to the source LDIF input file\n          ending with the source LDIF file name>";
    private static final String SOURCE_LDIF_FILE_EXAMPLE = "-source_ldif_file /export/pki/source.ldif";
    private static final String TARGET_LDIF_FILE = "-target_ldif_file";
    private static final String TARGET_LDIF_DESCRIPTION = " <complete path to the target LDIF output file\n          ending with the target LDIF file name>";
    private static final String TARGET_LDIF_FILE_EXAMPLE = "-target_ldif_file /export/pki/target.ldif";
    private static final String LOG_FILE = "-log_file";
    private static final String LOG_DESCRIPTION = " <complete path to the log file\n          ending with the log file name>";
    private static final String LOG_FILE_EXAMPLE = "-log_file /export/pki/KRATool.log";
    private static final String SOURCE_NSS_DB_PATH = "-source_pki_security_database_path";
    private static final String SOURCE_NSS_DB_DESCRIPTION = "  <complete path to the source security databases\n           used by data in the source LDIF file>";
    private static final String SOURCE_NSS_DB_PATH_EXAMPLE = "-source_pki_security_database_path /export/pki";
    private static final String SOURCE_STORAGE_TOKEN_NAME = "-source_storage_token_name";
    private static final String SOURCE_STORAGE_TOKEN_DESCRIPTION = "  <name of the token containing the source storage token>";
    private static final String SOURCE_STORAGE_TOKEN_NAME_EXAMPLE = "-source_storage_token_name 'Internal Key Storage Token'";
    private static final String SOURCE_STORAGE_CERT_NICKNAME = "-source_storage_certificate_nickname";
    private static final String SOURCE_STORAGE_CERT_NICKNAME_DESCRIPTION = "  <nickname of the source storage certificate>";
    private static final String SOURCE_STORAGE_CERT_NICKNAME_EXAMPLE = "-source_storage_certificate_nickname 'storageCert cert-pki-kra'";
    private static final String TARGET_STORAGE_CERTIFICATE_FILE = "-target_storage_certificate_file";
    private static final String TARGET_STORAGE_CERTIFICATE_DESCRIPTION = "  <complete path to the target storage certificate file\n           ending with the target storage certificate file name;\n           the target storage certificate is stored in\n           an ASCII format between a header and footer>";
    private static final String TARGET_STORAGE_CERTIFICATE_FILE_EXAMPLE = "-target_storage_certificate_file /export/pki/target_storage.cert";
    private static final String SOURCE_NSS_DB_PWDFILE = "-source_pki_security_database_pwdfile";
    private static final String SOURCE_NSS_DB_PWDFILE_DESCRIPTION = "  <complete path to the password file which ONLY contains the\n           password used to access the source security databases>";
    private static final String SOURCE_NSS_DB_PWDFILE_EXAMPLE = "-source_pki_security_database_pwdfile /export/pki/pwdfile";
    private static final String APPEND_ID_OFFSET = "-append_id_offset";
    private static final String APPEND_ID_OFFSET_DESCRIPTION = "  <ID offset that is appended to each record's source ID>";
    private static final String APPEND_ID_OFFSET_EXAMPLE = "-append_id_offset 100000000000";
    private static final String REMOVE_ID_OFFSET = "-remove_id_offset";
    private static final String REMOVE_ID_OFFSET_DESCRIPTION = "  <ID offset that is removed from each record's source ID>";
    private static final String REMOVE_ID_OFFSET_EXAMPLE = "-remove_id_offset 100000000000";
    private static final String USE_OAEP_RSA_KEY_WRAP = "-use_rsa_oaep_keywrap";
    private static final String SOURCE_KRA_NAMING_CONTEXT = "-source_kra_naming_context";
    private static final String SOURCE_KRA_NAMING_CONTEXT_DESCRIPTION = "  <source KRA naming context>";
    private static final String SOURCE_KRA_NAMING_CONTEXT_EXAMPLE = "-source_kra_naming_context 'alpha.example.com-pki-kra'";
    private static final String TARGET_KRA_NAMING_CONTEXT = "-target_kra_naming_context";
    private static final String TARGET_KRA_NAMING_CONTEXT_DESCRIPTION = "  <target KRA naming context>";
    private static final String TARGET_KRA_NAMING_CONTEXT_EXAMPLE = "-target_kra_naming_context 'omega.example.com-pki-kra'";
    private static final String PROCESS_REQUESTS_AND_KEY_RECORDS_ONLY = "-process_requests_and_key_records_only";
    private static final String KEY_UNWRAP_ALGORITHM = "-unwrap_algorithm";
    private static final String KEY_UNWRAP_ALGORITHM_DESCRIPTION = "  <key unwrap algorithm> (default: DES3)";
    private static final String KRATOOL_CFG_PREFIX = "kratool.ldif";
    private static final String KRATOOL_CFG_ENROLLMENT = "caEnrollmentRequest";
    private static final String KRATOOL_CFG_CA_KEY_RECORD = "caKeyRecord";
    private static final String KRATOOL_CFG_RECOVERY = "recoveryRequest";
    private static final String KRATOOL_CFG_TPS_KEY_RECORD = "tpsKeyRecord";
    private static final String KRATOOL_CFG_KEYGEN = "tpsNetkeyKeygenRequest";
    private static final String KRATOOL_CFG_KEYRECOVERY = "tpsNetkeyKeyRecoveryRequest";
    private static final String KRATOOL_CFG_ENROLLMENT_CN = "kratool.ldif.caEnrollmentRequest.cn";
    private static final String KRATOOL_CFG_ENROLLMENT_DATE_OF_MODIFY = "kratool.ldif.caEnrollmentRequest.dateOfModify";
    private static final String KRATOOL_CFG_ENROLLMENT_DN = "kratool.ldif.caEnrollmentRequest.dn";
    private static final String KRATOOL_CFG_ENROLLMENT_EXTDATA_KEY_RECORD = "kratool.ldif.caEnrollmentRequest.extdata.keyRecord";
    private static final String KRATOOL_CFG_ENROLLMENT_EXTDATA_REQUEST_NOTES = "kratool.ldif.caEnrollmentRequest.extdata.requestNotes";
    private static final String KRATOOL_CFG_ENROLLMENT_REQUEST_ID = "kratool.ldif.caEnrollmentRequest.requestId";
    private static final String KRATOOL_CFG_CA_KEY_RECORD_CN = "kratool.ldif.caKeyRecord.cn";
    private static final String KRATOOL_CFG_CA_KEY_RECORD_DATE_OF_MODIFY = "kratool.ldif.caKeyRecord.dateOfModify";
    private static final String KRATOOL_CFG_CA_KEY_RECORD_DN = "kratool.ldif.caEnrollmentRequest.dn";
    private static final String KRATOOL_CFG_CA_KEY_RECORD_PRIVATE_KEY_DATA = "kratool.ldif.caKeyRecord.privateKeyData";
    private static final String KRATOOL_CFG_CA_KEY_RECORD_SERIAL_NO = "kratool.ldif.caKeyRecord.serialno";
    private static final String KRATOOL_CFG_RECOVERY_CN = "kratool.ldif.recoveryRequest.cn";
    private static final String KRATOOL_CFG_RECOVERY_DATE_OF_MODIFY = "kratool.ldif.recoveryRequest.dateOfModify";
    private static final String KRATOOL_CFG_RECOVERY_DN = "kratool.ldif.recoveryRequest.dn";
    private static final String KRATOOL_CFG_RECOVERY_EXTDATA_REQUEST_ID = "kratool.ldif.recoveryRequest.extdata.requestId";
    private static final String KRATOOL_CFG_RECOVERY_EXTDATA_REQUEST_NOTES = "kratool.ldif.recoveryRequest.extdata.requestNotes";
    private static final String KRATOOL_CFG_RECOVERY_EXTDATA_SERIAL_NUMBER = "kratool.ldif.recoveryRequest.extdata.serialnumber";
    private static final String KRATOOL_CFG_RECOVERY_REQUEST_ID = "kratool.ldif.recoveryRequest.requestId";
    private static final String KRATOOL_CFG_TPS_KEY_RECORD_CN = "kratool.ldif.tpsKeyRecord.cn";
    private static final String KRATOOL_CFG_TPS_KEY_RECORD_DATE_OF_MODIFY = "kratool.ldif.tpsKeyRecord.dateOfModify";
    private static final String KRATOOL_CFG_TPS_KEY_RECORD_DN = "kratool.ldif.tpsKeyRecord.dn";
    private static final String KRATOOL_CFG_TPS_KEY_RECORD_PRIVATE_KEY_DATA = "kratool.ldif.tpsKeyRecord.privateKeyData";
    private static final String KRATOOL_CFG_TPS_KEY_RECORD_SERIAL_NO = "kratool.ldif.tpsKeyRecord.serialno";
    private static final String KRATOOL_CFG_KEYGEN_CN = "kratool.ldif.tpsNetkeyKeygenRequest.cn";
    private static final String KRATOOL_CFG_KEYGEN_DATE_OF_MODIFY = "kratool.ldif.tpsNetkeyKeygenRequest.dateOfModify";
    private static final String KRATOOL_CFG_KEYGEN_DN = "kratool.ldif.tpsNetkeyKeygenRequest.dn";
    private static final String KRATOOL_CFG_KEYGEN_EXTDATA_KEY_RECORD = "kratool.ldif.tpsNetkeyKeygenRequest.extdata.keyRecord";
    private static final String KRATOOL_CFG_KEYGEN_EXTDATA_REQUEST_ID = "kratool.ldif.tpsNetkeyKeygenRequest.extdata.requestId";
    private static final String KRATOOL_CFG_KEYGEN_EXTDATA_REQUEST_NOTES = "kratool.ldif.tpsNetkeyKeygenRequest.extdata.requestNotes";
    private static final String KRATOOL_CFG_KEYGEN_REQUEST_ID = "kratool.ldif.tpsNetkeyKeygenRequest.requestId";
    private static final String KRATOOL_CFG_KEYRECOVERY_REQUEST_ID = "kratool.ldif.tpsNetkeyKeyRecoveryRequest.requestId";
    private static final String KRATOOL_CFG_KEYRECOVERY_DN = "kratool.ldif.tpsNetkeyKeyRecoveryRequest.dn";
    private static final String KRATOOL_CFG_KEYRECOVERY_DATE_OF_MODIFY = "kratool.ldif.tpsNetkeyKeyRecoveryRequest.dateOfModify";
    private static final String KRATOOL_CFG_KEYRECOVERY_EXTDATA_REQUEST_ID = "kratool.ldif.tpsNetkeyKeyRecoveryRequest.extdata.requestId";
    private static final String KRATOOL_CFG_KEYRECOVERY_CN = "kratool.ldif.tpsNetkeyKeyRecoveryRequest.cn";
    private static final String KRATOOL_CFG_KEYRECOVERY_EXTDATA_REQUEST_NOTES = "kratool.ldif.tpsNetkeyKeyRecoveryRequest.extdata.requestNotes";
    private static final String HEADER = "-----BEGIN";
    private static final String TRAILER = "-----END";
    private static final String KRA_LDIF_ARCHIVED_BY = "archivedBy:";
    private static final String KRA_LDIF_CN = "cn:";
    private static final String KRA_LDIF_DATE_OF_MODIFY = "dateOfModify:";
    private static final String KRA_LDIF_DN = "dn:";
    private static final String KRA_LDIF_DN_EMBEDDED_CN_DATA = "dn: cn";
    private static final String KRA_LDIF_EXTDATA_AUTH_TOKEN_USER = "extdata-auth--005ftoken;user:";
    private static final String KRA_LDIF_EXTDATA_AUTH_TOKEN_USER_DN = "extdata-auth--005ftoken;userdn:";
    private static final String KRA_LDIF_EXTDATA_KEY_RECORD = "extdata-keyrecord:";
    private static final String KRA_LDIF_EXTDATA_REQUEST_ID = "extdata-requestid:";
    private static final String KRA_LDIF_EXTDATA_REQUEST_NOTES = "extdata-requestnotes:";
    private static final String KRA_LDIF_EXTDATA_REQUEST_TYPE = "extdata-requesttype:";
    private static final String KRA_LDIF_EXTDATA_SERIAL_NUMBER = "extdata-serialnumber:";
    private static final String KRA_LDIF_PRIVATE_KEY_DATA = "privateKeyData::";
    private static final String KRA_LDIF_REQUEST_ID = "requestId:";
    private static final String KRA_LDIF_REQUEST_TYPE = "requestType:";
    private static final String KRA_LDIF_SERIAL_NO = "serialno:";
    private static final int INITIAL_LDIF_RECORD_CAPACITY = 0;
    private static final int EXTDATA_REQUEST_NOTES_FIRST_LINE_DATA_LENGTH = 56;
    private static final int PRIVATE_KEY_DATA_FIRST_LINE_DATA_LENGTH = 60;
    private static final String KRA_LDIF_RECORD = "Generic";
    private static final String KRA_LDIF_CA_KEY_RECORD = "CA";
    private static final String KRA_LDIF_ENROLLMENT = "enrollment";
    private static final String KRA_LDIF_KEYGEN = "netkeyKeygen";
    private static final String KRA_LDIF_RECOVERY = "recovery";
    private static final String KRA_LDIF_TPS_KEY_RECORD = "TPS";
    private static final String KRA_LDIF_KEYRECOVERY = "netkeyKeyRecovery";
    private static final String KRA_LDIF_REWRAP_MESSAGE = "REWRAPPED the 'existing symmetric session key' with the '";
    private static final String KRA_LDIF_RSA_MESSAGE = "-bit RSA public key' obtained from the target storage certificate";
    private static final String KRA_LDIF_USED_PWDFILE_MESSAGE = "USED source PKI security database password file";
    private static final String KRA_LDIF_APPENDED_ID_OFFSET_MESSAGE = "APPENDED ID offset";
    private static final String KRA_LDIF_REMOVED_ID_OFFSET_MESSAGE = "REMOVED ID offset";
    private static final String KRA_LDIF_SOURCE_NAME_CONTEXT_MESSAGE = "RENAMED source KRA naming context '";
    private static final String KRA_LDIF_TARGET_NAME_CONTEXT_MESSAGE = "' to target KRA naming context '";
    private static final String KRA_LDIF_PROCESS_REQUESTS_AND_KEY_RECORDS_ONLY_MESSAGE = "PROCESSED requests and key records ONLY!";
    private static String mDateOfModify = null;
    private static boolean mRewrapFlag = false;
    private static boolean mPwdfileFlag = false;
    private static boolean mAppendIdOffsetFlag = false;
    private static boolean mRemoveIdOffsetFlag = false;
    private static boolean mKraNamingContextsFlag = false;
    private static boolean mProcessRequestsAndKeyRecordsOnlyFlag = false;
    private static boolean mUseOAEPKeyWrapAlg = false;
    private static int mMandatoryNameValuePairs = 0;
    private static int mRewrapNameValuePairs = 0;
    private static int mPKISecurityDatabasePwdfileNameValuePairs = 0;
    private static int mAppendIdOffsetNameValuePairs = 0;
    private static int mRemoveIdOffsetNameValuePairs = 0;
    private static int mKraNamingContextNameValuePairs = 0;
    private static String mKratoolCfgFilename = null;
    private static String mSourceLdifFilename = null;
    private static String mTargetLdifFilename = null;
    private static String mLogFilename = null;
    private static String mSourcePKISecurityDatabasePath = null;
    private static String mSourceStorageTokenName = null;
    private static String mSourceStorageCertNickname = null;
    private static String mTargetStorageCertificateFilename = null;
    private static String mSourcePKISecurityDatabasePwdfile = null;
    private static BigInteger mAppendIdOffset = null;
    private static BigInteger mRemoveIdOffset = null;
    private static String mSourceKraNamingContext = null;
    private static String mTargetKraNamingContext = null;
    private static Hashtable<String, Boolean> kratoolCfg = null;
    private static Vector<String> record = null;
    private static Iterator<String> ldif_record = null;
    private static boolean mDebug = false;
    private static PrintWriter logger = null;
    private static String current_date_and_time = null;
    private static CryptoToken mSourceToken = null;
    private static X509Certificate mUnwrapCert = null;
    private static PrivateKey mUnwrapPrivateKey = null;
    private static PublicKey mWrapPublicKey = null;
    private static int mPublicKeySize = 0;
    private static SymmetricKey.Type keyUnwrapAlgorithm = SymmetricKey.DES3;
    private static String mSourcePKISecurityDatabasePwdfileMessage = null;
    private static String mKraNamingContextMessage = null;
    private static String mProcessRequestsAndKeyRecordsOnlyMessage = null;

    private static String now(String pattern) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(cal.getTime());
    }

    private static void printUsage() {
        System.out.println("Usage:  KRATool\n        -kratool_config_file\n         <complete path to the kratool config file\n          ending with the kratool config file name>\n        -source_ldif_file\n         <complete path to the source LDIF input file\n          ending with the source LDIF file name>\n        -target_ldif_file\n         <complete path to the target LDIF output file\n          ending with the target LDIF file name>\n        -log_file\n         <complete path to the log file\n          ending with the log file name>\n        [-source_pki_security_database_path\n          <complete path to the source security databases\n           used by data in the source LDIF file>]\n        [-source_storage_token_name\n          <name of the token containing the source storage token>]\n        [-source_storage_certificate_nickname\n          <nickname of the source storage certificate>]\n        [-target_storage_certificate_file\n          <complete path to the target storage certificate file\n           ending with the target storage certificate file name;\n           the target storage certificate is stored in\n           an ASCII format between a header and footer>]\n        [-source_pki_security_database_pwdfile\n          <complete path to the password file which ONLY contains the\n           password used to access the source security databases>]\n        [-append_id_offset\n          <ID offset that is appended to each record's source ID>]\n        [-remove_id_offset\n          <ID offset that is removed from each record's source ID>]\n        [-source_kra_naming_context\n          <source KRA naming context>]\n        [-target_kra_naming_context\n          <target KRA naming context>]\n        [-unwrap_algorithm\n          <key unwrap algorithm> (default: DES3)]\n        [-process_requests_and_key_records_only]\n");
        System.out.println("Example of 'Rewrap and Append ID Offset':\n\n        KRATool\n        -kratool_config_file /usr/share/pki/tools/KRATool.cfg\n        -source_ldif_file /export/pki/source.ldif\n        -target_ldif_file /export/pki/target.ldif\n        -log_file /export/pki/KRATool.log\n        -source_pki_security_database_path /export/pki\n        -source_storage_token_name 'Internal Key Storage Token'\n        -source_storage_certificate_nickname 'storageCert cert-pki-kra'\n        -target_storage_certificate_file /export/pki/target_storage.cert\n        -source_pki_security_database_pwdfile /export/pki/pwdfile\n        -append_id_offset 100000000000\n        -source_kra_naming_context 'alpha.example.com-pki-kra'\n        -target_kra_naming_context 'omega.example.com-pki-kra'\n        -process_requests_and_key_records_only\n");
        System.out.println("Example of 'Rewrap and Remove ID Offset':\n\n        KRATool\n        -kratool_config_file /usr/share/pki/tools/KRATool.cfg\n        -source_ldif_file /export/pki/source.ldif\n        -target_ldif_file /export/pki/target.ldif\n        -log_file /export/pki/KRATool.log\n        -source_pki_security_database_path /export/pki\n        -source_storage_token_name 'Internal Key Storage Token'\n        -source_storage_certificate_nickname 'storageCert cert-pki-kra'\n        -target_storage_certificate_file /export/pki/target_storage.cert\n        -source_pki_security_database_pwdfile /export/pki/pwdfile\n        -remove_id_offset 100000000000\n        -source_kra_naming_context 'alpha.example.com-pki-kra'\n        -target_kra_naming_context 'omega.example.com-pki-kra'\n        -process_requests_and_key_records_only\n");
        System.out.println("Example of 'Rewrap':\n\n        KRATool\n        -kratool_config_file /usr/share/pki/tools/KRATool.cfg\n        -source_ldif_file /export/pki/source.ldif\n        -target_ldif_file /export/pki/target.ldif\n        -log_file /export/pki/KRATool.log\n        -source_pki_security_database_path /export/pki\n        -source_storage_token_name 'Internal Key Storage Token'\n        -source_storage_certificate_nickname 'storageCert cert-pki-kra'\n        -target_storage_certificate_file /export/pki/target_storage.cert\n        -source_pki_security_database_pwdfile /export/pki/pwdfile\n        -source_kra_naming_context 'alpha.example.com-pki-kra'\n        -target_kra_naming_context 'omega.example.com-pki-kra'\n        -process_requests_and_key_records_only\n");
        System.out.println("Example of 'Append ID Offset':\n\n        KRATool\n        -kratool_config_file /usr/share/pki/tools/KRATool.cfg\n        -source_ldif_file /export/pki/source.ldif\n        -target_ldif_file /export/pki/target.ldif\n        -log_file /export/pki/KRATool.log\n        -append_id_offset 100000000000\n        -source_kra_naming_context 'alpha.example.com-pki-kra'\n        -target_kra_naming_context 'omega.example.com-pki-kra'\n        -process_requests_and_key_records_only\n");
        System.out.println("Example of 'Remove ID Offset':\n\n        KRATool\n        -kratool_config_file /usr/share/pki/tools/KRATool.cfg\n        -source_ldif_file /export/pki/source.ldif\n        -target_ldif_file /export/pki/target.ldif\n        -log_file /export/pki/KRATool.log\n        -remove_id_offset 100000000000\n        -source_kra_naming_context 'alpha.example.com-pki-kra'\n        -target_kra_naming_context 'omega.example.com-pki-kra'\n        -process_requests_and_key_records_only\n");
    }

    private static void open_log(String logfile) {
        try {
            logger = new PrintWriter(new BufferedWriter(new FileWriter(logfile)));
        }
        catch (IOException eFile) {
            System.err.println("ERROR:  Unable to open file '" + logfile + "' for writing: '" + eFile.toString() + "'\n");
            System.exit(0);
        }
    }

    private static void close_log(String logfile) {
        logger.close();
    }

    private static void log(String msg, boolean stderr) {
        current_date_and_time = KRATool.now(LOGGING_DATE_PATTERN);
        if (stderr) {
            System.err.println(msg);
        }
        logger.write(LEFT_BRACE + current_date_and_time + "]:  " + msg);
        logger.flush();
    }

    private static boolean arraysEqual(byte[] bytes, byte[] ints) {
        if (bytes == null || ints == null) {
            return false;
        }
        if (bytes.length != ints.length) {
            return false;
        }
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == ints[i]) continue;
            return false;
        }
        return true;
    }

    private static PrivateKey getPrivateKey() {
        try {
            PrivateKey[] pk = mSourceToken.getCryptoStore().getPrivateKeys();
            for (int i = 0; i < pk.length; ++i) {
                if (!KRATool.arraysEqual(pk[i].getUniqueID(), ((TokenCertificate)mUnwrapCert).getUniqueID())) continue;
                return pk[i];
            }
        }
        catch (TokenException exToken) {
            KRATool.log("ERROR:  Getting private key - TokenException: '" + exToken.toString() + "'\n", true);
            System.exit(0);
        }
        return null;
    }

    private static PublicKey getPublicKey() {
        BufferedReader inputCert = null;
        StringBuffer encodedBASE64Cert = new StringBuffer();
        byte[] decodedBASE64Cert = null;
        X509CertImpl cert = null;
        PublicKey key = null;
        RSAPublicKey rsakey = null;
        try {
            inputCert = new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(mTargetStorageCertificateFilename))));
        }
        catch (FileNotFoundException exWrapFileNotFound) {
            KRATool.log("ERROR:  No target storage certificate file named '" + mTargetStorageCertificateFilename + "' exists!  FileNotFoundException: '" + exWrapFileNotFound.toString() + "'\n", true);
            System.exit(0);
        }
        try {
            String encodedBASE64CertChunk;
            while ((encodedBASE64CertChunk = inputCert.readLine()) != null) {
                if (encodedBASE64CertChunk.startsWith(HEADER) || encodedBASE64CertChunk.startsWith(TRAILER)) continue;
                encodedBASE64Cert.append(encodedBASE64CertChunk.trim());
            }
        }
        catch (IOException exWrapReadLineIO) {
            KRATool.log("ERROR:  Unexpected BASE64 encoded error encountered while reading '" + mTargetStorageCertificateFilename + "'!  IOException: '" + exWrapReadLineIO.toString() + "'\n", true);
            System.exit(0);
        }
        try {
            inputCert.close();
        }
        catch (IOException exWrapCloseIO) {
            KRATool.log("ERROR:  Unexpected BASE64 encoded error encountered in closing '" + mTargetStorageCertificateFilename + "'!  IOException: '" + exWrapCloseIO.toString() + "'\n", true);
            System.exit(0);
        }
        decodedBASE64Cert = Utils.base64decode((String)encodedBASE64Cert.toString());
        try {
            cert = new X509CertImpl(decodedBASE64Cert);
        }
        catch (CertificateException exWrapCertificate) {
            KRATool.log("ERROR:  Error encountered in parsing certificate in '" + mTargetStorageCertificateFilename + "'  CertificateException: '" + exWrapCertificate.toString() + "'\n", true);
            System.exit(0);
        }
        key = cert.getPublicKey();
        if (key == null) {
            KRATool.log("ERROR:  Unable to extract public key from certificate that was stored in '" + mTargetStorageCertificateFilename + "'.\n", true);
            System.exit(0);
        }
        try {
            rsakey = new RSAPublicKey(key.getEncoded());
        }
        catch (InvalidKeyException exInvalidKey) {
            KRATool.log("ERROR:  Converting X.509 public key --> RSA public key - InvalidKeyException: '" + exInvalidKey.toString() + "'\n", true);
            System.exit(0);
        }
        mPublicKeySize = rsakey.getKeySize();
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean obtain_RSA_rewrapping_keys() {
        CryptoManager cm;
        block38: {
            cm = null;
            try {
                KRATool.log("Initializing source PKI security databases in '" + mSourcePKISecurityDatabasePath + "'.\n", true);
                CryptoManager.initialize((String)mSourcePKISecurityDatabasePath);
            }
            catch (KeyDatabaseException exKey) {
                KRATool.log("ERROR:  source_pki_security_database_path='" + mSourcePKISecurityDatabasePath + "' KeyDatabaseException: '" + exKey.toString() + "'\n", true);
                System.exit(0);
            }
            catch (CertDatabaseException exCert) {
                KRATool.log("ERROR:  source_pki_security_database_path='" + mSourcePKISecurityDatabasePath + "' CertDatabaseException: '" + exCert.toString() + "'\n", true);
                System.exit(0);
            }
            catch (AlreadyInitializedException exAlreadyInitialized) {
                KRATool.log("ERROR:  source_pki_security_database_path='" + mSourcePKISecurityDatabasePath + "' AlreadyInitializedException: '" + exAlreadyInitialized.toString() + "'\n", true);
                System.exit(0);
            }
            catch (GeneralSecurityException exSecurity) {
                KRATool.log("ERROR:  source_pki_security_database_path='" + mSourcePKISecurityDatabasePath + "' GeneralSecurityException: '" + exSecurity.toString() + "'\n", true);
                System.exit(0);
            }
            try {
                KRATool.log("Retrieving token from CryptoManager.\n", true);
                cm = CryptoManager.getInstance();
                KRATool.log("Retrieving source storage token called '" + mSourceStorageTokenName + "'.\n", true);
                mSourceToken = CryptoUtil.getKeyStorageToken((String)mSourceStorageTokenName);
                if (mSourceToken == null) {
                    return false;
                }
                if (!mPwdfileFlag) break block38;
                BufferedReader in = null;
                String pwd = null;
                try {
                    in = new BufferedReader(new FileReader(mSourcePKISecurityDatabasePwdfile));
                    pwd = in.readLine();
                    if (pwd == null) {
                        pwd = "";
                    }
                    Password mPwd = new Password(pwd.toCharArray());
                    try {
                        mSourceToken.login((PasswordCallback)mPwd);
                    }
                    finally {
                        mPwd.clear();
                    }
                }
                catch (Exception exReadPwd) {
                    KRATool.log("ERROR:  Failed to read the keydb password from the file '" + mSourcePKISecurityDatabasePwdfile + "'.  Exception: '" + exReadPwd.toString() + "'\n", true);
                    System.exit(0);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (Exception exUninitialized) {
                KRATool.log("ERROR:  Uninitialized CryptoManager - '" + exUninitialized.toString() + "'\n", true);
                System.exit(0);
            }
        }
        try {
            if (mSourceStorageTokenName.equals("Internal Key Storage Token")) {
                KRATool.log("Retrieving source storage cert with nickname of '" + mSourceStorageCertNickname + "'.\n", true);
                mUnwrapCert = cm.findCertByNickname(mSourceStorageCertNickname);
            } else {
                KRATool.log("Retrieving source storage cert with nickname of '" + mSourceStorageTokenName + COLON + mSourceStorageCertNickname + "'. \n", true);
                mUnwrapCert = cm.findCertByNickname(mSourceStorageTokenName + COLON + mSourceStorageCertNickname);
            }
            if (mUnwrapCert == null) {
                return false;
            }
        }
        catch (ObjectNotFoundException exUnwrapObjectNotFound) {
            if (mSourceStorageTokenName.equals("Internal Key Storage Token")) {
                KRATool.log("ERROR:  No internal source storage cert named '" + mSourceStorageCertNickname + "' exists!  ObjectNotFoundException: '" + exUnwrapObjectNotFound.toString() + "'\n", true);
            } else {
                KRATool.log("ERROR:  No source storage cert named '" + mSourceStorageTokenName + COLON + mSourceStorageCertNickname + "' exists!  ObjectNotFoundException: '" + exUnwrapObjectNotFound + "'\n", true);
            }
            System.exit(0);
        }
        catch (TokenException exUnwrapToken) {
            if (mSourceStorageTokenName.equals("Internal Key Storage Token")) {
                KRATool.log("ERROR:  No internal source storage cert named '" + mSourceStorageCertNickname + "' exists!  TokenException: '" + exUnwrapToken.toString() + "'\n", true);
            } else {
                KRATool.log("ERROR:  No source storage cert named '" + mSourceStorageTokenName + COLON + mSourceStorageCertNickname + "' exists!  TokenException: '" + exUnwrapToken + "'\n", true);
            }
            System.exit(0);
        }
        KRATool.log("BEGIN: Obtaining the private key from the source storage token . . .\n", true);
        mUnwrapPrivateKey = KRATool.getPrivateKey();
        if (mUnwrapPrivateKey == null) {
            KRATool.log("ERROR:  Failed extracting private key from the source storage token.\n", true);
            System.exit(0);
        }
        KRATool.log("FINISHED: Obtaining the private key from the source storage token.\n", true);
        try {
            KRATool.log("BEGIN: Obtaining the public key from the target storage certificate . . .\n", true);
            mWrapPublicKey = PK11PubKey.fromSPKI((byte[])KRATool.getPublicKey().getEncoded());
            if (mWrapPublicKey == null) {
                KRATool.log("ERROR:  Failed extracting public key from target storage certificate stored in '" + mTargetStorageCertificateFilename + "'\n", true);
                System.exit(0);
            }
            KRATool.log("FINISHED: Obtaining the public key from the target storage certificate.\n", true);
        }
        catch (InvalidKeyFormatException exInvalidPublicKey) {
            KRATool.log("ERROR:  Failed extracting public key from target storage certificate stored in '" + mTargetStorageCertificateFilename + "' InvalidKeyFormatException '" + exInvalidPublicKey.toString() + "'\n", true);
            System.exit(0);
        }
        return true;
    }

    private static byte[] rewrap_wrapped_key_data(byte[] wrappedKeyData) throws Exception {
        KeyWrapAlgorithm wrapAlg;
        DerValue val = null;
        DerInputStream in = null;
        DerValue dSession = null;
        byte[] source_session = null;
        DerValue dPri = null;
        byte[] pri = null;
        KeyWrapper source_rsaWrap = null;
        SymmetricKey sk = null;
        KeyWrapper target_rsaWrap = null;
        byte[] target_session = null;
        DerOutputStream tmp = null;
        byte[] rewrappedKeyData = null;
        try {
            val = new DerValue(wrappedKeyData);
            in = val.data;
            dSession = in.getDerValue();
            source_session = dSession.getOctetString();
            dPri = in.getDerValue();
            pri = dPri.getOctetString();
            wrapAlg = KeyWrapAlgorithm.RSA;
            if (mUseOAEPKeyWrapAlg) {
                wrapAlg = KeyWrapAlgorithm.RSA_OAEP;
            }
            source_rsaWrap = mSourceToken.getKeyWrapper(wrapAlg);
            OAEPParameterSpec config = null;
            if (mUseOAEPKeyWrapAlg) {
                config = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
            }
            source_rsaWrap.initUnwrap(mUnwrapPrivateKey, config);
            sk = source_rsaWrap.unwrapSymmetric(source_session, keyUnwrapAlgorithm, SymmetricKey.Usage.DECRYPT, 0);
            if (mDebug) {
                KRATool.log("DEBUG: sk = '" + Utils.base64encode((byte[])sk.getEncoded(), (boolean)true) + "' length = '" + sk.getEncoded().length + "'\n", false);
                KRATool.log("DEBUG: pri = '" + Utils.base64encode((byte[])pri, (boolean)true) + "' length = '" + pri.length + "'\n", false);
            }
        }
        catch (IOException exUnwrapIO) {
            KRATool.log("ERROR:  Unwrapping key data - IOException: '" + exUnwrapIO.toString() + "'\n", true);
            System.exit(0);
        }
        catch (NoSuchAlgorithmException exUnwrapAlgorithm) {
            KRATool.log("ERROR:  Unwrapping key data - NoSuchAlgorithmException: '" + exUnwrapAlgorithm.toString() + "'\n", true);
            System.exit(0);
        }
        catch (TokenException exUnwrapToken) {
            KRATool.log("ERROR:  Unwrapping key data - TokenException: '" + exUnwrapToken.toString() + "'\n", true);
            System.exit(0);
        }
        catch (InvalidKeyException exUnwrapInvalidKey) {
            KRATool.log("ERROR:  Unwrapping key data - InvalidKeyException: '" + exUnwrapInvalidKey.toString() + "'\n", true);
            System.exit(0);
        }
        catch (InvalidAlgorithmParameterException exUnwrapInvalidAlgorithm) {
            KRATool.log("ERROR:  Unwrapping key data - InvalidAlgorithmParameterException: '" + exUnwrapInvalidAlgorithm.toString() + "'\n", true);
            System.exit(0);
        }
        catch (IllegalStateException exUnwrapState) {
            KRATool.log("ERROR:  Unwrapping key data - InvalidStateException: '" + exUnwrapState.toString() + "'\n", true);
            System.exit(0);
        }
        wrapAlg = KeyWrapAlgorithm.RSA;
        if (mUseOAEPKeyWrapAlg) {
            wrapAlg = KeyWrapAlgorithm.RSA_OAEP;
        }
        try (DerOutputStream out = new DerOutputStream();){
            target_rsaWrap = mSourceToken.getKeyWrapper(wrapAlg);
            OAEPParameterSpec config = null;
            if (mUseOAEPKeyWrapAlg) {
                config = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
            }
            target_rsaWrap.initWrap(mWrapPublicKey, config);
            target_session = target_rsaWrap.wrap(sk);
            tmp = new DerOutputStream();
            tmp.putOctetString(target_session);
            tmp.putOctetString(pri);
            out.write((byte)48, tmp);
            rewrappedKeyData = out.toByteArray();
        }
        catch (NoSuchAlgorithmException exWrapAlgorithm) {
            KRATool.log("ERROR:  Wrapping key data - NoSuchAlgorithmException: '" + exWrapAlgorithm.toString() + "'\n", true);
            System.exit(0);
        }
        catch (TokenException exWrapToken) {
            KRATool.log("ERROR:  Wrapping key data - TokenException: '" + exWrapToken.toString() + "'\n", true);
            System.exit(0);
        }
        catch (InvalidKeyException exWrapInvalidKey) {
            KRATool.log("ERROR:  Wrapping key data - InvalidKeyException: '" + exWrapInvalidKey.toString() + "'\n", true);
            System.exit(0);
        }
        catch (InvalidAlgorithmParameterException exWrapInvalidAlgorithm) {
            KRATool.log("ERROR:  Wrapping key data - InvalidAlgorithmParameterException: '" + exWrapInvalidAlgorithm.toString() + "'\n", true);
            System.exit(0);
        }
        catch (IllegalStateException exWrapState) {
            KRATool.log("ERROR:  Wrapping key data - InvalidStateException: '" + exWrapState.toString() + "'\n", true);
            System.exit(0);
        }
        catch (IOException exWrapIO) {
            KRATool.log("ERROR:  Wrapping key data - IOException: '" + exWrapIO.toString() + "'\n", true);
            System.exit(0);
        }
        return rewrappedKeyData;
    }

    private static String stripEOL(String data) {
        StringBuffer buffer = new StringBuffer();
        String revised_data = null;
        for (int i = 0; i < data.length(); ++i) {
            if (data.charAt(i) == '\n' || data.charAt(i) == '\r') continue;
            buffer.append(data.charAt(i));
        }
        revised_data = buffer.toString();
        return revised_data;
    }

    private static String format_ldif_data(int length, String data) {
        StringBuffer revised_data = new StringBuffer();
        if (data.length() > length) {
            for (int i = 0; i < length; ++i) {
                revised_data.append(data.charAt(i));
            }
            revised_data.append(NEWLINE);
            int j = 0;
            for (int i = length; i < data.length(); ++i) {
                if (j == 0) {
                    revised_data.append(' ');
                }
                revised_data.append(data.charAt(i));
                if (++j != 76) continue;
                revised_data.append(NEWLINE);
                j = 0;
            }
        }
        return revised_data.toString().replaceAll("\\s+$", "");
    }

    private static String BigIntegerToDB(BigInteger i) {
        int len = i.toString().length();
        String ret = null;
        ret = len < 10 ? "0" + Integer.toString(len) + i.toString() : Integer.toString(len) + i.toString();
        return ret;
    }

    private static BigInteger BigIntegerFromDB(String i) {
        String s = i.substring(2);
        return new BigInteger(s);
    }

    private static String compose_numeric_line(String attribute, String delimiter, String source_line, boolean indexed) {
        Object target_line = null;
        String data = null;
        String revised_data = null;
        BigInteger value = null;
        if (!mAppendIdOffsetFlag && !mRemoveIdOffsetFlag) {
            return source_line;
        }
        try {
            data = source_line.substring(attribute.length() + 1).trim();
            if (!data.matches("[0-9]++")) {
                target_line = source_line;
                KRATool.log("Skipped changing non-numeric line '" + source_line + "'.\n", false);
            } else {
                value = indexed ? KRATool.BigIntegerFromDB(data) : new BigInteger(data);
                if (mAppendIdOffsetFlag) {
                    if (mAppendIdOffset.compareTo(value) == 1) {
                        revised_data = indexed ? KRATool.BigIntegerToDB(value.add(mAppendIdOffset)).toString() : value.add(mAppendIdOffset).toString();
                    } else {
                        KRATool.log("ERROR:  attribute='" + attribute + "' is greater than the specified append_id_offset='" + mAppendIdOffset.toString() + "'!\n", true);
                        System.exit(0);
                    }
                } else if (mRemoveIdOffsetFlag) {
                    if (mRemoveIdOffset.compareTo(value) <= 0) {
                        revised_data = indexed ? KRATool.BigIntegerToDB(value.subtract(mRemoveIdOffset)).toString() : value.subtract(mRemoveIdOffset).toString();
                    } else {
                        KRATool.log("ERROR:  attribute='" + attribute + "' is less than the specified remove_id_offset='" + mRemoveIdOffset.toString() + "'!\n", true);
                        System.exit(0);
                    }
                }
                target_line = attribute + delimiter + revised_data;
                KRATool.log("Changed numeric data '" + data + "' to '" + revised_data + "'.\n", false);
            }
        }
        catch (IndexOutOfBoundsException exBounds) {
            KRATool.log("ERROR:  source_line='" + source_line + "' IndexOutOfBoundsException: '" + exBounds.toString() + "'\n", true);
            System.exit(0);
        }
        catch (PatternSyntaxException exPattern) {
            KRATool.log("ERROR:  data='" + data + "' PatternSyntaxException: '" + exPattern.toString() + "'\n", true);
            System.exit(0);
        }
        return target_line;
    }

    private static String output_cn(String record_type, String line) {
        String output = null;
        if (record_type.equals(KRA_LDIF_ENROLLMENT)) {
            output = kratoolCfg.get(KRATOOL_CFG_ENROLLMENT_CN).booleanValue() ? KRATool.compose_numeric_line(KRA_LDIF_CN, SPACE, line, false) : line;
        } else if (record_type.equals(KRA_LDIF_CA_KEY_RECORD)) {
            output = kratoolCfg.get(KRATOOL_CFG_CA_KEY_RECORD_CN).booleanValue() ? KRATool.compose_numeric_line(KRA_LDIF_CN, SPACE, line, false) : line;
        } else if (record_type.equals(KRA_LDIF_RECOVERY)) {
            output = kratoolCfg.get(KRATOOL_CFG_RECOVERY_CN).booleanValue() ? KRATool.compose_numeric_line(KRA_LDIF_CN, SPACE, line, false) : line;
        } else if (record_type.equals(KRA_LDIF_TPS_KEY_RECORD)) {
            output = kratoolCfg.get(KRATOOL_CFG_TPS_KEY_RECORD_CN).booleanValue() ? KRATool.compose_numeric_line(KRA_LDIF_CN, SPACE, line, false) : line;
        } else if (record_type.equals(KRA_LDIF_KEYGEN)) {
            output = kratoolCfg.get(KRATOOL_CFG_KEYGEN_CN).booleanValue() ? KRATool.compose_numeric_line(KRA_LDIF_CN, SPACE, line, false) : line;
        } else if (record_type.equals(KRA_LDIF_KEYRECOVERY)) {
            output = kratoolCfg.get(KRATOOL_CFG_KEYRECOVERY_CN).booleanValue() ? KRATool.compose_numeric_line(KRA_LDIF_CN, SPACE, line, false) : line;
        } else if (record_type.equals(KRA_LDIF_RECORD)) {
            output = line;
        } else {
            KRATool.log("ERROR:  Mismatched record field='cn:' for record type='" + record_type + "'!\n", true);
        }
        return output;
    }

    private static String output_date_of_modify(String record_type, String line) {
        Object output = null;
        if (record_type.equals(KRA_LDIF_ENROLLMENT)) {
            if (kratoolCfg.get(KRATOOL_CFG_ENROLLMENT_DATE_OF_MODIFY).booleanValue()) {
                output = "dateOfModify: " + mDateOfModify;
                KRATool.log("Changed '" + line + "' to '" + (String)output + "'.\n", false);
            } else {
                output = line;
            }
        } else if (record_type.equals(KRA_LDIF_CA_KEY_RECORD)) {
            if (kratoolCfg.get(KRATOOL_CFG_CA_KEY_RECORD_DATE_OF_MODIFY).booleanValue()) {
                output = "dateOfModify: " + mDateOfModify;
                KRATool.log("Changed '" + line + "' to '" + (String)output + "'.\n", false);
            } else {
                output = line;
            }
        } else if (record_type.equals(KRA_LDIF_RECOVERY)) {
            if (kratoolCfg.get(KRATOOL_CFG_RECOVERY_DATE_OF_MODIFY).booleanValue()) {
                output = "dateOfModify: " + mDateOfModify;
                KRATool.log("Changed '" + line + "' to '" + (String)output + "'.\n", false);
            } else {
                output = line;
            }
        } else if (record_type.equals(KRA_LDIF_TPS_KEY_RECORD)) {
            if (kratoolCfg.get(KRATOOL_CFG_TPS_KEY_RECORD_DATE_OF_MODIFY).booleanValue()) {
                output = "dateOfModify: " + mDateOfModify;
                KRATool.log("Changed '" + line + "' to '" + (String)output + "'.\n", false);
            } else {
                output = line;
            }
        } else if (record_type.equals(KRA_LDIF_KEYGEN)) {
            if (kratoolCfg.get(KRATOOL_CFG_KEYGEN_DATE_OF_MODIFY).booleanValue()) {
                output = "dateOfModify: " + mDateOfModify;
                KRATool.log("Changed '" + line + "' to '" + (String)output + "'.\n", false);
            } else {
                output = line;
            }
        } else if (record_type.equals(KRA_LDIF_KEYRECOVERY)) {
            if (kratoolCfg.get(KRATOOL_CFG_KEYRECOVERY_DATE_OF_MODIFY).booleanValue()) {
                output = "dateOfModify: " + mDateOfModify;
                KRATool.log("Changed '" + line + "' to '" + (String)output + "'.\n", false);
            } else {
                output = line;
            }
        } else {
            KRATool.log("ERROR:  Mismatched record field='dateOfModify:' for record type='" + record_type + "'!\n", true);
        }
        return output;
    }

    private static String output_dn(String record_type, String line) {
        String[] embedded_cn_data = null;
        String embedded_cn_output = null;
        Object input = null;
        Object output = null;
        try {
            if (record_type.equals(KRA_LDIF_ENROLLMENT)) {
                if (kratoolCfg.get("kratool.ldif.caEnrollmentRequest.dn").booleanValue()) {
                    if (line.startsWith(KRA_LDIF_DN_EMBEDDED_CN_DATA)) {
                        embedded_cn_data = line.split(COMMA, 2);
                        embedded_cn_output = KRATool.compose_numeric_line(KRA_LDIF_DN_EMBEDDED_CN_DATA, EQUAL_SIGN, embedded_cn_data[0], false);
                        input = embedded_cn_output + COMMA + embedded_cn_data[1];
                    } else {
                        input = line;
                    }
                    output = mKraNamingContextsFlag ? ((String)input).replace(mSourceKraNamingContext, mTargetKraNamingContext) : input;
                } else {
                    output = line;
                }
            } else if (record_type.equals(KRA_LDIF_CA_KEY_RECORD)) {
                if (kratoolCfg.get("kratool.ldif.caEnrollmentRequest.dn").booleanValue()) {
                    if (line.startsWith(KRA_LDIF_DN_EMBEDDED_CN_DATA)) {
                        embedded_cn_data = line.split(COMMA, 2);
                        embedded_cn_output = KRATool.compose_numeric_line(KRA_LDIF_DN_EMBEDDED_CN_DATA, EQUAL_SIGN, embedded_cn_data[0], false);
                        input = embedded_cn_output + COMMA + embedded_cn_data[1];
                    } else {
                        input = line;
                    }
                    output = mKraNamingContextsFlag ? ((String)input).replace(mSourceKraNamingContext, mTargetKraNamingContext) : input;
                } else {
                    output = line;
                }
            } else if (record_type.equals(KRA_LDIF_RECOVERY)) {
                if (kratoolCfg.get(KRATOOL_CFG_RECOVERY_DN).booleanValue()) {
                    if (line.startsWith(KRA_LDIF_DN_EMBEDDED_CN_DATA)) {
                        embedded_cn_data = line.split(COMMA, 2);
                        embedded_cn_output = KRATool.compose_numeric_line(KRA_LDIF_DN_EMBEDDED_CN_DATA, EQUAL_SIGN, embedded_cn_data[0], false);
                        input = embedded_cn_output + COMMA + embedded_cn_data[1];
                    } else {
                        input = line;
                    }
                    output = mKraNamingContextsFlag ? ((String)input).replace(mSourceKraNamingContext, mTargetKraNamingContext) : input;
                } else {
                    output = line;
                }
            } else if (record_type.equals(KRA_LDIF_TPS_KEY_RECORD)) {
                if (kratoolCfg.get(KRATOOL_CFG_TPS_KEY_RECORD_DN).booleanValue()) {
                    if (line.startsWith(KRA_LDIF_DN_EMBEDDED_CN_DATA)) {
                        embedded_cn_data = line.split(COMMA, 2);
                        embedded_cn_output = KRATool.compose_numeric_line(KRA_LDIF_DN_EMBEDDED_CN_DATA, EQUAL_SIGN, embedded_cn_data[0], false);
                        input = embedded_cn_output + COMMA + embedded_cn_data[1];
                    } else {
                        input = line;
                    }
                    output = mKraNamingContextsFlag ? ((String)input).replace(mSourceKraNamingContext, mTargetKraNamingContext) : input;
                } else {
                    output = line;
                }
            } else if (record_type.equals(KRA_LDIF_KEYGEN)) {
                if (kratoolCfg.get(KRATOOL_CFG_KEYGEN_DN).booleanValue()) {
                    if (line.startsWith(KRA_LDIF_DN_EMBEDDED_CN_DATA)) {
                        embedded_cn_data = line.split(COMMA, 2);
                        embedded_cn_output = KRATool.compose_numeric_line(KRA_LDIF_DN_EMBEDDED_CN_DATA, EQUAL_SIGN, embedded_cn_data[0], false);
                        input = embedded_cn_output + COMMA + embedded_cn_data[1];
                    } else {
                        input = line;
                    }
                    output = mKraNamingContextsFlag ? ((String)input).replace(mSourceKraNamingContext, mTargetKraNamingContext) : input;
                } else {
                    output = line;
                }
            } else if (record_type.equals(KRA_LDIF_KEYRECOVERY)) {
                if (kratoolCfg.get(KRATOOL_CFG_KEYRECOVERY_DN).booleanValue()) {
                    if (line.startsWith(KRA_LDIF_DN_EMBEDDED_CN_DATA)) {
                        embedded_cn_data = line.split(COMMA, 2);
                        embedded_cn_output = KRATool.compose_numeric_line(KRA_LDIF_DN_EMBEDDED_CN_DATA, EQUAL_SIGN, embedded_cn_data[0], false);
                        input = embedded_cn_output + COMMA + embedded_cn_data[1];
                    } else {
                        input = line;
                    }
                    output = mKraNamingContextsFlag ? ((String)input).replace(mSourceKraNamingContext, mTargetKraNamingContext) : input;
                } else {
                    output = line;
                }
            } else if (record_type.equals(KRA_LDIF_RECORD)) {
                output = line;
            } else {
                KRATool.log("ERROR:  Mismatched record field='dn:' for record type='" + record_type + "'!\n", true);
            }
        }
        catch (PatternSyntaxException exDnEmbeddedCnNameValuePattern) {
            KRATool.log("ERROR:  line='" + line + "' PatternSyntaxException: '" + exDnEmbeddedCnNameValuePattern.toString() + "'\n", true);
        }
        catch (NullPointerException exNullPointerException) {
            KRATool.log("ERROR:  Unable to replace source KRA naming context '" + mSourceKraNamingContext + "' with target KRA naming context '" + mTargetKraNamingContext + "' NullPointerException: '" + exNullPointerException.toString() + "'\n", true);
        }
        return output;
    }

    private static String output_extdata_key_record(String record_type, String line) {
        String output = null;
        if (record_type.equals(KRA_LDIF_ENROLLMENT)) {
            output = kratoolCfg.get(KRATOOL_CFG_ENROLLMENT_EXTDATA_KEY_RECORD).booleanValue() ? KRATool.compose_numeric_line(KRA_LDIF_EXTDATA_KEY_RECORD, SPACE, line, false) : line;
        } else if (record_type.equals(KRA_LDIF_KEYGEN)) {
            output = kratoolCfg.get(KRATOOL_CFG_KEYGEN_EXTDATA_KEY_RECORD).booleanValue() ? KRATool.compose_numeric_line(KRA_LDIF_EXTDATA_KEY_RECORD, SPACE, line, false) : line;
        } else {
            KRATool.log("ERROR:  Mismatched record field='extdata-keyrecord:' for record type='" + record_type + "'!\n", true);
        }
        return output;
    }

    private static String output_extdata_request_id(String record_type, String line) {
        String output = null;
        if (record_type.equals(KRA_LDIF_ENROLLMENT)) {
            output = line;
        } else if (record_type.equals(KRA_LDIF_RECOVERY)) {
            output = kratoolCfg.get(KRATOOL_CFG_RECOVERY_EXTDATA_REQUEST_ID).booleanValue() ? KRATool.compose_numeric_line(KRA_LDIF_EXTDATA_REQUEST_ID, SPACE, line, false) : line;
        } else if (record_type.equals(KRA_LDIF_KEYGEN)) {
            output = kratoolCfg.get(KRATOOL_CFG_KEYGEN_EXTDATA_REQUEST_ID).booleanValue() ? KRATool.compose_numeric_line(KRA_LDIF_EXTDATA_REQUEST_ID, SPACE, line, false) : line;
        } else if (record_type.equals(KRA_LDIF_KEYRECOVERY)) {
            output = kratoolCfg.get(KRATOOL_CFG_KEYRECOVERY_EXTDATA_REQUEST_ID).booleanValue() ? KRATool.compose_numeric_line(KRA_LDIF_EXTDATA_REQUEST_ID, SPACE, line, false) : line;
        } else {
            KRATool.log("ERROR:  Mismatched record field='extdata-requestid:' for record type='" + record_type + "'!\n", true);
        }
        return output;
    }

    private static String output_extdata_request_notes(String record_type, String line) {
        StringBuffer input = new StringBuffer();
        String data = null;
        String unformatted_data = null;
        Object output = null;
        String next_line = null;
        if (line.length() > KRA_LDIF_EXTDATA_REQUEST_NOTES.length()) {
            input.append(line.substring(KRA_LDIF_EXTDATA_REQUEST_NOTES.length() + 1).trim());
        } else {
            input.append(line.substring(KRA_LDIF_EXTDATA_REQUEST_NOTES.length()).trim());
        }
        while ((line = ldif_record.next()) != null) {
            if (line.startsWith(SPACE)) {
                input.append(line.replaceFirst(SPACE, "").replace('\r', '\u0000').replace('\n', '\u0000'));
                continue;
            }
            next_line = line;
            break;
        }
        if (record_type.equals(KRA_LDIF_ENROLLMENT)) {
            if (kratoolCfg.get(KRATOOL_CFG_ENROLLMENT_EXTDATA_REQUEST_NOTES).booleanValue()) {
                if (mRewrapFlag && mAppendIdOffsetFlag) {
                    data = input.toString() + " [" + mDateOfModify + "]: REWRAPPED the 'existing symmetric session key' with the '" + mPublicKeySize + KRA_LDIF_RSA_MESSAGE + mSourcePKISecurityDatabasePwdfileMessage + " + APPENDED ID offset '" + mAppendIdOffset.toString() + TIC + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                } else if (mRewrapFlag && mRemoveIdOffsetFlag) {
                    data = input.toString() + " [" + mDateOfModify + "]: REWRAPPED the 'existing symmetric session key' with the '" + mPublicKeySize + KRA_LDIF_RSA_MESSAGE + mSourcePKISecurityDatabasePwdfileMessage + " + REMOVED ID offset '" + mRemoveIdOffset.toString() + TIC + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                } else if (mRewrapFlag) {
                    data = input.toString() + " [" + mDateOfModify + "]: REWRAPPED the 'existing symmetric session key' with the '" + mPublicKeySize + KRA_LDIF_RSA_MESSAGE + mSourcePKISecurityDatabasePwdfileMessage + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                } else if (mAppendIdOffsetFlag) {
                    data = input.toString() + " [" + mDateOfModify + "]: APPENDED ID offset '" + mAppendIdOffset.toString() + TIC + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                } else if (mRemoveIdOffsetFlag) {
                    data = input.toString() + " [" + mDateOfModify + "]: REMOVED ID offset '" + mRemoveIdOffset.toString() + TIC + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                }
                KRATool.log("Changed:\n'extdata-requestnotes: " + KRATool.format_ldif_data(56, input.toString()) + "'\n--->\n'" + (String)output + "'\n", false);
            } else {
                output = line;
            }
        } else if (record_type.equals(KRA_LDIF_RECOVERY)) {
            if (kratoolCfg.get(KRATOOL_CFG_RECOVERY_EXTDATA_REQUEST_NOTES).booleanValue()) {
                if (mRewrapFlag && mAppendIdOffsetFlag) {
                    data = input.toString() + " [" + mDateOfModify + "]: REWRAPPED the 'existing symmetric session key' with the '" + mPublicKeySize + KRA_LDIF_RSA_MESSAGE + mSourcePKISecurityDatabasePwdfileMessage + " + APPENDED ID offset '" + mAppendIdOffset.toString() + TIC + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                } else if (mRewrapFlag && mRemoveIdOffsetFlag) {
                    data = input.toString() + " [" + mDateOfModify + "]: REWRAPPED the 'existing symmetric session key' with the '" + mPublicKeySize + KRA_LDIF_RSA_MESSAGE + mSourcePKISecurityDatabasePwdfileMessage + " + REMOVED ID offset '" + mRemoveIdOffset.toString() + TIC + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                } else if (mRewrapFlag) {
                    data = input.toString() + " [" + mDateOfModify + "]: REWRAPPED the 'existing symmetric session key' with the '" + mPublicKeySize + KRA_LDIF_RSA_MESSAGE + mSourcePKISecurityDatabasePwdfileMessage + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                } else if (mAppendIdOffsetFlag) {
                    data = input.toString() + " [" + mDateOfModify + "]: APPENDED ID offset '" + mAppendIdOffset.toString() + TIC + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                } else if (mRemoveIdOffsetFlag) {
                    data = input.toString() + " [" + mDateOfModify + "]: REMOVED ID offset '" + mRemoveIdOffset.toString() + TIC + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                }
                KRATool.log("Changed:\n'extdata-requestnotes: " + KRATool.format_ldif_data(56, input.toString()) + "'\n--->\n'" + (String)output + "'\n", false);
            } else {
                output = line;
            }
        } else if (record_type.equals(KRA_LDIF_KEYGEN)) {
            if (kratoolCfg.get(KRATOOL_CFG_KEYGEN_EXTDATA_REQUEST_NOTES).booleanValue()) {
                if (mRewrapFlag && mAppendIdOffsetFlag) {
                    data = input.toString() + " [" + mDateOfModify + "]: REWRAPPED the 'existing symmetric session key' with the '" + mPublicKeySize + KRA_LDIF_RSA_MESSAGE + mSourcePKISecurityDatabasePwdfileMessage + " + APPENDED ID offset '" + mAppendIdOffset.toString() + TIC + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                } else if (mRewrapFlag && mRemoveIdOffsetFlag) {
                    data = input.toString() + " [" + mDateOfModify + "]: REWRAPPED the 'existing symmetric session key' with the '" + mPublicKeySize + KRA_LDIF_RSA_MESSAGE + mSourcePKISecurityDatabasePwdfileMessage + " + REMOVED ID offset '" + mRemoveIdOffset.toString() + TIC + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                } else if (mRewrapFlag) {
                    data = input.toString() + " [" + mDateOfModify + "]: REWRAPPED the 'existing symmetric session key' with the '" + mPublicKeySize + KRA_LDIF_RSA_MESSAGE + mSourcePKISecurityDatabasePwdfileMessage + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                } else if (mAppendIdOffsetFlag) {
                    data = input.toString() + " [" + mDateOfModify + "]: APPENDED ID offset '" + mAppendIdOffset.toString() + TIC + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                } else if (mRemoveIdOffsetFlag) {
                    data = input.toString() + " [" + mDateOfModify + "]: REMOVED ID offset '" + mRemoveIdOffset.toString() + TIC + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                }
                KRATool.log("Changed:\n'extdata-requestnotes: " + KRATool.format_ldif_data(56, input.toString()) + "'\n--->\n'" + (String)output + "'\n", false);
            } else {
                output = line;
            }
        } else if (record_type.equals(KRA_LDIF_KEYRECOVERY)) {
            if (kratoolCfg.get(KRATOOL_CFG_KEYRECOVERY_EXTDATA_REQUEST_NOTES).booleanValue()) {
                if (mRewrapFlag && mAppendIdOffsetFlag) {
                    data = input + " [" + mDateOfModify + "]: REWRAPPED the 'existing symmetric session key' with the '" + mPublicKeySize + KRA_LDIF_RSA_MESSAGE + mSourcePKISecurityDatabasePwdfileMessage + " + APPENDED ID offset '" + mAppendIdOffset.toString() + TIC + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                } else if (mRewrapFlag && mRemoveIdOffsetFlag) {
                    data = input + " [" + mDateOfModify + "]: REWRAPPED the 'existing symmetric session key' with the '" + mPublicKeySize + KRA_LDIF_RSA_MESSAGE + mSourcePKISecurityDatabasePwdfileMessage + " + REMOVED ID offset '" + mRemoveIdOffset.toString() + TIC + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                } else if (mRewrapFlag) {
                    data = input + " [" + mDateOfModify + "]: REWRAPPED the 'existing symmetric session key' with the '" + mPublicKeySize + KRA_LDIF_RSA_MESSAGE + mSourcePKISecurityDatabasePwdfileMessage + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                } else if (mAppendIdOffsetFlag) {
                    data = input + " [" + mDateOfModify + "]: APPENDED ID offset '" + mAppendIdOffset.toString() + TIC + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                } else if (mRemoveIdOffsetFlag) {
                    data = input + " [" + mDateOfModify + "]: REMOVED ID offset '" + mRemoveIdOffset.toString() + TIC + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                }
                KRATool.log("Changed:\n'extdata-requestnotes: " + KRATool.format_ldif_data(56, input.toString()) + "'\n--->\n'" + (String)output + "'\n", false);
            } else {
                output = line;
            }
        } else {
            KRATool.log("ERROR:  Mismatched record field='extdata-requestnotes:' for record type='" + record_type + "'!\n", true);
        }
        if (output != null) {
            output = (String)output + NEWLINE + next_line;
        }
        return output;
    }

    private static void create_extdata_request_notes(String record_type, String previous_line, PrintWriter writer) {
        String data = null;
        String unformatted_data = null;
        String output = null;
        if (record_type.equals(KRA_LDIF_RECOVERY)) {
            if (kratoolCfg.get(KRATOOL_CFG_RECOVERY_EXTDATA_REQUEST_NOTES).booleanValue() && !previous_line.startsWith(KRA_LDIF_EXTDATA_REQUEST_NOTES)) {
                if (mRewrapFlag && mAppendIdOffsetFlag) {
                    data = LEFT_BRACE + mDateOfModify + "]: REWRAPPED the 'existing symmetric session key' with the '" + mPublicKeySize + KRA_LDIF_RSA_MESSAGE + mSourcePKISecurityDatabasePwdfileMessage + " + APPENDED ID offset '" + mAppendIdOffset.toString() + TIC + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                } else if (mRewrapFlag && mRemoveIdOffsetFlag) {
                    data = LEFT_BRACE + mDateOfModify + "]: REWRAPPED the 'existing symmetric session key' with the '" + mPublicKeySize + KRA_LDIF_RSA_MESSAGE + mSourcePKISecurityDatabasePwdfileMessage + " + REMOVED ID offset '" + mRemoveIdOffset.toString() + TIC + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                } else if (mRewrapFlag) {
                    data = LEFT_BRACE + mDateOfModify + "]: REWRAPPED the 'existing symmetric session key' with the '" + mPublicKeySize + KRA_LDIF_RSA_MESSAGE + mSourcePKISecurityDatabasePwdfileMessage + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                } else if (mAppendIdOffsetFlag) {
                    data = LEFT_BRACE + mDateOfModify + "]: APPENDED ID offset '" + mAppendIdOffset.toString() + TIC + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                } else if (mRemoveIdOffsetFlag) {
                    data = LEFT_BRACE + mDateOfModify + "]: REMOVED ID offset '" + mRemoveIdOffset.toString() + TIC + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                }
                KRATool.log("Created:\n'" + output + "'\n", false);
                writer.write(output + NEWLINE);
                writer.flush();
                System.out.print(DOT);
            }
        } else if (record_type.equals(KRA_LDIF_KEYGEN)) {
            if (kratoolCfg.get(KRATOOL_CFG_KEYGEN_EXTDATA_REQUEST_NOTES).booleanValue() && !previous_line.startsWith(KRA_LDIF_EXTDATA_REQUEST_NOTES)) {
                if (mRewrapFlag && mAppendIdOffsetFlag) {
                    data = LEFT_BRACE + mDateOfModify + "]: REWRAPPED the 'existing symmetric session key' with the '" + mPublicKeySize + KRA_LDIF_RSA_MESSAGE + mSourcePKISecurityDatabasePwdfileMessage + " + APPENDED ID offset '" + mAppendIdOffset.toString() + TIC + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                } else if (mRewrapFlag && mRemoveIdOffsetFlag) {
                    data = LEFT_BRACE + mDateOfModify + "]: REWRAPPED the 'existing symmetric session key' with the '" + mPublicKeySize + KRA_LDIF_RSA_MESSAGE + mSourcePKISecurityDatabasePwdfileMessage + " + REMOVED ID offset '" + mRemoveIdOffset.toString() + TIC + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                } else if (mRewrapFlag) {
                    data = LEFT_BRACE + mDateOfModify + "]: REWRAPPED the 'existing symmetric session key' with the '" + mPublicKeySize + KRA_LDIF_RSA_MESSAGE + mSourcePKISecurityDatabasePwdfileMessage + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                } else if (mAppendIdOffsetFlag) {
                    data = LEFT_BRACE + mDateOfModify + "]: APPENDED ID offset '" + mAppendIdOffset.toString() + TIC + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                } else if (mRemoveIdOffsetFlag) {
                    data = LEFT_BRACE + mDateOfModify + "]: REMOVED ID offset '" + mRemoveIdOffset.toString() + TIC + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                    unformatted_data = KRATool.stripEOL(data);
                    output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
                }
                KRATool.log("Created:\n'" + output + "'\n", false);
                writer.write(output + NEWLINE);
                writer.flush();
                System.out.print(DOT);
            }
        } else if (record_type.equals(KRA_LDIF_KEYRECOVERY) && kratoolCfg.get(KRATOOL_CFG_KEYRECOVERY_EXTDATA_REQUEST_NOTES).booleanValue() && !previous_line.startsWith(KRA_LDIF_EXTDATA_REQUEST_NOTES)) {
            if (mRewrapFlag && mAppendIdOffsetFlag) {
                data = LEFT_BRACE + mDateOfModify + "]: REWRAPPED the 'existing symmetric session key' with the '" + mPublicKeySize + KRA_LDIF_RSA_MESSAGE + mSourcePKISecurityDatabasePwdfileMessage + " + APPENDED ID offset '" + mAppendIdOffset.toString() + TIC + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                unformatted_data = KRATool.stripEOL(data);
                output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
            } else if (mRewrapFlag && mRemoveIdOffsetFlag) {
                data = LEFT_BRACE + mDateOfModify + "]: REWRAPPED the 'existing symmetric session key' with the '" + mPublicKeySize + KRA_LDIF_RSA_MESSAGE + mSourcePKISecurityDatabasePwdfileMessage + " + REMOVED ID offset '" + mRemoveIdOffset.toString() + TIC + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                unformatted_data = KRATool.stripEOL(data);
                output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
            } else if (mRewrapFlag) {
                data = LEFT_BRACE + mDateOfModify + "]: REWRAPPED the 'existing symmetric session key' with the '" + mPublicKeySize + KRA_LDIF_RSA_MESSAGE + mSourcePKISecurityDatabasePwdfileMessage + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                unformatted_data = KRATool.stripEOL(data);
                output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
            } else if (mAppendIdOffsetFlag) {
                data = LEFT_BRACE + mDateOfModify + "]: APPENDED ID offset '" + mAppendIdOffset.toString() + TIC + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                unformatted_data = KRATool.stripEOL(data);
                output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
            } else if (mRemoveIdOffsetFlag) {
                data = LEFT_BRACE + mDateOfModify + "]: REMOVED ID offset '" + mRemoveIdOffset.toString() + TIC + mKraNamingContextMessage + mProcessRequestsAndKeyRecordsOnlyMessage;
                unformatted_data = KRATool.stripEOL(data);
                output = "extdata-requestnotes: " + KRATool.format_ldif_data(56, unformatted_data);
            }
            KRATool.log("Created:\n'" + output + "'\n", false);
            writer.write(output + NEWLINE);
            writer.flush();
            System.out.print(DOT);
        }
    }

    private static String output_extdata_serial_number(String record_type, String line) {
        String output = null;
        if (record_type.equals(KRA_LDIF_RECOVERY)) {
            output = kratoolCfg.get(KRATOOL_CFG_RECOVERY_EXTDATA_SERIAL_NUMBER).booleanValue() ? KRATool.compose_numeric_line(KRA_LDIF_EXTDATA_SERIAL_NUMBER, SPACE, line, false) : line;
        } else {
            KRATool.log("ERROR:  Mismatched record field='extdata-serialnumber:' for record type='" + record_type + "'!\n", true);
        }
        return output;
    }

    private static String output_private_key_data(String record_type, String line) {
        byte[] source_wrappedKeyData = null;
        byte[] target_wrappedKeyData = null;
        StringBuffer data = new StringBuffer();
        String revised_data = null;
        String unformatted_data = null;
        String formatted_data = null;
        Object output = null;
        try {
            if (record_type.equals(KRA_LDIF_CA_KEY_RECORD)) {
                if (kratoolCfg.get(KRATOOL_CFG_CA_KEY_RECORD_PRIVATE_KEY_DATA).booleanValue()) {
                    if (mRewrapFlag) {
                        data.append(line.substring(KRA_LDIF_PRIVATE_KEY_DATA.length() + 1).trim());
                        while ((line = ldif_record.next()) != null && line.startsWith(SPACE)) {
                            data.append(line.trim());
                        }
                        source_wrappedKeyData = Utils.base64decode((String)data.toString());
                        target_wrappedKeyData = KRATool.rewrap_wrapped_key_data(source_wrappedKeyData);
                        revised_data = Utils.base64encode((byte[])target_wrappedKeyData, (boolean)true);
                        unformatted_data = KRATool.stripEOL(revised_data);
                        formatted_data = KRATool.format_ldif_data(60, unformatted_data);
                        output = "privateKeyData:: " + formatted_data + NEWLINE + line;
                        KRATool.log("Changed 'privateKeyData' from:\n'" + data.toString() + "'\n to:\n'" + unformatted_data + "'\n", false);
                    } else {
                        output = line;
                    }
                } else {
                    output = line;
                }
            } else if (record_type.equals(KRA_LDIF_TPS_KEY_RECORD)) {
                if (kratoolCfg.get(KRATOOL_CFG_TPS_KEY_RECORD_PRIVATE_KEY_DATA).booleanValue()) {
                    if (mRewrapFlag) {
                        data.append(line.substring(KRA_LDIF_PRIVATE_KEY_DATA.length() + 1).trim());
                        while ((line = ldif_record.next()) != null && line.startsWith(SPACE)) {
                            data.append(line.trim());
                        }
                        source_wrappedKeyData = Utils.base64decode((String)data.toString());
                        target_wrappedKeyData = KRATool.rewrap_wrapped_key_data(source_wrappedKeyData);
                        revised_data = Utils.base64encode((byte[])target_wrappedKeyData, (boolean)true);
                        unformatted_data = KRATool.stripEOL(revised_data);
                        formatted_data = KRATool.format_ldif_data(60, unformatted_data);
                        output = "privateKeyData:: " + formatted_data + NEWLINE + line;
                        KRATool.log("Changed 'privateKeyData' from:\n'" + data.toString() + "'\n to:\n'" + unformatted_data + "'\n", false);
                    } else {
                        output = line;
                    }
                } else {
                    output = line;
                }
            } else {
                KRATool.log("ERROR:  Mismatched record field='privateKeyData::' for record type='" + record_type + "'!\n", true);
            }
        }
        catch (Exception exRewrap) {
            KRATool.log("ERROR:  Unable to rewrap BINARY BASE 64 data. Exception: '" + exRewrap.toString() + "'\n", true);
        }
        return output;
    }

    private static String output_request_id(String record_type, String line) {
        String output = null;
        if (record_type.equals(KRA_LDIF_ENROLLMENT)) {
            output = kratoolCfg.get(KRATOOL_CFG_ENROLLMENT_REQUEST_ID).booleanValue() ? KRATool.compose_numeric_line(KRA_LDIF_REQUEST_ID, SPACE, line, true) : line;
        } else if (record_type.equals(KRA_LDIF_RECOVERY)) {
            output = kratoolCfg.get(KRATOOL_CFG_RECOVERY_REQUEST_ID).booleanValue() ? KRATool.compose_numeric_line(KRA_LDIF_REQUEST_ID, SPACE, line, true) : line;
        } else if (record_type.equals(KRA_LDIF_KEYGEN)) {
            output = kratoolCfg.get(KRATOOL_CFG_KEYGEN_REQUEST_ID).booleanValue() ? KRATool.compose_numeric_line(KRA_LDIF_REQUEST_ID, SPACE, line, true) : line;
        } else if (record_type.equals(KRA_LDIF_KEYRECOVERY)) {
            output = kratoolCfg.get(KRATOOL_CFG_KEYRECOVERY_REQUEST_ID).booleanValue() ? KRATool.compose_numeric_line(KRA_LDIF_REQUEST_ID, SPACE, line, true) : line;
        } else {
            KRATool.log("ERROR:  Mismatched record field='requestId:' for record type='" + record_type + "'!\n", true);
        }
        return output;
    }

    private static String output_serial_no(String record_type, String line) {
        String output = null;
        if (record_type.equals(KRA_LDIF_CA_KEY_RECORD)) {
            output = kratoolCfg.get(KRATOOL_CFG_CA_KEY_RECORD_SERIAL_NO).booleanValue() ? KRATool.compose_numeric_line(KRA_LDIF_SERIAL_NO, SPACE, line, true) : line;
        } else if (record_type.equals(KRA_LDIF_TPS_KEY_RECORD)) {
            output = kratoolCfg.get(KRATOOL_CFG_TPS_KEY_RECORD_SERIAL_NO).booleanValue() ? KRATool.compose_numeric_line(KRA_LDIF_SERIAL_NO, SPACE, line, true) : line;
        } else if (record_type.equals(KRA_LDIF_RECORD)) {
            output = line;
        } else {
            KRATool.log("ERROR:  Mismatched record field='serialno:' for record type='" + record_type + "'!\n", true);
        }
        return output;
    }

    private static String output_extdata_auth_token_user(String record_type, String line) {
        String output = null;
        try {
            if (record_type.equals(KRA_LDIF_ENROLLMENT)) {
                output = mKraNamingContextsFlag ? line.replace(mSourceKraNamingContext, mTargetKraNamingContext) : line;
            } else {
                KRATool.log("ERROR:  Mismatched record field='extdata-auth--005ftoken;user:' for record type='" + record_type + "'!\n", true);
            }
        }
        catch (NullPointerException exNullPointerException) {
            KRATool.log("ERROR:  Unable to replace source KRA naming context '" + mSourceKraNamingContext + "' with target KRA naming context '" + mTargetKraNamingContext + "' NullPointerException: '" + exNullPointerException.toString() + "'\n", true);
        }
        return output;
    }

    private static String output_extdata_auth_token_user_dn(String record_type, String line) {
        String output = null;
        try {
            if (record_type.equals(KRA_LDIF_ENROLLMENT)) {
                output = mKraNamingContextsFlag ? line.replace(mSourceKraNamingContext, mTargetKraNamingContext) : line;
            } else {
                KRATool.log("ERROR:  Mismatched record field='extdata-auth--005ftoken;userdn:' for record type='" + record_type + "'!\n", true);
            }
        }
        catch (NullPointerException exNullPointerException) {
            KRATool.log("ERROR:  Unable to replace source KRA naming context '" + mSourceKraNamingContext + "' with target KRA naming context '" + mTargetKraNamingContext + "' NullPointerException: '" + exNullPointerException.toString() + "'\n", true);
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean convert_source_ldif_to_target_ldif() {
        boolean success = false;
        BufferedReader reader = null;
        PrintWriter writer = null;
        String input = null;
        String line2 = null;
        String previous_line = null;
        String output = null;
        String data = null;
        String record_type = null;
        if (mRewrapFlag && !(success = KRATool.obtain_RSA_rewrapping_keys())) {
            return false;
        }
        record = new Vector(0);
        try {
            reader = new BufferedReader(new FileReader(mSourceLdifFilename));
            writer = new PrintWriter(new BufferedWriter(new FileWriter(mTargetLdifFilename)));
            System.out.print("PROCESSING: ");
            while ((input = reader.readLine()) != null) {
                success = record.add(input);
                if (!success) {
                    boolean bl = false;
                    return bl;
                }
                if (!input.equals("")) {
                    if (input.startsWith(KRA_LDIF_REQUEST_TYPE)) {
                        record_type = input.substring(KRA_LDIF_REQUEST_TYPE.length() + 1).trim();
                        if (record_type.equals(KRA_LDIF_ENROLLMENT) || record_type.equals(KRA_LDIF_KEYGEN) || record_type.equals(KRA_LDIF_RECOVERY) || record_type.equals(KRA_LDIF_KEYRECOVERY)) continue;
                        KRATool.log("ERROR:  Unknown LDIF record type='" + record_type + "'!\n", true);
                        boolean bl = false;
                        return bl;
                    }
                    if (!input.startsWith(KRA_LDIF_ARCHIVED_BY)) continue;
                    data = input.substring(KRA_LDIF_ARCHIVED_BY.length() + 1).trim();
                    if (data.startsWith(KRA_LDIF_TPS_KEY_RECORD)) {
                        record_type = KRA_LDIF_TPS_KEY_RECORD;
                        continue;
                    }
                    if (data.startsWith(KRA_LDIF_CA_KEY_RECORD)) {
                        record_type = KRA_LDIF_CA_KEY_RECORD;
                        continue;
                    }
                    KRATool.log("ERROR:  Unable to determine LDIF record type from data='" + data + "'!\n", true);
                    boolean bl = false;
                    return bl;
                }
                if (record_type == null && mProcessRequestsAndKeyRecordsOnlyFlag) {
                    System.out.print("x");
                    KRATool.log("INFO:  Throwing away an LDIF record which is neither a Request nor a Key Record!\n", false);
                    record.clear();
                    continue;
                }
                if (record_type == null) {
                    record_type = KRA_LDIF_RECORD;
                }
                for (String line2 : record) {
                    if (line2.startsWith(KRA_LDIF_CN)) {
                        output = KRATool.output_cn(record_type, line2);
                        if (output == null) {
                            boolean bl = false;
                            return bl;
                        }
                    } else if (line2.startsWith(KRA_LDIF_DATE_OF_MODIFY)) {
                        output = KRATool.output_date_of_modify(record_type, line2);
                        if (output == null) {
                            boolean bl = false;
                            return bl;
                        }
                    } else if (line2.startsWith(KRA_LDIF_DN)) {
                        output = KRATool.output_dn(record_type, line2);
                        if (output == null) {
                            boolean bl = false;
                            return bl;
                        }
                    } else if (line2.startsWith(KRA_LDIF_EXTDATA_KEY_RECORD)) {
                        output = KRATool.output_extdata_key_record(record_type, line2);
                        if (output == null) {
                            boolean bl = false;
                            return bl;
                        }
                    } else if (line2.startsWith(KRA_LDIF_EXTDATA_REQUEST_ID)) {
                        output = KRATool.output_extdata_request_id(record_type, line2);
                        if (output == null) {
                            boolean bl = false;
                            return bl;
                        }
                    } else if (line2.startsWith(KRA_LDIF_EXTDATA_REQUEST_NOTES)) {
                        output = KRATool.output_extdata_request_notes(record_type, line2);
                        if (output == null) {
                            boolean bl = false;
                            return bl;
                        }
                    } else if (line2.startsWith(KRA_LDIF_EXTDATA_REQUEST_TYPE)) {
                        if (previous_line == null) {
                            boolean bl = false;
                            return bl;
                        }
                        KRATool.create_extdata_request_notes(record_type, previous_line, writer);
                        output = line2;
                    } else if (line2.startsWith(KRA_LDIF_EXTDATA_SERIAL_NUMBER)) {
                        output = KRATool.output_extdata_serial_number(record_type, line2);
                        if (output == null) {
                            boolean bl = false;
                            return bl;
                        }
                    } else if (line2.startsWith(KRA_LDIF_PRIVATE_KEY_DATA)) {
                        output = KRATool.output_private_key_data(record_type, line2);
                        if (output == null) {
                            boolean bl = false;
                            return bl;
                        }
                    } else if (line2.startsWith(KRA_LDIF_REQUEST_ID)) {
                        output = KRATool.output_request_id(record_type, line2);
                        if (output == null) {
                            boolean bl = false;
                            return bl;
                        }
                    } else if (line2.startsWith(KRA_LDIF_SERIAL_NO)) {
                        output = KRATool.output_serial_no(record_type, line2);
                        if (output == null) {
                            boolean bl = false;
                            return bl;
                        }
                    } else if (previous_line != null && previous_line.startsWith(KRA_LDIF_EXTDATA_AUTH_TOKEN_USER)) {
                        output = KRATool.output_extdata_auth_token_user(record_type, line2);
                        if (output == null) {
                            boolean bl = false;
                            return bl;
                        }
                    } else if (previous_line != null && previous_line.startsWith(KRA_LDIF_EXTDATA_AUTH_TOKEN_USER_DN)) {
                        output = KRATool.output_extdata_auth_token_user_dn(record_type, line2);
                        if (output == null) {
                            boolean bl = false;
                            return bl;
                        }
                    } else {
                        output = line2;
                    }
                    previous_line = output;
                    writer.write(output + NEWLINE);
                    writer.flush();
                    System.out.print(DOT);
                }
                System.out.print("!");
                record.clear();
            }
            System.out.println(" FINISHED.\n");
        }
        catch (IOException exIO) {
            KRATool.log("ERROR:  line='" + line2 + "' OR output='" + output + "' IOException: '" + exIO.toString() + "'\n", true);
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (writer != null) {
                writer.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean process_kratool_config_file() {
        BufferedReader reader = null;
        String line = null;
        String[] name_value_pair = null;
        String name = null;
        Boolean value = null;
        try {
            reader = new BufferedReader(new FileReader(mKratoolCfgFilename));
            kratoolCfg = new Hashtable();
            System.out.print("PROCESSING KRATOOL CONFIG FILE: ");
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith(KRATOOL_CFG_PREFIX)) continue;
                name_value_pair = line.split(EQUAL_SIGN);
                name = name_value_pair[0];
                value = name_value_pair[1].equals("true") ? Boolean.TRUE : Boolean.FALSE;
                if (!name.equals(KRATOOL_CFG_ENROLLMENT_CN) && !name.equals(KRATOOL_CFG_ENROLLMENT_DATE_OF_MODIFY) && !name.equals("kratool.ldif.caEnrollmentRequest.dn") && !name.equals(KRATOOL_CFG_ENROLLMENT_EXTDATA_KEY_RECORD) && !name.equals(KRATOOL_CFG_ENROLLMENT_EXTDATA_REQUEST_NOTES) && !name.equals(KRATOOL_CFG_ENROLLMENT_REQUEST_ID) && !name.equals(KRATOOL_CFG_CA_KEY_RECORD_CN) && !name.equals(KRATOOL_CFG_CA_KEY_RECORD_DATE_OF_MODIFY) && !name.equals("kratool.ldif.caEnrollmentRequest.dn") && !name.equals(KRATOOL_CFG_CA_KEY_RECORD_PRIVATE_KEY_DATA) && !name.equals(KRATOOL_CFG_CA_KEY_RECORD_SERIAL_NO) && !name.equals(KRATOOL_CFG_RECOVERY_CN) && !name.equals(KRATOOL_CFG_RECOVERY_DATE_OF_MODIFY) && !name.equals(KRATOOL_CFG_RECOVERY_DN) && !name.equals(KRATOOL_CFG_RECOVERY_EXTDATA_REQUEST_ID) && !name.equals(KRATOOL_CFG_RECOVERY_EXTDATA_REQUEST_NOTES) && !name.equals(KRATOOL_CFG_RECOVERY_EXTDATA_SERIAL_NUMBER) && !name.equals(KRATOOL_CFG_RECOVERY_REQUEST_ID) && !name.equals(KRATOOL_CFG_TPS_KEY_RECORD_CN) && !name.equals(KRATOOL_CFG_TPS_KEY_RECORD_DATE_OF_MODIFY) && !name.equals(KRATOOL_CFG_TPS_KEY_RECORD_DN) && !name.equals(KRATOOL_CFG_TPS_KEY_RECORD_PRIVATE_KEY_DATA) && !name.equals(KRATOOL_CFG_TPS_KEY_RECORD_SERIAL_NO) && !name.equals(KRATOOL_CFG_KEYGEN_CN) && !name.equals(KRATOOL_CFG_KEYGEN_DATE_OF_MODIFY) && !name.equals(KRATOOL_CFG_KEYGEN_DN) && !name.equals(KRATOOL_CFG_KEYGEN_EXTDATA_KEY_RECORD) && !name.equals(KRATOOL_CFG_KEYGEN_EXTDATA_REQUEST_ID) && !name.equals(KRATOOL_CFG_KEYGEN_EXTDATA_REQUEST_NOTES) && !name.equals(KRATOOL_CFG_KEYGEN_REQUEST_ID) && !name.equals(KRATOOL_CFG_KEYRECOVERY_REQUEST_ID) && !name.equals(KRATOOL_CFG_KEYRECOVERY_DN) && !name.equals(KRATOOL_CFG_KEYRECOVERY_DATE_OF_MODIFY) && !name.equals(KRATOOL_CFG_KEYRECOVERY_EXTDATA_REQUEST_ID) && !name.equals(KRATOOL_CFG_KEYRECOVERY_CN) && !name.equals(KRATOOL_CFG_KEYRECOVERY_EXTDATA_REQUEST_NOTES)) continue;
                kratoolCfg.put(name, value);
                System.out.print(DOT);
            }
            System.out.println(" FINISHED.\n");
        }
        catch (FileNotFoundException exKratoolCfgFileNotFound) {
            KRATool.log("ERROR:  No KRATOOL config file named '" + mKratoolCfgFilename + "' exists!  FileNotFoundException: '" + exKratoolCfgFileNotFound.toString() + "'\n", true);
            boolean bl = false;
            return bl;
        }
        catch (IOException exKratoolCfgIO) {
            KRATool.log("ERROR:  line='" + line + "' IOException: '" + exKratoolCfgIO.toString() + "'\n", true);
            boolean bl = false;
            return bl;
        }
        catch (PatternSyntaxException exKratoolCfgNameValuePattern) {
            KRATool.log("ERROR:  line='" + line + "' PatternSyntaxException: '" + exKratoolCfgNameValuePattern.toString() + "'\n", true);
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public static void main(String[] args) {
        boolean success;
        File sourceDBPwdfile;
        String keyUnwrapAlgorithmName;
        Object use_PKI_security_database_pwdfile;
        String process_requests_and_key_records_only;
        Object process_kra_naming_context_fields;
        String remove_id_offset;
        String append_id_offset;
        block84: {
            block83: {
                append_id_offset = null;
                remove_id_offset = null;
                process_kra_naming_context_fields = null;
                process_requests_and_key_records_only = null;
                use_PKI_security_database_pwdfile = null;
                keyUnwrapAlgorithmName = null;
                File cfgFile = null;
                File sourceFile = null;
                File sourceDBPath = null;
                sourceDBPwdfile = null;
                File targetStorageCertFile = null;
                File targetFile = null;
                File logFile = null;
                success = false;
                mDateOfModify = KRATool.now(DATE_OF_MODIFY_PATTERN);
                if (args.length != 10 && args.length != 11 && args.length != 14 && args.length != 15 && args.length != 17 && args.length != 16 && args.length != 17 && args.length != 18 && args.length != 19 && args.length != 20 && args.length != 21 && args.length != 22 && args.length != 23 && args.length != 25 && args.length != 18 && args.length != 19 && args.length != 20 && args.length != 21 && args.length != 22 && args.length != 23 && args.length != 24 && args.length != 25 && args.length != 26 && args.length != 27) {
                    System.err.println("ERROR:  Incorrect number of arguments!\n");
                    KRATool.printUsage();
                    System.exit(0);
                }
                for (int i = 0; i < args.length; i += 2) {
                    if (args[i].equals(KRATOOL_CFG_FILE)) {
                        mKratoolCfgFilename = args[i + 1];
                        ++mMandatoryNameValuePairs;
                        continue;
                    }
                    if (args[i].equals(SOURCE_LDIF_FILE)) {
                        mSourceLdifFilename = args[i + 1];
                        ++mMandatoryNameValuePairs;
                        continue;
                    }
                    if (args[i].equals(TARGET_LDIF_FILE)) {
                        mTargetLdifFilename = args[i + 1];
                        ++mMandatoryNameValuePairs;
                        continue;
                    }
                    if (args[i].equals(LOG_FILE)) {
                        mLogFilename = args[i + 1];
                        ++mMandatoryNameValuePairs;
                        continue;
                    }
                    if (args[i].equals(SOURCE_NSS_DB_PATH)) {
                        mSourcePKISecurityDatabasePath = args[i + 1];
                        ++mRewrapNameValuePairs;
                        continue;
                    }
                    if (args[i].equals(SOURCE_STORAGE_TOKEN_NAME)) {
                        mSourceStorageTokenName = args[i + 1];
                        ++mRewrapNameValuePairs;
                        continue;
                    }
                    if (args[i].equals(SOURCE_STORAGE_CERT_NICKNAME)) {
                        mSourceStorageCertNickname = args[i + 1];
                        ++mRewrapNameValuePairs;
                        continue;
                    }
                    if (args[i].equals(TARGET_STORAGE_CERTIFICATE_FILE)) {
                        mTargetStorageCertificateFilename = args[i + 1];
                        ++mRewrapNameValuePairs;
                        continue;
                    }
                    if (args[i].equals(SOURCE_NSS_DB_PWDFILE)) {
                        mSourcePKISecurityDatabasePwdfile = args[i + 1];
                        ++mPKISecurityDatabasePwdfileNameValuePairs;
                        continue;
                    }
                    if (args[i].equals(APPEND_ID_OFFSET)) {
                        append_id_offset = args[i + 1];
                        ++mAppendIdOffsetNameValuePairs;
                        continue;
                    }
                    if (args[i].equals(REMOVE_ID_OFFSET)) {
                        remove_id_offset = args[i + 1];
                        ++mRemoveIdOffsetNameValuePairs;
                        continue;
                    }
                    if (args[i].equals(SOURCE_KRA_NAMING_CONTEXT)) {
                        mSourceKraNamingContext = args[i + 1];
                        ++mKraNamingContextNameValuePairs;
                        continue;
                    }
                    if (args[i].equals(TARGET_KRA_NAMING_CONTEXT)) {
                        mTargetKraNamingContext = args[i + 1];
                        ++mKraNamingContextNameValuePairs;
                        continue;
                    }
                    if (args[i].equals(PROCESS_REQUESTS_AND_KEY_RECORDS_ONLY)) {
                        mProcessRequestsAndKeyRecordsOnlyFlag = true;
                        --i;
                        continue;
                    }
                    if (args[i].contentEquals(KEY_UNWRAP_ALGORITHM)) {
                        keyUnwrapAlgorithmName = args[i + 1];
                        continue;
                    }
                    if (args[i].contentEquals(USE_OAEP_RSA_KEY_WRAP)) {
                        mUseOAEPKeyWrapAlg = true;
                        continue;
                    }
                    System.err.println("ERROR:  Unknown argument '" + args[i] + "'!\n");
                    KRATool.printUsage();
                    System.exit(0);
                }
                if (mMandatoryNameValuePairs != 4 || mKratoolCfgFilename == null || mKratoolCfgFilename.length() == 0 || mSourceLdifFilename == null || mSourceLdifFilename.length() == 0 || mTargetLdifFilename == null || mTargetLdifFilename.length() == 0 || mLogFilename == null || mLogFilename.length() == 0) {
                    System.err.println("ERROR:  Missing mandatory arguments!\n");
                    KRATool.printUsage();
                    System.exit(0);
                } else {
                    cfgFile = new File(mKratoolCfgFilename);
                    if (!cfgFile.exists() || !cfgFile.isFile() || cfgFile.length() == 0L) {
                        System.err.println("ERROR:  '" + mKratoolCfgFilename + "' does NOT exist, is NOT a file, or is empty!\n");
                        KRATool.printUsage();
                        System.exit(0);
                    }
                    if (!(sourceFile = new File(mSourceLdifFilename)).exists() || !sourceFile.isFile() || sourceFile.length() == 0L) {
                        System.err.println("ERROR:  '" + mSourceLdifFilename + "' does NOT exist, is NOT a file, or is empty!\n");
                        KRATool.printUsage();
                        System.exit(0);
                    }
                    if ((targetFile = new File(mTargetLdifFilename)).exists()) {
                        System.err.println("ERROR:  '" + mTargetLdifFilename + "' ALREADY exists!\n");
                        KRATool.printUsage();
                        System.exit(0);
                    }
                    if ((logFile = new File(mLogFilename)).exists()) {
                        System.err.println("ERROR:  '" + mLogFilename + "' ALREADY exists!\n");
                        KRATool.printUsage();
                        System.exit(0);
                    }
                }
                if (mRewrapNameValuePairs > 0) {
                    if (mRewrapNameValuePairs != 4 || mSourcePKISecurityDatabasePath == null || mSourcePKISecurityDatabasePath.length() == 0 || mSourceStorageTokenName == null || mSourceStorageTokenName.length() == 0 || mSourceStorageCertNickname == null || mSourceStorageCertNickname.length() == 0 || mTargetStorageCertificateFilename == null || mTargetStorageCertificateFilename.length() == 0) {
                        System.err.println("ERROR:  Missing 'Rewrap' arguments!\n");
                        KRATool.printUsage();
                        System.exit(0);
                    } else {
                        sourceDBPath = new File(mSourcePKISecurityDatabasePath);
                        if (!sourceDBPath.exists() || !sourceDBPath.isDirectory()) {
                            System.err.println("ERROR:  '" + mSourcePKISecurityDatabasePath + "' does NOT exist or 'is NOT a directory!\n");
                            KRATool.printUsage();
                            System.exit(0);
                        }
                        if (!(targetStorageCertFile = new File(mTargetStorageCertificateFilename)).exists() || !targetStorageCertFile.isFile() || targetStorageCertFile.length() == 0L) {
                            System.err.println("ERROR:  '" + mTargetStorageCertificateFilename + "' does NOT exist, is NOT a file, or is empty!\n");
                            KRATool.printUsage();
                            System.exit(0);
                        }
                        mRewrapFlag = true;
                    }
                }
                if (mAppendIdOffsetNameValuePairs > 0 && mRemoveIdOffsetNameValuePairs > 0) {
                    System.err.println("ERROR:  The 'append ID Offset' option and the 'remove ID Offset' option are mutually exclusive!\n");
                    KRATool.printUsage();
                    System.exit(0);
                }
                if (mAppendIdOffsetNameValuePairs > 0) {
                    if (mAppendIdOffsetNameValuePairs == 1 && append_id_offset != null && append_id_offset.length() != 0) {
                        try {
                            if (!append_id_offset.matches("[0-9]++")) {
                                System.err.println("ERROR:  '" + append_id_offset + "' contains non-numeric characters!\n");
                                KRATool.printUsage();
                                System.exit(0);
                                break block83;
                            }
                            mAppendIdOffset = new BigInteger(append_id_offset);
                            mAppendIdOffsetFlag = true;
                        }
                        catch (PatternSyntaxException exAppendPattern) {
                            System.err.println("ERROR:  append_id_offset='" + append_id_offset + "' PatternSyntaxException: '" + exAppendPattern.toString() + "'\n");
                            System.exit(0);
                        }
                    } else {
                        System.err.println("ERROR:  Missing 'append ID Offset' arguments!\n");
                        KRATool.printUsage();
                        System.exit(0);
                    }
                }
            }
            if (mRemoveIdOffsetNameValuePairs > 0) {
                if (mRemoveIdOffsetNameValuePairs == 1 && remove_id_offset != null && remove_id_offset.length() != 0) {
                    try {
                        if (!remove_id_offset.matches("[0-9]++")) {
                            System.err.println("ERROR:  '" + remove_id_offset + "' contains non-numeric characters!\n");
                            KRATool.printUsage();
                            System.exit(0);
                            break block84;
                        }
                        mRemoveIdOffset = new BigInteger(remove_id_offset);
                        mRemoveIdOffsetFlag = true;
                    }
                    catch (PatternSyntaxException exRemovePattern) {
                        System.err.println("ERROR:  remove_id_offset='" + remove_id_offset + "' PatternSyntaxException: '" + exRemovePattern.toString() + "'\n");
                        System.exit(0);
                    }
                } else {
                    System.err.println("ERROR:  Missing 'remove ID Offset' arguments!\n");
                    KRATool.printUsage();
                    System.exit(0);
                }
            }
        }
        if (!(mRewrapFlag || mAppendIdOffsetFlag || mRemoveIdOffsetFlag)) {
            System.err.println("ERROR:  At least one of the 'rewrap', 'append ID Offset', or 'remove ID Offset' options MUST be specified!\n");
            KRATool.printUsage();
            System.exit(0);
        }
        if (mPKISecurityDatabasePwdfileNameValuePairs > 0) {
            if (mPKISecurityDatabasePwdfileNameValuePairs != 1 || mSourcePKISecurityDatabasePwdfile == null || mSourcePKISecurityDatabasePwdfile.length() == 0) {
                System.err.println("ERROR:  Missing 'Password File' arguments!\n");
                KRATool.printUsage();
                System.exit(0);
            } else if (mRewrapFlag) {
                sourceDBPwdfile = new File(mSourcePKISecurityDatabasePwdfile);
                if (!sourceDBPwdfile.exists() || !sourceDBPwdfile.isFile() || sourceDBPwdfile.length() == 0L) {
                    System.err.println("ERROR:  '" + mSourcePKISecurityDatabasePwdfile + "' does NOT exist, is NOT a file, or is empty!\n");
                    KRATool.printUsage();
                    System.exit(0);
                }
                use_PKI_security_database_pwdfile = " -source_pki_security_database_pwdfile '" + mSourcePKISecurityDatabasePwdfile + TIC;
                mSourcePKISecurityDatabasePwdfileMessage = " + USED source PKI security database password file";
                mPwdfileFlag = true;
            } else {
                System.err.println("ERROR:  The '-source_pki_security_database_pwdfile' option is ONLY valid when performing rewrapping.\n");
                KRATool.printUsage();
                System.exit(0);
            }
        } else {
            use_PKI_security_database_pwdfile = "";
            mSourcePKISecurityDatabasePwdfileMessage = "";
        }
        if (mKraNamingContextNameValuePairs > 0) {
            if (mKraNamingContextNameValuePairs != 2 || mSourceKraNamingContext == null || mSourceKraNamingContext.length() == 0 || mTargetKraNamingContext == null || mTargetKraNamingContext.length() == 0) {
                System.err.println("ERROR:  Both 'source KRA naming context' and 'target KRA naming context' options MUST be specified!\n");
                KRATool.printUsage();
                System.exit(0);
            } else {
                process_kra_naming_context_fields = " -source_kra_naming_context '" + mSourceKraNamingContext + "' -target_kra_naming_context '" + mTargetKraNamingContext + TIC;
                mKraNamingContextMessage = " + RENAMED source KRA naming context '" + mSourceKraNamingContext + KRA_LDIF_TARGET_NAME_CONTEXT_MESSAGE + mTargetKraNamingContext + TIC;
                mKraNamingContextsFlag = true;
            }
        } else {
            process_kra_naming_context_fields = "";
            mKraNamingContextMessage = "";
        }
        if (keyUnwrapAlgorithmName != null) {
            if (keyUnwrapAlgorithmName.equalsIgnoreCase("DES3")) {
                keyUnwrapAlgorithm = SymmetricKey.DES3;
            } else if (keyUnwrapAlgorithmName.equalsIgnoreCase("AES")) {
                keyUnwrapAlgorithm = SymmetricKey.AES;
            } else {
                System.err.println("ERROR:  Unsupported key unwrap algorithm '" + keyUnwrapAlgorithmName + "'\n");
                System.exit(1);
            }
        }
        if (mProcessRequestsAndKeyRecordsOnlyFlag) {
            process_requests_and_key_records_only = " -process_requests_and_key_records_only";
            mProcessRequestsAndKeyRecordsOnlyMessage = " + PROCESSED requests and key records ONLY!";
        } else {
            process_requests_and_key_records_only = "";
            mProcessRequestsAndKeyRecordsOnlyMessage = "";
        }
        KRATool.open_log(mLogFilename);
        if (mRewrapFlag && mAppendIdOffsetFlag) {
            KRATool.log("BEGIN \"KRATool -kratool_config_file " + mKratoolCfgFilename + " -source_ldif_file " + mSourceLdifFilename + " -target_ldif_file " + mTargetLdifFilename + " -log_file " + mLogFilename + " -source_pki_security_database_path " + mSourcePKISecurityDatabasePath + " -source_storage_token_name '" + mSourceStorageTokenName + "' -source_storage_certificate_nickname '" + mSourceStorageCertNickname + "' -target_storage_certificate_file " + mTargetStorageCertificateFilename + SPACE + (String)use_PKI_security_database_pwdfile + "-append_id_offset " + append_id_offset + (String)process_kra_naming_context_fields + process_requests_and_key_records_only + "-unwrap_algorithm " + keyUnwrapAlgorithmName + "\" . . .\n", true);
        } else if (mRewrapFlag && mRemoveIdOffsetFlag) {
            KRATool.log("BEGIN \"KRATool -kratool_config_file " + mKratoolCfgFilename + " -source_ldif_file " + mSourceLdifFilename + " -target_ldif_file " + mTargetLdifFilename + " -log_file " + mLogFilename + " -source_pki_security_database_path " + mSourcePKISecurityDatabasePath + " -source_storage_token_name '" + mSourceStorageTokenName + "' -source_storage_certificate_nickname '" + mSourceStorageCertNickname + "' -target_storage_certificate_file " + mTargetStorageCertificateFilename + SPACE + (String)use_PKI_security_database_pwdfile + "-remove_id_offset " + remove_id_offset + (String)process_kra_naming_context_fields + process_requests_and_key_records_only + "-unwrap_algorithm " + keyUnwrapAlgorithmName + "\" . . .\n", true);
        } else if (mRewrapFlag) {
            KRATool.log("BEGIN \"KRATool -kratool_config_file " + mKratoolCfgFilename + " -source_ldif_file " + mSourceLdifFilename + " -target_ldif_file " + mTargetLdifFilename + " -log_file " + mLogFilename + " -source_pki_security_database_path " + mSourcePKISecurityDatabasePath + " -source_storage_token_name '" + mSourceStorageTokenName + "' -source_storage_certificate_nickname '" + mSourceStorageCertNickname + "' -target_storage_certificate_file " + mTargetStorageCertificateFilename + (String)use_PKI_security_database_pwdfile + (String)process_kra_naming_context_fields + process_requests_and_key_records_only + "-unwrap_algorithm " + keyUnwrapAlgorithmName + "\" . . .\n", true);
        } else if (mAppendIdOffsetFlag) {
            KRATool.log("BEGIN \"KRATool -kratool_config_file " + mKratoolCfgFilename + " -source_ldif_file " + mSourceLdifFilename + " -target_ldif_file " + mTargetLdifFilename + " -log_file " + mLogFilename + " -append_id_offset " + append_id_offset + (String)process_kra_naming_context_fields + process_requests_and_key_records_only + "\" . . .\n", true);
        } else if (mRemoveIdOffsetFlag) {
            KRATool.log("BEGIN \"KRATool -kratool_config_file " + mKratoolCfgFilename + " -source_ldif_file " + mSourceLdifFilename + " -target_ldif_file " + mTargetLdifFilename + " -log_file " + mLogFilename + " -remove_id_offset " + remove_id_offset + (String)process_kra_naming_context_fields + process_requests_and_key_records_only + "\" . . .\n", true);
        }
        success = KRATool.process_kratool_config_file();
        if (!success) {
            KRATool.log("FAILED processing kratool config file!\n", true);
        } else {
            KRATool.log("SUCCESSFULLY processed kratool config file!\n", true);
            success = KRATool.convert_source_ldif_to_target_ldif();
            if (!success) {
                KRATool.log("FAILED converting source LDIF file --> target LDIF file!\n", true);
            } else {
                KRATool.log("SUCCESSFULLY converted source LDIF file --> target LDIF file!\n", true);
            }
        }
        if (mRewrapFlag && mAppendIdOffsetFlag) {
            KRATool.log("FINISHED \"KRATool -kratool_config_file " + mKratoolCfgFilename + " -source_ldif_file " + mSourceLdifFilename + " -target_ldif_file " + mTargetLdifFilename + " -log_file " + mLogFilename + " -source_pki_security_database_path " + mSourcePKISecurityDatabasePath + " -source_storage_token_name '" + mSourceStorageTokenName + "' -source_storage_certificate_nickname '" + mSourceStorageCertNickname + "' -target_storage_certificate_file " + mTargetStorageCertificateFilename + SPACE + (String)use_PKI_security_database_pwdfile + "-append_id_offset " + append_id_offset + (String)process_kra_naming_context_fields + process_requests_and_key_records_only + "-unwrap_algorithm " + keyUnwrapAlgorithmName + "\".\n", true);
        } else if (mRewrapFlag && mRemoveIdOffsetFlag) {
            KRATool.log("FINISHED \"KRATool -kratool_config_file " + mKratoolCfgFilename + " -source_ldif_file " + mSourceLdifFilename + " -target_ldif_file " + mTargetLdifFilename + " -log_file " + mLogFilename + " -source_pki_security_database_path " + mSourcePKISecurityDatabasePath + " -source_storage_token_name '" + mSourceStorageTokenName + "' -source_storage_certificate_nickname '" + mSourceStorageCertNickname + "' -target_storage_certificate_file " + mTargetStorageCertificateFilename + SPACE + (String)use_PKI_security_database_pwdfile + "-remove_id_offset " + remove_id_offset + (String)process_kra_naming_context_fields + process_requests_and_key_records_only + "-unwrap_algorithm " + keyUnwrapAlgorithmName + "\".\n", true);
        } else if (mRewrapFlag) {
            KRATool.log("FINISHED \"KRATool -kratool_config_file " + mKratoolCfgFilename + " -source_ldif_file " + mSourceLdifFilename + " -target_ldif_file " + mTargetLdifFilename + " -log_file " + mLogFilename + " -source_pki_security_database_path " + mSourcePKISecurityDatabasePath + " -source_storage_token_name '" + mSourceStorageTokenName + "' -source_storage_certificate_nickname '" + mSourceStorageCertNickname + "' -target_storage_certificate_file " + mTargetStorageCertificateFilename + (String)use_PKI_security_database_pwdfile + (String)process_kra_naming_context_fields + process_requests_and_key_records_only + "-unwrap_algorithm " + keyUnwrapAlgorithmName + "\".\n", true);
        } else if (mAppendIdOffsetFlag) {
            KRATool.log("FINISHED \"KRATool -kratool_config_file " + mKratoolCfgFilename + " -source_ldif_file " + mSourceLdifFilename + " -target_ldif_file " + mTargetLdifFilename + " -log_file " + mLogFilename + " -append_id_offset " + append_id_offset + (String)process_kra_naming_context_fields + process_requests_and_key_records_only + "\".\n", true);
        } else if (mRemoveIdOffsetFlag) {
            KRATool.log("FINISHED \"KRATool -kratool_config_file " + mKratoolCfgFilename + " -source_ldif_file " + mSourceLdifFilename + " -target_ldif_file " + mTargetLdifFilename + " -log_file " + mLogFilename + " -remove_id_offset " + remove_id_offset + (String)process_kra_naming_context_fields + process_requests_and_key_records_only + "\".\n", true);
        }
        KRATool.close_log(mLogFilename);
    }
}

