/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools;

import com.netscape.cmsutil.crypto.CryptoUtil;
import java.math.BigInteger;
import java.security.KeyPair;
import java.util.Date;
import java.util.Hashtable;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.InitializationValues;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGenerator;
import org.mozilla.jss.netscape.security.x509.RevokedCertImpl;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CRLImpl;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.PasswordCallback;

public class TestCRLSigning {
    public static void printUsage() {
        System.out.println("Command <dbdir> <numreovked> <keysize> <tokenname> <tokenpwd>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String dir = args[0];
        String num = args[1];
        String keysize = args[2];
        String tokenname = args[3];
        String tokenpwd = args[4];
        CryptoManager cm = null;
        InitializationValues vals = new InitializationValues(dir, "", "", "secmod.db");
        CryptoManager.initialize((InitializationValues)vals);
        cm = CryptoManager.getInstance();
        CryptoToken token = CryptoUtil.getKeyStorageToken((String)tokenname);
        Password pass = new Password(tokenpwd.toCharArray());
        try {
            token.login((PasswordCallback)pass);
        }
        finally {
            pass.clear();
        }
        KeyPairGenerator g = token.getKeyPairGenerator(KeyPairAlgorithm.RSA);
        g.initialize(Integer.parseInt(keysize));
        KeyPair pair = g.genKeyPair();
        long startPutting = System.currentTimeMillis();
        Date curDate = new Date();
        Hashtable<BigInteger, RevokedCertImpl> badCerts = new Hashtable<BigInteger, RevokedCertImpl>();
        int n = Integer.parseInt(num);
        for (int i = 0; i < n; ++i) {
            badCerts.put(new BigInteger(Integer.toString(i)), new RevokedCertImpl(new BigInteger(Integer.toString(i)), curDate));
        }
        long endPutting = System.currentTimeMillis();
        long startConstructing = System.currentTimeMillis();
        X509CRLImpl crl = new X509CRLImpl(new X500Name("CN=Signer"), null, curDate, curDate, badCerts, null);
        long endConstructing = System.currentTimeMillis();
        System.out.println("Start signing");
        long startSigning = System.currentTimeMillis();
        crl.sign(pair.getPrivate(), "SHA1withRSA");
        long endSigning = System.currentTimeMillis();
        System.out.println("Done signing");
        long startData = System.currentTimeMillis();
        byte[] data = crl.getTBSCertList();
        long endData = System.currentTimeMillis();
        System.out.println("Summary:");
        System.out.println("Insertion time (ms): " + Long.toString(endPutting - startPutting));
        System.out.println("Construction time (ms): " + Long.toString(endConstructing - startConstructing));
        System.out.println("Signing time (ms): " + Long.toString(endSigning - startSigning));
        System.out.println("Data time (ms): " + Long.toString(endData - startData));
        System.out.println("Data size (bytes): " + Long.toString(data.length));
    }
}

