/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.kra;

import com.netscape.certsrv.key.KeyClient;
import com.netscape.certsrv.key.KeyRequestInfo;
import com.netscape.certsrv.request.RequestId;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.kra.KRAKeyCLI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KRAKeyRequestReviewCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(KRAKeyRequestReviewCLI.class);
    public KRAKeyCLI keyCLI;

    public KRAKeyRequestReviewCLI(KRAKeyCLI keyCLI) {
        super("request-review", "Review key request", (CLI)keyCLI);
        this.keyCLI = keyCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <Request ID> --action <action> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "action", true, "Action to be performed on the request.\nValid values: approve, reject, cancel.");
        option.setArgName("Action to perform");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 1) {
            throw new Exception("Incorrect number of arguments specified.");
        }
        RequestId reqId = new RequestId(cmdArgs[0]);
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        KeyClient keyClient = this.keyCLI.getKeyClient();
        String action = cmd.getOptionValue("action");
        if (action == null) {
            throw new Exception("Missing action");
        }
        switch (action.toLowerCase()) {
            case "approve": {
                keyClient.approveRequest(reqId);
                break;
            }
            case "reject": {
                keyClient.rejectRequest(reqId);
                break;
            }
            case "cancel": {
                keyClient.cancelRequest(reqId);
                break;
            }
            default: {
                throw new Exception("Invalid action.");
            }
        }
        KeyRequestInfo keyRequestInfo = keyClient.getRequestInfo(reqId);
        MainCLI.printMessage("Result");
        KRAKeyCLI.printKeyRequestInfo(keyRequestInfo);
    }
}

