/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tks;

import com.netscape.certsrv.system.TPSConnectorClient;
import com.netscape.certsrv.system.TPSConnectorData;
import com.netscape.cmstools.tks.TKSCLI;
import com.netscape.cmstools.tks.TPSConnectorAddCLI;
import com.netscape.cmstools.tks.TPSConnectorFindCLI;
import com.netscape.cmstools.tks.TPSConnectorModCLI;
import com.netscape.cmstools.tks.TPSConnectorRemoveCLI;
import com.netscape.cmstools.tks.TPSConnectorShowCLI;
import org.dogtagpki.cli.CLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPSConnectorCLI
extends CLI {
    public static Logger logger = LoggerFactory.getLogger(TPSConnectorCLI.class);
    public TKSCLI tksCLI;
    public TPSConnectorClient tpsConnectorClient;

    public TPSConnectorCLI(TKSCLI tksCLI) {
        super("tpsconnector", "TPS connector management commands", (CLI)tksCLI);
        this.tksCLI = tksCLI;
        this.addModule((CLI)new TPSConnectorAddCLI(this));
        this.addModule((CLI)new TPSConnectorFindCLI(this));
        this.addModule((CLI)new TPSConnectorModCLI(this));
        this.addModule((CLI)new TPSConnectorRemoveCLI(this));
        this.addModule((CLI)new TPSConnectorShowCLI(this));
    }

    public String getFullName() {
        return this.parent.getFullName() + "-" + this.name;
    }

    public TPSConnectorClient getTPSConnectorClient() throws Exception {
        if (this.tpsConnectorClient != null) {
            return this.tpsConnectorClient;
        }
        this.tpsConnectorClient = (TPSConnectorClient)this.parent.getClient("admin/tps-connectors");
        return this.tpsConnectorClient;
    }

    public static void printConnectorInfo(TPSConnectorData data) {
        System.out.println("  Connector ID: " + data.getID());
        if (data.getHost() != null) {
            System.out.println("  Host: " + data.getHost());
        }
        if (data.getPort() != null) {
            System.out.println("  Port: " + data.getPort());
        }
        if (data.getUserID() != null) {
            System.out.println("  User ID: " + data.getUserID());
        }
        if (data.getNickname() != null) {
            System.out.println("  Nickname: " + data.getNickname());
        }
    }
}

