/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(NodeLifecycle.class);
    private static final Map<State, Set<State>> TRANSITIONS = NodeLifecycle.buildTransitions();
    private State state = State.INIT;

    NodeLifecycle() {
    }

    private static Map<State, Set<State>> buildTransitions() {
        EnumMap<State, Set<State>> res = new EnumMap<State, Set<State>>(State.class);
        res.put(State.INIT, NodeLifecycle.toSet(State.STARTING));
        res.put(State.STARTING, NodeLifecycle.toSet(State.OPERATIONAL, State.RESTARTING, State.HARD_STOPPING, State.STOPPED));
        res.put(State.OPERATIONAL, NodeLifecycle.toSet(State.RESTARTING, State.STOPPING, State.HARD_STOPPING, State.STOPPED));
        res.put(State.STOPPING, NodeLifecycle.toSet(State.HARD_STOPPING, State.STOPPED));
        res.put(State.RESTARTING, NodeLifecycle.toSet(State.STARTING, State.HARD_STOPPING, State.STOPPED));
        res.put(State.HARD_STOPPING, NodeLifecycle.toSet(State.STOPPED));
        res.put(State.STOPPED, NodeLifecycle.toSet(State.STARTING));
        return Collections.unmodifiableMap(res);
    }

    private static Set<State> toSet(State ... states) {
        if (states.length == 0) {
            return Collections.emptySet();
        }
        if (states.length == 1) {
            return Collections.singleton(states[0]);
        }
        return EnumSet.copyOf(Arrays.asList(states));
    }

    State getState() {
        return this.state;
    }

    synchronized boolean tryToMoveTo(State to) {
        boolean res = false;
        State currentState = this.state;
        if (TRANSITIONS.get((Object)currentState).contains((Object)to)) {
            this.state = to;
            res = true;
        }
        LOG.trace("tryToMoveTo from {} to {} => {}", new Object[]{currentState, to, res});
        return res;
    }

    static enum State {
        INIT,
        STARTING,
        OPERATIONAL,
        RESTARTING,
        STOPPING,
        HARD_STOPPING,
        STOPPED;

    }
}

