/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application.command;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.application.command.JvmOptions;
import org.sonar.process.Props;

public class EsJvmOptions
extends JvmOptions<EsJvmOptions> {
    private static final String ELASTICSEARCH_JVM_OPTIONS_HEADER = "# This file has been automatically generated by SonarQube during startup.\n# Please use sonar.search.javaOpts and/or sonar.search.javaAdditionalOpts in sonar.properties to specify jvm options for Elasticsearch\n\n# DO NOT EDIT THIS FILE\n\n";

    public EsJvmOptions(Props props, File tmpDir) {
        super(EsJvmOptions.mandatoryOptions(tmpDir, props));
    }

    private static Map<String, String> mandatoryOptions(File tmpDir, Props props) {
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>(30);
        res.put("-XX:+UseConcMarkSweepGC", "");
        res.put("-XX:CMSInitiatingOccupancyFraction=", "75");
        res.put("-XX:+UseCMSInitiatingOccupancyOnly", "");
        res.put("-Des.networkaddress.cache.ttl=", "60");
        res.put("-Des.networkaddress.cache.negative.ttl=", "10");
        res.put("-XX:+AlwaysPreTouch", "");
        res.put("-Xss1m", "");
        res.put("-Djava.awt.headless=", "true");
        res.put("-Dfile.encoding=", "UTF-8");
        res.put("-Djna.nosys=", "true");
        res.put("-XX:-OmitStackTraceInFastThrow", "");
        res.put("-Dio.netty.noUnsafe=", "true");
        res.put("-Dio.netty.noKeySetOptimization=", "true");
        res.put("-Dio.netty.recycler.maxCapacityPerThread=", "0");
        res.put("-Dlog4j.shutdownHookEnabled=", "false");
        res.put("-Dlog4j2.disable.jmx=", "true");
        res.put("-Djava.io.tmpdir=", tmpDir.getAbsolutePath());
        res.put("-XX:ErrorFile=", "../logs/es_hs_err_pid%p.log");
        if (!props.value("sonar.jdbc.url", "").contains("jdbc:h2") && !props.valueAsBoolean("sonar.es.bootstrap.checks.disable")) {
            res.put("-Des.enforce.bootstrap.checks=", "true");
        }
        return res;
    }

    public void writeToJvmOptionFile(File file) {
        String jvmOptions = this.getAll().stream().collect(Collectors.joining("\n"));
        String jvmOptionsContent = ELASTICSEARCH_JVM_OPTIONS_HEADER + jvmOptions;
        try {
            Files.write(file.toPath(), jvmOptionsContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot write Elasticsearch jvm options file", e);
        }
    }
}

