/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application.command;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nullable;
import org.sonar.application.command.AbstractCommand;
import org.sonar.application.command.JvmOptions;
import org.sonar.process.ProcessId;
import org.sonar.process.System2;

public class JavaCommand<T extends JvmOptions>
extends AbstractCommand<JavaCommand<T>> {
    private final Map<String, String> arguments = new LinkedHashMap<String, String>();
    private String className;
    private JvmOptions<T> jvmOptions;
    private final List<String> classpath = new ArrayList<String>();
    private boolean readsArgumentsFromFile;
    private Long gracefulStopTimeoutMs;

    public JavaCommand(ProcessId id, File workDir) {
        super(id, workDir, System2.INSTANCE);
    }

    public Map<String, String> getArguments() {
        return this.arguments;
    }

    public JavaCommand<T> setArgument(String key, @Nullable String value) {
        if (value == null) {
            this.arguments.remove(key);
        } else {
            this.arguments.put(key, value);
        }
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public JavaCommand<T> setClassName(String className) {
        this.className = className;
        return this;
    }

    public JvmOptions<T> getJvmOptions() {
        return this.jvmOptions;
    }

    public JavaCommand<T> setJvmOptions(JvmOptions<T> jvmOptions) {
        this.jvmOptions = jvmOptions;
        return this;
    }

    public List<String> getClasspath() {
        return this.classpath;
    }

    public JavaCommand<T> addClasspath(String s) {
        this.classpath.add(s);
        return this;
    }

    public boolean getReadsArgumentsFromFile() {
        return this.readsArgumentsFromFile;
    }

    public JavaCommand<T> setReadsArgumentsFromFile(boolean readsArgumentsFromFile) {
        this.readsArgumentsFromFile = readsArgumentsFromFile;
        return this;
    }

    public JavaCommand<T> setArguments(Properties args) {
        for (Map.Entry<Object, Object> entry : args.entrySet()) {
            this.setArgument(entry.getKey().toString(), entry.getValue() != null ? entry.getValue().toString() : null);
        }
        return this;
    }

    public long getGracefulStopTimeoutMs() {
        Objects.requireNonNull(this.gracefulStopTimeoutMs, "gracefulStopTimeoutMs has not been set");
        return this.gracefulStopTimeoutMs;
    }

    public JavaCommand<T> setGracefulStopTimeoutMs(long gracefulStopTimeoutMs) {
        this.gracefulStopTimeoutMs = gracefulStopTimeoutMs;
        return this;
    }

    public String toString() {
        return "JavaCommand{workDir=" + this.getWorkDir() + ", arguments=" + this.arguments + ", className='" + this.className + '\'' + ", jvmOptions=" + this.jvmOptions + ", classpath=" + this.classpath + ", readsArgumentsFromFile=" + this.readsArgumentsFromFile + ", gracefulStopTimeoutMs=" + this.gracefulStopTimeoutMs + ", envVariables=" + this.getEnvVariables() + ", suppressedEnvVariables=" + this.getSuppressedEnvVariables() + '}';
    }
}

