/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application.es;

import com.google.common.net.HostAndPort;
import io.netty.util.ThreadDeathWatcher;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.transport.Netty4Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.application.es.EsConnector;

public class EsConnectorImpl
implements EsConnector {
    private static final Logger LOG = LoggerFactory.getLogger(EsConnectorImpl.class);
    private final AtomicReference<TransportClient> transportClient = new AtomicReference<Object>(null);
    private final String clusterName;
    private final Set<HostAndPort> hostAndPorts;

    public EsConnectorImpl(String clusterName, Set<HostAndPort> hostAndPorts) {
        this.clusterName = clusterName;
        this.hostAndPorts = hostAndPorts;
    }

    @Override
    public ClusterHealthStatus getClusterHealthStatus() {
        return ((ClusterHealthResponse)this.getTransportClient().admin().cluster().health(new ClusterHealthRequest().waitForStatus(ClusterHealthStatus.YELLOW).timeout(TimeValue.timeValueSeconds((long)30L))).actionGet()).getStatus();
    }

    @Override
    public void stop() {
        this.transportClient.set(null);
    }

    private TransportClient getTransportClient() {
        TransportClient res = this.transportClient.get();
        if (res == null) {
            res = this.buildTransportClient();
            if (this.transportClient.compareAndSet(null, res)) {
                return res;
            }
            return this.transportClient.get();
        }
        return res;
    }

    private TransportClient buildTransportClient() {
        Settings.Builder esSettings = Settings.builder();
        esSettings.put("cluster.name", this.clusterName);
        MinimalTransportClient nativeClient = new MinimalTransportClient(esSettings.build(), this.hostAndPorts);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connected to Elasticsearch node: [{}]", (Object)EsConnectorImpl.displayedAddresses(nativeClient));
        }
        return nativeClient;
    }

    private static String displayedAddresses(TransportClient nativeClient) {
        return nativeClient.transportAddresses().stream().map(TransportAddress::toString).collect(Collectors.joining(", "));
    }

    private static class MinimalTransportClient
    extends TransportClient {
        public MinimalTransportClient(Settings settings, Set<HostAndPort> hostAndPorts) {
            super(settings, Collections.unmodifiableList(Collections.singletonList(Netty4Plugin.class)));
            boolean connectedToOneHost = false;
            for (HostAndPort hostAndPort : hostAndPorts) {
                try {
                    this.addTransportAddress(new TransportAddress(InetAddress.getByName(hostAndPort.getHostText()), hostAndPort.getPortOrDefault(9001)));
                    connectedToOneHost = true;
                }
                catch (UnknownHostException e) {
                    LOG.debug("Can not resolve host [" + hostAndPort.getHostText() + "]", (Throwable)e);
                }
            }
            if (!connectedToOneHost) {
                throw new IllegalStateException(String.format("Can not connect to one node from [%s]", hostAndPorts.stream().map(h -> String.format("%s:%d", h.getHostText(), h.getPortOrDefault(9001))).collect(Collectors.joining(","))));
            }
        }

        public void close() {
            super.close();
            if (!NetworkModule.TRANSPORT_TYPE_SETTING.exists(this.settings) || ((String)NetworkModule.TRANSPORT_TYPE_SETTING.get(this.settings)).equals("netty4")) {
                try {
                    GlobalEventExecutor.INSTANCE.awaitInactivity(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                try {
                    ThreadDeathWatcher.awaitInactivity((long)5L, (TimeUnit)TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

