/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.sonar.db.DbSessionImpl;

public class BatchSession
extends DbSessionImpl {
    public static final int MAX_BATCH_SIZE = 250;
    private final int batchSize;
    private int count = 0;

    public BatchSession(SqlSession session) {
        this(session, 250);
    }

    BatchSession(SqlSession session, int batchSize) {
        super(session);
        this.batchSize = batchSize;
    }

    @Override
    public void select(String statement, Object parameter, ResultHandler handler) {
        this.reset();
        super.select(statement, parameter, handler);
    }

    @Override
    public void select(String statement, ResultHandler handler) {
        this.reset();
        super.select(statement, handler);
    }

    @Override
    public <T> T selectOne(String statement) {
        this.reset();
        return super.selectOne(statement);
    }

    @Override
    public <T> T selectOne(String statement, Object parameter) {
        this.reset();
        return super.selectOne(statement, parameter);
    }

    @Override
    public <E> List<E> selectList(String statement) {
        this.reset();
        return super.selectList(statement);
    }

    @Override
    public <E> List<E> selectList(String statement, Object parameter) {
        this.reset();
        return super.selectList(statement, parameter);
    }

    @Override
    public <E> List<E> selectList(String statement, Object parameter, RowBounds rowBounds) {
        this.reset();
        return super.selectList(statement, parameter, rowBounds);
    }

    @Override
    public <K, V> Map<K, V> selectMap(String statement, String mapKey) {
        this.reset();
        return super.selectMap(statement, mapKey);
    }

    @Override
    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey) {
        this.reset();
        return super.selectMap(statement, parameter, mapKey);
    }

    @Override
    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey, RowBounds rowBounds) {
        this.reset();
        return super.selectMap(statement, parameter, mapKey, rowBounds);
    }

    @Override
    public void select(String statement, Object parameter, RowBounds rowBounds, ResultHandler handler) {
        this.reset();
        super.select(statement, parameter, rowBounds, handler);
    }

    @Override
    public int insert(String statement) {
        this.makeSureGeneratedKeysAreNotUsedInBatchInserts(statement);
        this.increment();
        return super.insert(statement);
    }

    @Override
    public int insert(String statement, Object parameter) {
        this.makeSureGeneratedKeysAreNotUsedInBatchInserts(statement);
        this.increment();
        return super.insert(statement, parameter);
    }

    private void makeSureGeneratedKeysAreNotUsedInBatchInserts(String statement) {
        KeyGenerator keyGenerator;
        MappedStatement mappedStatement;
        Configuration configuration = super.getConfiguration();
        if (null != configuration && null != (mappedStatement = configuration.getMappedStatement(statement)) && (keyGenerator = mappedStatement.getKeyGenerator()) instanceof Jdbc3KeyGenerator) {
            throw new IllegalStateException("Batch inserts cannot use generated keys");
        }
    }

    @Override
    public int update(String statement) {
        this.increment();
        return super.update(statement);
    }

    @Override
    public int update(String statement, Object parameter) {
        this.increment();
        return super.update(statement, parameter);
    }

    @Override
    public int delete(String statement) {
        this.increment();
        return super.delete(statement);
    }

    @Override
    public int delete(String statement, Object parameter) {
        this.increment();
        return super.delete(statement, parameter);
    }

    @Override
    public void commit() {
        super.commit();
        this.reset();
    }

    @Override
    public void commit(boolean force) {
        super.commit(force);
        this.reset();
    }

    @Override
    public void rollback() {
        super.rollback();
        this.reset();
    }

    @Override
    public void rollback(boolean force) {
        super.rollback(force);
        this.reset();
    }

    @Override
    public List<BatchResult> flushStatements() {
        List<BatchResult> batchResults = super.flushStatements();
        this.reset();
        return batchResults;
    }

    @Override
    public <T> T getMapper(Class<T> type) {
        return (T)this.getConfiguration().getMapper(type, (SqlSession)this);
    }

    private BatchSession increment() {
        ++this.count;
        if (this.count >= this.batchSize) {
            this.commit();
        }
        return this;
    }

    private void reset() {
        this.count = 0;
    }
}

