/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.defaults.DefaultSqlSession;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.DBSessions;
import org.sonar.db.DbSession;
import org.sonar.db.MyBatis;
import org.sonar.db.NonClosingDbSession;

public class DBSessionsImpl
implements DBSessions {
    private static final Logger LOG = Loggers.get(DBSessionsImpl.class);
    private static final ThreadLocal<Boolean> CACHING_ENABLED = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private final ThreadLocal<DelegatingDbSessionSupplier> regularDbSession = ThreadLocal.withInitial(this::buildRegularDbSessionSupplier);
    private final ThreadLocal<DelegatingDbSessionSupplier> batchDbSession = ThreadLocal.withInitial(this::buildBatchDbSessionSupplier);
    private final MyBatis myBatis;

    public DBSessionsImpl(MyBatis myBatis) {
        this.myBatis = myBatis;
    }

    private DelegatingDbSessionSupplier buildRegularDbSessionSupplier() {
        return new DelegatingDbSessionSupplier(() -> {
            DbSession res = this.myBatis.openSession(false);
            DBSessionsImpl.ensureAutoCommitFalse(res);
            return res;
        });
    }

    private DelegatingDbSessionSupplier buildBatchDbSessionSupplier() {
        return new DelegatingDbSessionSupplier(() -> {
            DbSession res = this.myBatis.openSession(true);
            DBSessionsImpl.ensureAutoCommitFalse(res);
            return res;
        });
    }

    private static void ensureAutoCommitFalse(DbSession dbSession) {
        try {
            SqlSession sqlSession = dbSession.getSqlSession();
            if (sqlSession instanceof DefaultSqlSession) {
                Field f = sqlSession.getClass().getDeclaredField("autoCommit");
                f.setAccessible(true);
                Preconditions.checkState(((Boolean)f.get(sqlSession) == false ? 1 : 0) != 0, (Object)"Autocommit must be false");
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOG.debug("Failed to check the autocommit status of SqlSession: {}", (Object)e);
        }
    }

    @Override
    public void enableCaching() {
        CACHING_ENABLED.set(Boolean.TRUE);
    }

    @Override
    public DbSession openSession(boolean batch) {
        if (!CACHING_ENABLED.get().booleanValue()) {
            return this.myBatis.openSession(batch);
        }
        if (batch) {
            return new NonClosingDbSession(this.batchDbSession.get().get());
        }
        return new NonClosingDbSession(this.regularDbSession.get().get());
    }

    @Override
    public void disableCaching() {
        this.close(this.regularDbSession, "regular");
        this.close(this.batchDbSession, "batch");
        this.regularDbSession.remove();
        this.batchDbSession.remove();
        CACHING_ENABLED.remove();
    }

    public void close(ThreadLocal<DelegatingDbSessionSupplier> dbSessionThreadLocal, String label) {
        DelegatingDbSessionSupplier delegatingDbSessionSupplier = dbSessionThreadLocal.get();
        boolean getCalled = delegatingDbSessionSupplier.isPopulated();
        if (getCalled) {
            try {
                DbSession res = delegatingDbSessionSupplier.get();
                res.close();
            }
            catch (Exception e) {
                LOG.error(String.format("Failed to close %s connection in %s", label, Thread.currentThread()), (Throwable)e);
            }
        }
    }

    private static final class DelegatingDbSessionSupplier
    implements Supplier<DbSession> {
        private final Supplier<DbSession> delegate;
        private DbSession dbSession;

        DelegatingDbSessionSupplier(Supplier<DbSession> delegate) {
            this.delegate = delegate;
        }

        @Override
        public DbSession get() {
            if (this.dbSession == null) {
                this.dbSession = Objects.requireNonNull(this.delegate.get());
            }
            return this.dbSession;
        }

        boolean isPopulated() {
            return this.dbSession != null;
        }
    }
}

