/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.ce;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.db.component.ComponentDto;

public class CeQueueDto {
    private String uuid;
    private String taskType;
    private String componentUuid;
    private String mainComponentUuid;
    private Status status;
    private String submitterUuid;
    private String workerUuid;
    private Long startedAt;
    private long createdAt;
    private long updatedAt;

    public String getUuid() {
        return this.uuid;
    }

    public CeQueueDto setUuid(String s) {
        CeQueueDto.checkUuid(s, "UUID");
        this.uuid = s;
        return this;
    }

    public CeQueueDto setComponent(@Nullable ComponentDto component) {
        if (component == null) {
            this.componentUuid = null;
            this.mainComponentUuid = null;
        } else {
            this.componentUuid = Objects.requireNonNull(component.uuid());
            this.mainComponentUuid = (String)MoreObjects.firstNonNull((Object)component.getMainBranchProjectUuid(), (Object)component.uuid());
        }
        return this;
    }

    @CheckForNull
    public String getComponentUuid() {
        return this.componentUuid;
    }

    public CeQueueDto setComponentUuid(@Nullable String s) {
        CeQueueDto.checkUuid(s, "COMPONENT_UUID");
        this.componentUuid = s;
        return this;
    }

    @CheckForNull
    public String getMainComponentUuid() {
        return this.mainComponentUuid;
    }

    public CeQueueDto setMainComponentUuid(@Nullable String s) {
        CeQueueDto.checkUuid(s, "MAIN_COMPONENT_UUID");
        this.mainComponentUuid = s;
        return this;
    }

    private static void checkUuid(@Nullable String s, String columnName) {
        Preconditions.checkArgument((s == null || s.length() <= 40 ? 1 : 0) != 0, (String)"Value is too long for column CE_QUEUE.%s: %s", (Object[])new Object[]{columnName, s});
    }

    public Status getStatus() {
        return this.status;
    }

    public CeQueueDto setStatus(Status s) {
        this.status = s;
        return this;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public CeQueueDto setTaskType(String s) {
        Preconditions.checkArgument((s.length() <= 15 ? 1 : 0) != 0, (String)"Value of task type is too long: %s", (Object[])new Object[]{s});
        this.taskType = s;
        return this;
    }

    @CheckForNull
    public String getSubmitterUuid() {
        return this.submitterUuid;
    }

    public CeQueueDto setSubmitterUuid(@Nullable String s) {
        Preconditions.checkArgument((s == null || s.length() <= 255 ? 1 : 0) != 0, (String)"Value of submitter uuid is too long: %s", (Object[])new Object[]{s});
        this.submitterUuid = s;
        return this;
    }

    public String getWorkerUuid() {
        return this.workerUuid;
    }

    public CeQueueDto setWorkerUuid(@Nullable String workerUuid) {
        this.workerUuid = workerUuid;
        return this;
    }

    @CheckForNull
    public Long getStartedAt() {
        return this.startedAt;
    }

    public CeQueueDto setStartedAt(@Nullable Long l) {
        this.startedAt = l;
        return this;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public CeQueueDto setCreatedAt(long l) {
        this.createdAt = l;
        return this;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public CeQueueDto setUpdatedAt(long l) {
        this.updatedAt = l;
        return this;
    }

    public String toString() {
        return "CeQueueDto{uuid='" + this.uuid + '\'' + ", taskType='" + this.taskType + '\'' + ", componentUuid='" + this.componentUuid + '\'' + ", mainComponentUuid='" + this.mainComponentUuid + '\'' + ", status=" + (Object)((Object)this.status) + ", submitterLogin='" + this.submitterUuid + '\'' + ", workerUuid='" + this.workerUuid + '\'' + ", startedAt=" + this.startedAt + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + '}';
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CeQueueDto that = (CeQueueDto)o;
        return this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public static enum Status {
        PENDING,
        IN_PROGRESS;

    }
}

