/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.component;

import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.api.utils.System2;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.component.ProjectLinkDto;
import org.sonar.db.component.ProjectLinkMapper;

public class ProjectLinkDao
implements Dao {
    private final System2 system2;

    public ProjectLinkDao(System2 system2) {
        this.system2 = system2;
    }

    public List<ProjectLinkDto> selectByProjectUuid(DbSession session, String projectUuid) {
        return ((ProjectLinkMapper)session.getMapper(ProjectLinkMapper.class)).selectByProjectUuid(projectUuid);
    }

    public List<ProjectLinkDto> selectByProjectUuids(DbSession dbSession, List<String> projectUuids) {
        return DatabaseUtils.executeLargeInputs(projectUuids, ProjectLinkDao.mapper(dbSession)::selectByProjectUuids);
    }

    @CheckForNull
    public ProjectLinkDto selectByUuid(DbSession session, String uuid) {
        return ((ProjectLinkMapper)session.getMapper(ProjectLinkMapper.class)).selectByUuid(uuid);
    }

    public ProjectLinkDto insert(DbSession session, ProjectLinkDto dto) {
        long now = this.system2.now();
        ((ProjectLinkMapper)session.getMapper(ProjectLinkMapper.class)).insert(dto.setCreatedAt(now).setUpdatedAt(now));
        return dto;
    }

    public void update(DbSession session, ProjectLinkDto dto) {
        ((ProjectLinkMapper)session.getMapper(ProjectLinkMapper.class)).update(dto.setUpdatedAt(this.system2.now()));
    }

    public void delete(DbSession session, String uuid) {
        ((ProjectLinkMapper)session.getMapper(ProjectLinkMapper.class)).delete(uuid);
    }

    private static ProjectLinkMapper mapper(DbSession dbSession) {
        return (ProjectLinkMapper)dbSession.getMapper(ProjectLinkMapper.class);
    }
}

