/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.measure;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class LiveMeasureDto {
    private static final int MAX_TEXT_VALUE_LENGTH = 4000;
    @Nullable
    private String uuidForUpsert;
    private String componentUuid;
    private String projectUuid;
    private int metricId;
    @Nullable
    private Double value;
    @Nullable
    private String textValue;
    @Nullable
    private byte[] data;
    @Nullable
    private Double variation;

    void setUuidForUpsert(@Nullable String s) {
        this.uuidForUpsert = s;
    }

    public String getComponentUuid() {
        return this.componentUuid;
    }

    public LiveMeasureDto setComponentUuid(String s) {
        this.componentUuid = s;
        return this;
    }

    public String getProjectUuid() {
        return this.projectUuid;
    }

    public LiveMeasureDto setProjectUuid(String s) {
        this.projectUuid = s;
        return this;
    }

    public int getMetricId() {
        return this.metricId;
    }

    public LiveMeasureDto setMetricId(int i) {
        this.metricId = i;
        return this;
    }

    @CheckForNull
    public Double getValue() {
        return this.value;
    }

    public LiveMeasureDto setValue(@Nullable Double value) {
        this.value = value;
        return this;
    }

    @CheckForNull
    public String getTextValue() {
        return this.textValue;
    }

    @CheckForNull
    public byte[] getData() {
        return this.data;
    }

    @CheckForNull
    public String getDataAsString() {
        if (this.data != null) {
            return new String(this.data, StandardCharsets.UTF_8);
        }
        return this.textValue;
    }

    public LiveMeasureDto setData(@Nullable String data) {
        if (data == null) {
            this.textValue = null;
            this.data = null;
        } else if (data.length() > 4000) {
            this.textValue = null;
            this.data = data.getBytes(StandardCharsets.UTF_8);
        } else {
            this.textValue = data;
            this.data = null;
        }
        return this;
    }

    public LiveMeasureDto setData(@Nullable byte[] data) {
        this.textValue = null;
        this.data = data;
        return this;
    }

    @CheckForNull
    public Double getVariation() {
        return this.variation;
    }

    public LiveMeasureDto setVariation(@Nullable Double variation) {
        this.variation = variation;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LiveMeasureDto{");
        sb.append("componentUuid='").append(this.componentUuid).append('\'');
        sb.append(", projectUuid='").append(this.projectUuid).append('\'');
        sb.append(", metricId=").append(this.metricId);
        sb.append(", value=").append(this.value);
        sb.append(", variation=").append(this.variation);
        sb.append(", textValue='").append(this.textValue).append('\'');
        sb.append(", data=").append(Arrays.toString(this.data));
        sb.append('}');
        return sb.toString();
    }
}

