/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.measure;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.measure.MeasureDto;
import org.sonar.db.measure.MeasureMapper;
import org.sonar.db.measure.MeasureQuery;
import org.sonar.db.measure.PastMeasureDto;
import org.sonar.db.measure.PastMeasureQuery;

public class MeasureDao
implements Dao {
    public Optional<MeasureDto> selectLastMeasure(DbSession dbSession, String componentUuid, String metricKey) {
        return Optional.ofNullable(MeasureDao.mapper(dbSession).selectLastMeasure(componentUuid, metricKey));
    }

    public Optional<MeasureDto> selectMeasure(DbSession dbSession, String analysisUuid, String componentUuid, String metricKey) {
        return Optional.ofNullable(MeasureDao.mapper(dbSession).selectMeasure(analysisUuid, componentUuid, metricKey));
    }

    public List<MeasureDto> selectByQuery(DbSession dbSession, MeasureQuery query) {
        if (query.returnsEmpty()) {
            return Collections.emptyList();
        }
        if (query.isOnComponents()) {
            return DatabaseUtils.executeLargeInputs(query.getComponentUuids(), componentUuids -> {
                MeasureQuery pageQuery = MeasureQuery.copyWithSubsetOfComponentUuids(query, componentUuids);
                return MeasureDao.mapper(dbSession).selectByQueryOnComponents(pageQuery);
            });
        }
        if (query.isOnProjects()) {
            return DatabaseUtils.executeLargeInputs(query.getProjectUuids(), projectUuids -> {
                MeasureQuery pageQuery = MeasureQuery.copyWithSubsetOfProjectUuids(query, projectUuids);
                return MeasureDao.mapper(dbSession).selectByQueryOnProjects(pageQuery);
            });
        }
        return MeasureDao.mapper(dbSession).selectByQueryOnSingleComponent(query);
    }

    public List<PastMeasureDto> selectPastMeasures(DbSession dbSession, String componentUuid, String analysisUuid, Collection<Integer> metricIds) {
        if (metricIds.isEmpty()) {
            return Collections.emptyList();
        }
        return DatabaseUtils.executeLargeInputs(metricIds, ids -> MeasureDao.mapper(dbSession).selectPastMeasuresOnSingleAnalysis(componentUuid, analysisUuid, (List<Integer>)ids));
    }

    public List<MeasureDto> selectPastMeasures(DbSession dbSession, PastMeasureQuery query) {
        return MeasureDao.mapper(dbSession).selectPastMeasuresOnSeveralAnalyses(query);
    }

    public void insert(DbSession session, MeasureDto measureDto) {
        MeasureDao.mapper(session).insert(measureDto);
    }

    public void insert(DbSession session, Collection<MeasureDto> items) {
        for (MeasureDto item : items) {
            this.insert(session, item);
        }
    }

    public void insert(DbSession session, MeasureDto item, MeasureDto ... others) {
        this.insert(session, Lists.asList((Object)item, (Object[])others));
    }

    private static MeasureMapper mapper(DbSession session) {
        return (MeasureMapper)session.getMapper(MeasureMapper.class);
    }
}

