/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.notification;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.api.notifications.Notification;
import org.sonar.api.utils.SonarException;

public class NotificationQueueDto {
    private Long id;
    private byte[] data;

    public Long getId() {
        return this.id;
    }

    public NotificationQueueDto setId(Long id) {
        this.id = id;
        return this;
    }

    public byte[] getData() {
        return this.data;
    }

    public NotificationQueueDto setData(byte[] data) {
        this.data = data;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static <T extends Notification> NotificationQueueDto toNotificationQueueDto(T notification) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(notification);
            objectOutputStream.close();
            NotificationQueueDto notificationQueueDto = new NotificationQueueDto().setData(byteArrayOutputStream.toByteArray());
            return notificationQueueDto;
        }
        catch (IOException e) {
            throw new SonarException("Unable to write notification", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)byteArrayOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Notification> T toNotification() throws IOException, ClassNotFoundException {
        Notification notification;
        if (this.data == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(this.data);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object result = objectInputStream.readObject();
            objectInputStream.close();
            notification = (Notification)result;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(byteArrayInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)byteArrayInputStream);
        return (T)notification;
    }
}

