/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.property;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

public class InternalComponentPropertyDto {
    private static final int MAX_KEY_LENGTH = 512;
    private static final int MAX_VALUE_LENGTH = 4000;
    private String uuid;
    private String key;
    private String value;
    private String componentUuid;
    private Long createdAt;
    private Long updatedAt;

    public String getUuid() {
        return this.uuid;
    }

    public InternalComponentPropertyDto setUuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public InternalComponentPropertyDto setKey(String key) {
        Preconditions.checkArgument((key != null && !key.isEmpty() ? 1 : 0) != 0, (Object)"key can't be null nor empty");
        Preconditions.checkArgument((key.length() <= 512 ? 1 : 0) != 0, (String)"key length (%s) is longer than the maximum authorized (%s). '%s' was provided", (Object[])new Object[]{key.length(), 512, key});
        this.key = key;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public InternalComponentPropertyDto setValue(@Nullable String value) {
        if (value != null) {
            Preconditions.checkArgument((value.length() <= 4000 ? 1 : 0) != 0, (String)"value length (%s) is longer than the maximum authorized (%s). '%s' was provided", (Object[])new Object[]{value.length(), 4000, value});
        }
        this.value = value;
        return this;
    }

    public String getComponentUuid() {
        return this.componentUuid;
    }

    public InternalComponentPropertyDto setComponentUuid(String componentUuid) {
        this.componentUuid = componentUuid;
        return this;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public InternalComponentPropertyDto setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    public InternalComponentPropertyDto setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"InternalComponentPropertyDto").add("uuid", (Object)this.uuid).add("key", (Object)this.key).add("value", (Object)this.value).add("componentUuid", (Object)this.componentUuid).add("updatedAt", (Object)this.updatedAt).add("createdAt", (Object)this.createdAt).toString();
    }
}

