/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.purge;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.api.utils.TimeUtils;
import org.sonar.api.utils.log.Logger;

public class PurgeProfiler {
    private Map<String, Long> durations = new HashMap<String, Long>();
    private long startTime;
    private String currentTable;
    private final Clock clock;

    public PurgeProfiler() {
        this(new Clock());
    }

    @VisibleForTesting
    PurgeProfiler(Clock clock) {
        this.clock = clock;
    }

    public void reset() {
        this.durations.clear();
    }

    void start(String table) {
        this.startTime = this.clock.now();
        this.currentTable = table;
    }

    void stop() {
        Long cumulatedDuration = this.durations.containsKey(this.currentTable) ? this.durations.get(this.currentTable) : Long.valueOf(0L);
        this.durations.put(this.currentTable, cumulatedDuration + (this.clock.now() - this.startTime));
    }

    public void dump(long totalTime, Logger logger) {
        ArrayList<Map.Entry<String, Long>> data = new ArrayList<Map.Entry<String, Long>>(this.durations.entrySet());
        Collections.sort(data, (o1, o2) -> ((Long)o2.getValue()).compareTo((Long)o1.getValue()));
        double percent = (double)totalTime / 100.0;
        for (Map.Entry<String, Long> entry : PurgeProfiler.truncateList(data)) {
            StringBuilder sb = new StringBuilder();
            sb.append("   o ").append(entry.getKey()).append(": ").append(TimeUtils.formatDuration((long)entry.getValue())).append(" (").append((int)((double)entry.getValue().longValue() / percent)).append("%)");
            logger.info(sb.toString());
        }
    }

    private static List<Map.Entry<String, Long>> truncateList(List<Map.Entry<String, Long>> sortedFullList) {
        int maxSize = 10;
        ArrayList<Map.Entry<String, Long>> result = new ArrayList<Map.Entry<String, Long>>(maxSize);
        int i = 0;
        for (Map.Entry<String, Long> item : sortedFullList) {
            if (i++ >= maxSize || item.getValue() == 0L) {
                return result;
            }
            result.add(item);
        }
        return result;
    }

    static class Clock {
        Clock() {
        }

        public long now() {
            return System.currentTimeMillis();
        }
    }
}

