/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.purge.period;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.sonar.api.config.Configuration;
import org.sonar.db.purge.period.DeleteAllFilter;
import org.sonar.db.purge.period.Filter;
import org.sonar.db.purge.period.KeepOneFilter;
import org.sonar.db.purge.period.KeepWithVersionFilter;

class Filters {
    private final List<Filter> all = Lists.newArrayList();

    Filters(Configuration config) {
        Date dateToStartKeepingOneSnapshotByDay = Filters.getDateFromHours(config, "sonar.dbcleaner.hoursBeforeKeepingOnlyOneSnapshotByDay");
        Date dateToStartKeepingOneSnapshotByWeek = Filters.getDateFromWeeks(config, "sonar.dbcleaner.weeksBeforeKeepingOnlyOneSnapshotByWeek");
        Date dateToStartKeepingOneSnapshotByMonth = Filters.getDateFromWeeks(config, "sonar.dbcleaner.weeksBeforeKeepingOnlyOneSnapshotByMonth");
        Date dateToStartKeepingOnlyAnalysisWithVersion = Filters.getDateFromWeeks(config, "sonar.dbcleaner.weeksBeforeKeepingOnlyAnalysesWithVersion");
        Date dateToStartDeletingAllSnapshots = Filters.getDateFromWeeks(config, "sonar.dbcleaner.weeksBeforeDeletingAllSnapshots");
        this.all.add(new KeepOneFilter(dateToStartKeepingOneSnapshotByWeek, dateToStartKeepingOneSnapshotByDay, 6, "day"));
        this.all.add(new KeepOneFilter(dateToStartKeepingOneSnapshotByMonth, dateToStartKeepingOneSnapshotByWeek, 3, "week"));
        this.all.add(new KeepOneFilter(dateToStartDeletingAllSnapshots, dateToStartKeepingOneSnapshotByMonth, 2, "month"));
        this.all.add(new KeepWithVersionFilter(dateToStartKeepingOnlyAnalysisWithVersion));
        this.all.add(new DeleteAllFilter(dateToStartDeletingAllSnapshots));
    }

    static Date getDateFromWeeks(Configuration config, String propertyKey) {
        int weeks = (Integer)config.getInt(propertyKey).get();
        return DateUtils.addWeeks((Date)new Date(), (int)(-weeks));
    }

    static Date getDateFromHours(Configuration config, String propertyKey) {
        int hours = (Integer)config.getInt(propertyKey).get();
        return DateUtils.addHours((Date)new Date(), (int)(-hours));
    }

    List<Filter> all() {
        return this.all;
    }
}

