/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.purge.period;

import com.google.common.base.Strings;
import java.util.Date;
import java.util.List;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.purge.PurgeableAnalysisDto;
import org.sonar.db.purge.period.Filter;

class KeepWithVersionFilter
implements Filter {
    private final Date before;

    KeepWithVersionFilter(Date before) {
        this.before = before;
    }

    @Override
    public List<PurgeableAnalysisDto> filter(List<PurgeableAnalysisDto> history) {
        return (List)history.stream().filter((? super T analysis) -> analysis.getDate().before(this.before)).filter(KeepWithVersionFilter::isDeletable).collect(MoreCollectors.toList());
    }

    @Override
    public void log() {
        Loggers.get(this.getClass()).debug("-> Keep analyses with a version prior to {}", (Object)DateUtils.formatDate((Date)this.before));
    }

    private static boolean isDeletable(PurgeableAnalysisDto snapshot) {
        return !snapshot.isLast() && Strings.isNullOrEmpty((String)snapshot.getVersion());
    }
}

