/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.qualityprofile;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.utils.System2;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.KeyLongValue;
import org.sonar.db.RowNotFoundException;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.OrgQProfileDto;
import org.sonar.db.qualityprofile.ProjectQprofileAssociationDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.db.qualityprofile.QualityProfileMapper;
import org.sonar.db.qualityprofile.RulesProfileDto;

public class QualityProfileDao
implements Dao {
    private final System2 system;

    public QualityProfileDao(System2 system) {
        this.system = system;
    }

    @CheckForNull
    public QProfileDto selectByUuid(DbSession dbSession, String uuid) {
        return QualityProfileDao.mapper(dbSession).selectByUuid(uuid);
    }

    public QProfileDto selectOrFailByUuid(DbSession dbSession, String uuid) {
        QProfileDto dto = this.selectByUuid(dbSession, uuid);
        if (dto == null) {
            throw new RowNotFoundException("Quality profile not found: " + uuid);
        }
        return dto;
    }

    public List<QProfileDto> selectByUuids(DbSession dbSession, List<String> uuids) {
        return DatabaseUtils.executeLargeInputs(uuids, QualityProfileDao.mapper(dbSession)::selectByUuids);
    }

    public List<QProfileDto> selectOrderedByOrganizationUuid(DbSession dbSession, OrganizationDto organization) {
        return QualityProfileDao.mapper(dbSession).selectOrderedByOrganizationUuid(organization.getUuid());
    }

    public List<RulesProfileDto> selectBuiltInRuleProfiles(DbSession dbSession) {
        return QualityProfileDao.mapper(dbSession).selectBuiltInRuleProfiles();
    }

    public List<RulesProfileDto> selectBuiltInRuleProfilesWithActiveRules(DbSession dbSession) {
        return QualityProfileDao.mapper(dbSession).selectBuiltInRuleProfilesWithActiveRules();
    }

    @CheckForNull
    public RulesProfileDto selectRuleProfile(DbSession dbSession, String ruleProfileUuid) {
        return QualityProfileDao.mapper(dbSession).selectRuleProfile(ruleProfileUuid);
    }

    public void insert(DbSession dbSession, RulesProfileDto dto) {
        QualityProfileMapper mapper = QualityProfileDao.mapper(dbSession);
        mapper.insertRuleProfile(dto, new Date(this.system.now()));
    }

    public void insert(DbSession dbSession, OrgQProfileDto dto) {
        QualityProfileMapper mapper = QualityProfileDao.mapper(dbSession);
        mapper.insertOrgQProfile(dto, this.system.now());
    }

    public void insert(DbSession dbSession, QProfileDto profile, QProfileDto ... otherProfiles) {
        QualityProfileMapper mapper = QualityProfileDao.mapper(dbSession);
        this.doInsert(mapper, profile);
        for (QProfileDto other : otherProfiles) {
            this.doInsert(mapper, other);
        }
    }

    private void doInsert(QualityProfileMapper mapper, QProfileDto profile) {
        Preconditions.checkArgument((profile.getId() == null ? 1 : 0) != 0, (String)"Quality profile is already persisted (got id %d)", (Object[])new Object[]{profile.getId()});
        long now = this.system.now();
        RulesProfileDto rulesProfile = RulesProfileDto.from(profile);
        mapper.insertRuleProfile(rulesProfile, new Date(now));
        mapper.insertOrgQProfile(OrgQProfileDto.from(profile), now);
        profile.setId(rulesProfile.getId());
    }

    public void update(DbSession dbSession, QProfileDto profile, QProfileDto ... otherProfiles) {
        QualityProfileMapper mapper = QualityProfileDao.mapper(dbSession);
        long now = this.system.now();
        QualityProfileDao.doUpdate(mapper, profile, now);
        for (QProfileDto otherProfile : otherProfiles) {
            QualityProfileDao.doUpdate(mapper, otherProfile, now);
        }
    }

    public int updateLastUsedDate(DbSession dbSession, QProfileDto profile, long lastUsedDate) {
        return QualityProfileDao.mapper(dbSession).updateLastUsedDate(profile.getKee(), lastUsedDate, this.system.now());
    }

    public void update(DbSession dbSession, RulesProfileDto rulesProfile) {
        QualityProfileMapper mapper = QualityProfileDao.mapper(dbSession);
        long now = this.system.now();
        mapper.updateRuleProfile(rulesProfile, new Date(now));
    }

    public void update(DbSession dbSession, OrgQProfileDto profile) {
        QualityProfileMapper mapper = QualityProfileDao.mapper(dbSession);
        long now = this.system.now();
        mapper.updateOrgQProfile(profile, now);
    }

    private static void doUpdate(QualityProfileMapper mapper, QProfileDto profile, long now) {
        mapper.updateRuleProfile(RulesProfileDto.from(profile), new Date(now));
        mapper.updateOrgQProfile(OrgQProfileDto.from(profile), now);
    }

    public List<QProfileDto> selectDefaultProfiles(DbSession dbSession, OrganizationDto organization, Collection<String> languages) {
        return DatabaseUtils.executeLargeInputs(languages, partition -> QualityProfileDao.mapper(dbSession).selectDefaultProfiles(organization.getUuid(), (Collection<String>)partition));
    }

    public List<QProfileDto> selectDefaultBuiltInProfilesWithoutActiveRules(DbSession dbSession, Set<String> languages) {
        return DatabaseUtils.executeLargeInputs(languages, partition -> QualityProfileDao.mapper(dbSession).selectDefaultBuiltInProfilesWithoutActiveRules((List<String>)partition));
    }

    @CheckForNull
    public QProfileDto selectDefaultProfile(DbSession dbSession, OrganizationDto organization, String language) {
        return QualityProfileDao.mapper(dbSession).selectDefaultProfile(organization.getUuid(), language);
    }

    @CheckForNull
    public QProfileDto selectAssociatedToProjectAndLanguage(DbSession dbSession, ComponentDto project, String language) {
        return QualityProfileDao.mapper(dbSession).selectAssociatedToProjectUuidAndLanguage(project.getOrganizationUuid(), project.projectUuid(), language);
    }

    public List<QProfileDto> selectAssociatedToProjectUuidAndLanguages(DbSession dbSession, ComponentDto project, Collection<String> languages) {
        return DatabaseUtils.executeLargeInputs(languages, partition -> QualityProfileDao.mapper(dbSession).selectAssociatedToProjectUuidAndLanguages(project.getOrganizationUuid(), project.uuid(), (Collection<String>)partition));
    }

    public List<QProfileDto> selectByLanguage(DbSession dbSession, OrganizationDto organization, String language) {
        return QualityProfileDao.mapper(dbSession).selectByLanguage(organization.getUuid(), language);
    }

    public List<QProfileDto> selectChildren(DbSession dbSession, Collection<QProfileDto> profiles) {
        List uuids = (List)profiles.stream().map(QProfileDto::getKee).collect(MoreCollectors.toArrayList((int)profiles.size()));
        return DatabaseUtils.executeLargeInputs((Collection)uuids, chunk -> QualityProfileDao.mapper(dbSession).selectChildren((Collection<String>)chunk));
    }

    public Collection<QProfileDto> selectDescendants(DbSession dbSession, Collection<QProfileDto> profiles) {
        if (profiles.isEmpty()) {
            return Collections.emptyList();
        }
        List<QProfileDto> children = this.selectChildren(dbSession, profiles);
        ArrayList<QProfileDto> descendants = new ArrayList<QProfileDto>(children);
        descendants.addAll(this.selectDescendants(dbSession, children));
        return descendants;
    }

    @CheckForNull
    public QProfileDto selectByNameAndLanguage(DbSession dbSession, OrganizationDto organization, String name, String language) {
        return QualityProfileDao.mapper(dbSession).selectByNameAndLanguage(organization.getUuid(), name, language);
    }

    @CheckForNull
    public QProfileDto selectByRuleProfileUuid(DbSession dbSession, String organizationUuid, String ruleProfileKee) {
        return QualityProfileDao.mapper(dbSession).selectByRuleProfileUuid(organizationUuid, ruleProfileKee);
    }

    public List<QProfileDto> selectByNameAndLanguages(DbSession dbSession, OrganizationDto organization, String name, Collection<String> languages) {
        return QualityProfileDao.mapper(dbSession).selectByNameAndLanguages(organization.getUuid(), name, languages);
    }

    public Map<String, Long> countProjectsByOrganizationAndProfiles(DbSession dbSession, OrganizationDto organization, List<QProfileDto> profiles) {
        List profileUuids = (List)profiles.stream().map(QProfileDto::getKee).collect(MoreCollectors.toList());
        return KeyLongValue.toMap(DatabaseUtils.executeLargeInputs((Collection)profileUuids, partition -> QualityProfileDao.mapper(dbSession).countProjectsByOrganizationAndProfiles(organization.getUuid(), (List<String>)partition)));
    }

    public void insertProjectProfileAssociation(DbSession dbSession, ComponentDto project, QProfileDto profile) {
        QualityProfileDao.mapper(dbSession).insertProjectProfileAssociation(project.uuid(), profile.getKee());
    }

    public void deleteProjectProfileAssociation(DbSession dbSession, ComponentDto project, QProfileDto profile) {
        QualityProfileDao.mapper(dbSession).deleteProjectProfileAssociation(project.uuid(), profile.getKee());
    }

    public void updateProjectProfileAssociation(DbSession dbSession, ComponentDto project, String newProfileUuid, String oldProfileUuid) {
        QualityProfileDao.mapper(dbSession).updateProjectProfileAssociation(project.uuid(), newProfileUuid, oldProfileUuid);
    }

    public void deleteProjectAssociationsByProfileUuids(DbSession dbSession, Collection<String> profileUuids) {
        QualityProfileMapper mapper = QualityProfileDao.mapper(dbSession);
        DatabaseUtils.executeLargeUpdates(profileUuids, mapper::deleteProjectAssociationByProfileUuids);
    }

    public List<ProjectQprofileAssociationDto> selectSelectedProjects(DbSession dbSession, OrganizationDto organization, QProfileDto profile, @Nullable String query) {
        String nameQuery = QualityProfileDao.sqlQueryString(query);
        return QualityProfileDao.mapper(dbSession).selectSelectedProjects(organization.getUuid(), profile.getKee(), nameQuery);
    }

    public List<ProjectQprofileAssociationDto> selectDeselectedProjects(DbSession dbSession, OrganizationDto organization, QProfileDto profile, @Nullable String query) {
        String nameQuery = QualityProfileDao.sqlQueryString(query);
        return QualityProfileDao.mapper(dbSession).selectDeselectedProjects(organization.getUuid(), profile.getKee(), nameQuery);
    }

    public List<ProjectQprofileAssociationDto> selectProjectAssociations(DbSession dbSession, OrganizationDto organization, QProfileDto profile, @Nullable String query) {
        String nameQuery = QualityProfileDao.sqlQueryString(query);
        return QualityProfileDao.mapper(dbSession).selectProjectAssociations(organization.getUuid(), profile.getKee(), nameQuery);
    }

    public Collection<String> selectUuidsOfCustomRulesProfiles(DbSession dbSession, String language, String name) {
        return QualityProfileDao.mapper(dbSession).selectUuidsOfCustomRuleProfiles(language, name);
    }

    public void renameRulesProfilesAndCommit(DbSession dbSession, Collection<String> rulesProfileUuids, String newName) {
        QualityProfileMapper mapper = QualityProfileDao.mapper(dbSession);
        Date now = new Date(this.system.now());
        DatabaseUtils.executeLargeUpdates(rulesProfileUuids, partition -> {
            mapper.renameRuleProfiles(newName, now, (Collection<String>)partition);
            dbSession.commit();
        });
    }

    public void deleteOrgQProfilesByUuids(DbSession dbSession, Collection<String> profileUuids) {
        QualityProfileMapper mapper = QualityProfileDao.mapper(dbSession);
        DatabaseUtils.executeLargeUpdates(profileUuids, mapper::deleteOrgQProfilesByUuids);
    }

    public void deleteRulesProfilesByUuids(DbSession dbSession, Collection<String> rulesProfileUuids) {
        QualityProfileMapper mapper = QualityProfileDao.mapper(dbSession);
        DatabaseUtils.executeLargeUpdates(rulesProfileUuids, mapper::deleteRuleProfilesByUuids);
    }

    public List<QProfileDto> selectQProfilesByRuleProfile(DbSession dbSession, RulesProfileDto rulesProfile) {
        return QualityProfileDao.mapper(dbSession).selectQProfilesByRuleProfileUuid(rulesProfile.getKee());
    }

    private static String sqlQueryString(@Nullable String query) {
        if (query == null) {
            return "%";
        }
        return "%" + query.toUpperCase(Locale.ENGLISH) + "%";
    }

    private static QualityProfileMapper mapper(DbSession dbSession) {
        return (QualityProfileMapper)dbSession.getMapper(QualityProfileMapper.class);
    }
}

