/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.source;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;
import org.apache.commons.io.IOUtils;
import org.sonar.db.protobuf.DbFileSources;
import org.sonar.db.source.LineHashVersion;

public class FileSourceDto {
    private static final String SIZE_LIMIT_EXCEEDED_EXCEPTION_MESSAGE = "Protocol message was too large.  May be malicious.  Use CodedInputStream.setSizeLimit() to increase the size limit.";
    private static final Joiner LINE_RETURN_JOINER = Joiner.on((char)'\n');
    public static final Splitter LINES_HASHES_SPLITTER = Splitter.on((char)'\n');
    public static final int LINE_COUNT_NOT_POPULATED = -1;
    private Long id;
    private String projectUuid;
    private String fileUuid;
    private long createdAt;
    private long updatedAt;
    private String lineHashes;
    private int lineCount = -1;
    private String srcHash;
    private byte[] binaryData = new byte[0];
    private String dataHash;
    private String revision;
    @Nullable
    private Integer lineHashesVersion;

    public int getLineHashesVersion() {
        return this.lineHashesVersion != null ? this.lineHashesVersion.intValue() : LineHashVersion.WITHOUT_SIGNIFICANT_CODE.getDbValue();
    }

    public FileSourceDto setLineHashesVersion(int lineHashesVersion) {
        this.lineHashesVersion = lineHashesVersion;
        return this;
    }

    public Long getId() {
        return this.id;
    }

    public FileSourceDto setId(Long id) {
        this.id = id;
        return this;
    }

    public String getProjectUuid() {
        return this.projectUuid;
    }

    public FileSourceDto setProjectUuid(String projectUuid) {
        this.projectUuid = projectUuid;
        return this;
    }

    public String getFileUuid() {
        return this.fileUuid;
    }

    public FileSourceDto setFileUuid(String fileUuid) {
        this.fileUuid = fileUuid;
        return this;
    }

    @CheckForNull
    public String getDataHash() {
        return this.dataHash;
    }

    public FileSourceDto setDataHash(String s) {
        this.dataHash = s;
        return this;
    }

    public DbFileSources.Data decodeSourceData(byte[] binaryData) {
        try {
            return FileSourceDto.decodeRegularSourceData(binaryData);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Fail to decompress and deserialize source data [id=%s,fileUuid=%s,projectUuid=%s]", this.id, this.fileUuid, this.projectUuid), e);
        }
    }

    private static DbFileSources.Data decodeRegularSourceData(byte[] binaryData) throws IOException {
        DbFileSources.Data data;
        LZ4BlockInputStream lz4Input = new LZ4BlockInputStream((InputStream)new ByteArrayInputStream(binaryData));
        try {
            data = DbFileSources.Data.parseFrom((InputStream)lz4Input);
        }
        catch (Throwable throwable) {
            try {
                try {
                    lz4Input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (InvalidProtocolBufferException e) {
                if (SIZE_LIMIT_EXCEEDED_EXCEPTION_MESSAGE.equals(e.getMessage())) {
                    return FileSourceDto.decodeHugeSourceData(binaryData);
                }
                throw e;
            }
        }
        lz4Input.close();
        return data;
    }

    private static DbFileSources.Data decodeHugeSourceData(byte[] binaryData) throws IOException {
        try (LZ4BlockInputStream lz4Input = new LZ4BlockInputStream((InputStream)new ByteArrayInputStream(binaryData));){
            CodedInputStream input = CodedInputStream.newInstance((InputStream)lz4Input);
            input.setSizeLimit(Integer.MAX_VALUE);
            DbFileSources.Data data = DbFileSources.Data.parseFrom(input);
            return data;
        }
    }

    public static byte[] encodeSourceData(DbFileSources.Data data) {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        LZ4BlockOutputStream compressedOutput = new LZ4BlockOutputStream((OutputStream)byteOutput);
        try {
            data.writeTo((OutputStream)compressedOutput);
            compressedOutput.close();
            byte[] byArray = byteOutput.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to serialize and compress source data", e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)compressedOutput);
        }
    }

    public byte[] getBinaryData() {
        return this.binaryData;
    }

    public FileSourceDto setBinaryData(byte[] data) {
        this.binaryData = data;
        return this;
    }

    public DbFileSources.Data getSourceData() {
        return this.decodeSourceData(this.binaryData);
    }

    public FileSourceDto setSourceData(DbFileSources.Data data) {
        this.binaryData = FileSourceDto.encodeSourceData(data);
        return this;
    }

    public String getRawLineHashes() {
        return this.lineHashes;
    }

    public void setRawLineHashes(@Nullable String lineHashes) {
        this.lineHashes = lineHashes;
    }

    public List<String> getLineHashes() {
        if (this.lineHashes == null) {
            return Collections.emptyList();
        }
        return LINES_HASHES_SPLITTER.splitToList((CharSequence)this.lineHashes);
    }

    public int getLineCount() {
        if (this.lineCount == -1) {
            return this.getLineHashes().size();
        }
        return this.lineCount;
    }

    public FileSourceDto setLineHashes(@Nullable List<String> lineHashes) {
        if (lineHashes == null) {
            this.lineHashes = null;
            this.lineCount = 0;
        } else if (lineHashes.isEmpty()) {
            this.lineHashes = null;
            this.lineCount = 1;
        } else {
            this.lineHashes = LINE_RETURN_JOINER.join(lineHashes);
            this.lineCount = lineHashes.size();
        }
        return this;
    }

    @CheckForNull
    public String getSrcHash() {
        return this.srcHash;
    }

    public FileSourceDto setSrcHash(@Nullable String srcHash) {
        this.srcHash = srcHash;
        return this;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public FileSourceDto setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public FileSourceDto setUpdatedAt(long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    public String getRevision() {
        return this.revision;
    }

    public FileSourceDto setRevision(@Nullable String revision) {
        this.revision = revision;
        return this;
    }
}

