/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.user;

import java.util.List;
import org.sonar.api.utils.System2;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.Dao;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;
import org.sonar.db.user.UserPropertiesMapper;
import org.sonar.db.user.UserPropertyDto;

public class UserPropertiesDao
implements Dao {
    private final System2 system2;
    private final UuidFactory uuidFactory;

    public UserPropertiesDao(System2 system2, UuidFactory uuidFactory) {
        this.system2 = system2;
        this.uuidFactory = uuidFactory;
    }

    public List<UserPropertyDto> selectByUser(DbSession session, UserDto user) {
        return UserPropertiesDao.mapper(session).selectByUserUuid(user.getUuid());
    }

    public UserPropertyDto insertOrUpdate(DbSession session, UserPropertyDto dto) {
        long now = this.system2.now();
        if (UserPropertiesDao.mapper(session).update(dto, now) == 0) {
            UserPropertiesDao.mapper(session).insert(dto.setUuid(this.uuidFactory.create()), now);
        }
        return dto;
    }

    public void deleteByUser(DbSession session, UserDto user) {
        UserPropertiesDao.mapper(session).deleteByUserUuid(user.getUuid());
    }

    private static UserPropertiesMapper mapper(DbSession session) {
        return (UserPropertiesMapper)session.getMapper(UserPropertiesMapper.class);
    }
}

