/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.user;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;
import org.sonar.db.user.UserTokenCount;
import org.sonar.db.user.UserTokenDto;
import org.sonar.db.user.UserTokenMapper;

public class UserTokenDao
implements Dao {
    public void insert(DbSession dbSession, UserTokenDto userTokenDto) {
        UserTokenDao.mapper(dbSession).insert(userTokenDto);
    }

    public void update(DbSession dbSession, UserTokenDto userTokenDto) {
        UserTokenDao.mapper(dbSession).update(userTokenDto);
    }

    @CheckForNull
    public UserTokenDto selectByTokenHash(DbSession dbSession, String tokenHash) {
        return UserTokenDao.mapper(dbSession).selectByTokenHash(tokenHash);
    }

    @CheckForNull
    public UserTokenDto selectByUserAndName(DbSession dbSession, UserDto user, String name) {
        return UserTokenDao.mapper(dbSession).selectByUserUuidAndName(user.getUuid(), name);
    }

    public List<UserTokenDto> selectByUser(DbSession dbSession, UserDto user) {
        return UserTokenDao.mapper(dbSession).selectByUserUuid(user.getUuid());
    }

    public Map<String, Integer> countTokensByUsers(DbSession dbSession, Collection<UserDto> users) {
        HashMap<String, Integer> result = new HashMap<String, Integer>(users.size());
        DatabaseUtils.executeLargeInputs((Collection)((Collection)users.stream().map(UserDto::getUuid).collect(MoreCollectors.toList())), input -> {
            List<UserTokenCount> userTokenCounts = UserTokenDao.mapper(dbSession).countTokensByUserUuids((List<String>)input);
            for (UserTokenCount userTokenCount : userTokenCounts) {
                result.put(userTokenCount.getUserUuid(), userTokenCount.tokenCount());
            }
            return userTokenCounts;
        });
        return result;
    }

    public void deleteByUser(DbSession dbSession, UserDto user) {
        UserTokenDao.mapper(dbSession).deleteByUserUuid(user.getUuid());
    }

    public void deleteByUserAndName(DbSession dbSession, UserDto user, String name) {
        UserTokenDao.mapper(dbSession).deleteByUserUuidAndName(user.getUuid(), name);
    }

    private static UserTokenMapper mapper(DbSession dbSession) {
        return (UserTokenMapper)dbSession.getMapper(UserTokenMapper.class);
    }
}

