/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db;

import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import org.apache.commons.io.output.NullWriter;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.jdbc.ScriptRunner;

public final class DdlUtils {
    private DdlUtils() {
    }

    public static boolean supportsDialect(String dialect) {
        return "h2".equals(dialect);
    }

    public static void createSchema(Connection connection, String dialect, boolean createSchemaMigrations) {
        if (createSchemaMigrations) {
            DdlUtils.executeScript(connection, "org/sonar/db/version/schema_migrations-" + dialect + ".ddl");
        }
        DdlUtils.executeScript(connection, "org/sonar/db/version/schema-" + dialect + ".ddl");
        DdlUtils.executeScript(connection, "org/sonar/db/version/rows-" + dialect + ".sql");
    }

    public static void executeScript(Connection connection, String path) {
        ScriptRunner scriptRunner = DdlUtils.newScriptRunner(connection);
        try {
            scriptRunner.runScript(Resources.getResourceAsReader((String)path));
            connection.commit();
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to restore: " + path, e);
        }
    }

    private static ScriptRunner newScriptRunner(Connection connection) {
        ScriptRunner scriptRunner = new ScriptRunner(connection);
        scriptRunner.setDelimiter(";");
        scriptRunner.setStopOnError(true);
        scriptRunner.setLogWriter(new PrintWriter((Writer)new NullWriter()));
        return scriptRunner;
    }
}

