/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db;

import ch.qos.logback.classic.Level;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Settings;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.Database;
import org.sonar.db.dialect.Dialect;
import org.sonar.db.dialect.DialectUtils;
import org.sonar.db.profiling.ConnectionInterceptor;
import org.sonar.db.profiling.NullConnectionInterceptor;
import org.sonar.db.profiling.ProfiledConnectionInterceptor;
import org.sonar.db.profiling.ProfiledDataSource;
import org.sonar.process.ProcessProperties;
import org.sonar.process.logging.LogbackHelper;

public class DefaultDatabase
implements Database {
    private static final Logger LOG = Loggers.get(Database.class);
    private static final String DEFAULT_URL = "jdbc:h2:tcp://localhost/sonar";
    private static final String SONAR_JDBC = "sonar.jdbc.";
    private static final String SONAR_JDBC_DIALECT = "sonar.jdbc.dialect";
    private static final String SONAR_JDBC_DRIVER = "sonar.jdbc.driverClassName";
    private static final String SONAR_JDBC_MAX_ACTIVE = "sonar.jdbc.maxActive";
    private static final String DBCP_JDBC_MAX_ACTIVE = "maxTotal";
    private static final String SONAR_JDBC_MAX_WAIT = "sonar.jdbc.maxWait";
    private static final String DBCP_JDBC_MAX_WAIT = "maxWaitMillis";
    private static final Map<String, String> SONAR_JDBC_TO_DBCP_PROPERTY_MAPPINGS = ImmutableMap.of((Object)"sonar.jdbc.maxActive", (Object)"maxTotal", (Object)"sonar.jdbc.maxWait", (Object)"maxWaitMillis");
    private final LogbackHelper logbackHelper;
    private final Settings settings;
    private ProfiledDataSource datasource;
    private Dialect dialect;
    private Properties properties;

    public DefaultDatabase(LogbackHelper logbackHelper, Settings settings) {
        this.logbackHelper = logbackHelper;
        this.settings = settings;
    }

    public void start() {
        this.initSettings();
        this.failIfMySql();
        try {
            this.initDataSource();
            this.checkConnection();
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to connect to database", e);
        }
    }

    @VisibleForTesting
    void initSettings() {
        this.properties = new Properties();
        DefaultDatabase.completeProperties(this.settings, this.properties, SONAR_JDBC);
        DefaultDatabase.completeDefaultProperty(this.properties, ProcessProperties.Property.JDBC_URL.getKey(), DEFAULT_URL);
        this.doCompleteProperties(this.properties);
        this.dialect = DialectUtils.find(this.properties.getProperty(SONAR_JDBC_DIALECT), this.properties.getProperty(ProcessProperties.Property.JDBC_URL.getKey()));
        this.properties.setProperty(SONAR_JDBC_DRIVER, this.dialect.getDefaultDriverClassName());
    }

    private void failIfMySql() {
        if (!"mysql".equals(this.dialect.getId())) {
            return;
        }
        throw MessageException.of((String)"\n#############################################################################################################\n#         End of Life of MySQL Support : SonarQube 7.9 and future versions do not support MySQL.            #\n#         Please migrate to a supported database. Get more details at                                       #\n#         https://community.sonarsource.com/t/end-of-life-of-mysql-support                                  #\n#         and https://github.com/SonarSource/mysql-migrator                                                 #\n#############################################################################################################\n");
    }

    private void initDataSource() throws Exception {
        LOG.info("Create JDBC data source for {}", (Object)this.properties.getProperty(ProcessProperties.Property.JDBC_URL.getKey()), (Object)DEFAULT_URL);
        BasicDataSource basicDataSource = BasicDataSourceFactory.createDataSource((Properties)DefaultDatabase.extractCommonsDbcpProperties(this.properties));
        this.datasource = new ProfiledDataSource(basicDataSource, NullConnectionInterceptor.INSTANCE);
        this.datasource.setConnectionInitSqls(this.dialect.getConnectionInitStatements());
        this.datasource.setValidationQuery(this.dialect.getValidationQuery());
        DefaultDatabase.enableSqlLogging(this.datasource, this.logbackHelper.getLoggerLevel("sql") == Level.TRACE);
    }

    private void checkConnection() {
        Connection connection = null;
        try {
            connection = this.datasource.getConnection();
            this.dialect.init(connection.getMetaData());
        }
        catch (SQLException e) {
            throw new IllegalStateException("Can not connect to database. Please check connectivity and settings (see the properties prefixed by 'sonar.jdbc.').", e);
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
    }

    public void stop() {
        if (this.datasource != null) {
            try {
                this.datasource.close();
            }
            catch (SQLException e) {
                throw new IllegalStateException("Fail to stop JDBC connection pool", e);
            }
        }
    }

    @Override
    public final Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public final DataSource getDataSource() {
        return this.datasource;
    }

    public final Properties getProperties() {
        return this.properties;
    }

    @Override
    public void enableSqlLogging(boolean enable) {
        DefaultDatabase.enableSqlLogging(this.datasource, enable);
    }

    private static void enableSqlLogging(ProfiledDataSource ds, boolean enable) {
        ds.setConnectionInterceptor((ConnectionInterceptor)((Object)(enable ? ProfiledConnectionInterceptor.INSTANCE : NullConnectionInterceptor.INSTANCE)));
    }

    protected void doCompleteProperties(Properties properties) {
    }

    private static void completeProperties(Settings settings, Properties properties, String prefix) {
        List jdbcKeys = settings.getKeysStartingWith(prefix);
        for (String jdbcKey : jdbcKeys) {
            String value = settings.getString(jdbcKey);
            properties.setProperty(jdbcKey, value);
        }
    }

    @VisibleForTesting
    static Properties extractCommonsDbcpProperties(Properties properties) {
        Properties result = new Properties();
        result.setProperty("accessToUnderlyingConnectionAllowed", "true");
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!StringUtils.startsWith((String)key, (String)SONAR_JDBC)) continue;
            String resolvedKey = DefaultDatabase.toDbcpPropertyKey(key);
            String existingValue = (String)result.setProperty(resolvedKey, (String)entry.getValue());
            Preconditions.checkState((existingValue == null || existingValue.equals(entry.getValue()) ? 1 : 0) != 0, (String)"Duplicate property declaration for resolved jdbc key '%s': conflicting values are '%s' and '%s'", (Object[])new Object[]{resolvedKey, existingValue, entry.getValue()});
            result.setProperty(DefaultDatabase.toDbcpPropertyKey(key), (String)entry.getValue());
        }
        return result;
    }

    private static void completeDefaultProperty(Properties props, String key, String defaultValue) {
        if (props.getProperty(key) == null) {
            props.setProperty(key, defaultValue);
        }
    }

    private static String toDbcpPropertyKey(String key) {
        if (SONAR_JDBC_TO_DBCP_PROPERTY_MAPPINGS.containsKey(key)) {
            return SONAR_JDBC_TO_DBCP_PROPERTY_MAPPINGS.get(key);
        }
        return StringUtils.removeStart((String)key, (String)SONAR_JDBC);
    }

    public String toString() {
        return String.format("Database[%s]", this.properties != null ? this.properties.getProperty(ProcessProperties.Property.JDBC_URL.getKey()) : "?");
    }
}

