/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db;

import java.io.Closeable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.dbutils.DbUtils;

public abstract class ResultSetIterator<E>
implements Iterator<E>,
Closeable {
    private final ResultSet rs;
    private final PreparedStatement stmt;
    private volatile boolean didNext = false;
    private volatile boolean hasNext = false;
    private volatile boolean closed = false;

    public ResultSetIterator(PreparedStatement stmt) throws SQLException {
        this.stmt = stmt;
        this.rs = stmt.executeQuery();
    }

    protected ResultSetIterator(ResultSet rs) {
        this.stmt = null;
        this.rs = rs;
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            return false;
        }
        if (!this.didNext) {
            this.hasNext = this.doNextQuietly();
            if (this.hasNext) {
                this.didNext = true;
            } else {
                this.close();
            }
        }
        return this.hasNext;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            this.close();
            throw new NoSuchElementException();
        }
        try {
            E e = this.read(this.rs);
            return e;
        }
        catch (SQLException e) {
            throw new IllegalStateException("Fail to read result set row", e);
        }
        finally {
            this.hasNext = this.doNextQuietly();
            if (!this.hasNext) {
                this.close();
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.closed = true;
        DbUtils.closeQuietly((ResultSet)this.rs);
        DbUtils.closeQuietly((Statement)this.stmt);
    }

    protected abstract E read(ResultSet var1) throws SQLException;

    private boolean doNextQuietly() {
        try {
            return this.rs.next();
        }
        catch (SQLException e) {
            throw new IllegalStateException("Fail to read row of JDBC result set", e);
        }
    }
}

