/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.dialect;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.MessageException;
import org.sonar.db.dialect.Dialect;
import org.sonar.db.dialect.H2;
import org.sonar.db.dialect.MsSql;
import org.sonar.db.dialect.MySql;
import org.sonar.db.dialect.Oracle;
import org.sonar.db.dialect.PostgreSql;

public final class DialectUtils {
    private static final Set<Supplier<Dialect>> DIALECTS = ImmutableSet.of(H2::new, MySql::new, Oracle::new, PostgreSql::new, MsSql::new);

    private DialectUtils() {
    }

    public static Dialect find(String dialectId, String jdbcConnectionUrl) {
        Optional<Dialect> match = StringUtils.isNotBlank((String)dialectId) ? DialectUtils.findById(dialectId) : DialectUtils.findByJdbcUrl(jdbcConnectionUrl);
        return match.orElseThrow(() -> MessageException.of((String)("Unable to determine database dialect to use within sonar with dialect " + dialectId + " jdbc url " + jdbcConnectionUrl)));
    }

    private static Optional<Dialect> findByJdbcUrl(String jdbcConnectionUrl) {
        return DialectUtils.findDialect(dialect -> dialect != null && dialect.matchesJdbcUrl(StringUtils.trimToEmpty((String)jdbcConnectionUrl)));
    }

    private static Optional<Dialect> findById(String dialectId) {
        return DialectUtils.findDialect(dialect -> dialect != null && dialect.getId().equals(dialectId));
    }

    private static Optional<Dialect> findDialect(Predicate<Dialect> predicate) {
        return DIALECTS.stream().map(Supplier::get).filter(predicate).findFirst();
    }
}

