/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.profiling;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbcp2.BasicDataSource;
import org.sonar.db.profiling.ConnectionInterceptor;
import org.sonar.db.profiling.ProfilingConnectionHandler;

public enum ProfiledConnectionInterceptor implements ConnectionInterceptor
{
    INSTANCE;


    @Override
    public Connection getConnection(BasicDataSource dataSource) throws SQLException {
        return ProfiledConnectionInterceptor.buildConnectionProxy(new ProfilingConnectionHandler(dataSource.getConnection()));
    }

    @Override
    public Connection getConnection(BasicDataSource dataSource, String login, String password) throws SQLException {
        return ProfiledConnectionInterceptor.buildConnectionProxy(new ProfilingConnectionHandler(dataSource.getConnection(login, password)));
    }

    private static Connection buildConnectionProxy(ProfilingConnectionHandler connectionHandler) {
        ClassLoader classloader = ProfiledConnectionInterceptor.class.getClassLoader();
        return (Connection)Proxy.newProxyInstance(classloader, new Class[]{Connection.class}, (InvocationHandler)connectionHandler);
    }
}

