/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.profiling;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import org.sonar.db.profiling.InvocationUtils;
import org.sonar.db.profiling.ProfilingPreparedStatementHandler;
import org.sonar.db.profiling.ProfilingStatementHandler;

class ProfilingConnectionHandler
implements InvocationHandler {
    private final Connection connection;

    ProfilingConnectionHandler(Connection connection) {
        this.connection = connection;
    }

    @Override
    public Object invoke(Object target, Method method, Object[] args) throws Throwable {
        Object result = InvocationUtils.invokeQuietly(this.connection, method, args);
        if ("prepareStatement".equals(method.getName())) {
            PreparedStatement statement = (PreparedStatement)result;
            String sql = (String)args[0];
            return ProfilingConnectionHandler.buildStatementProxy(PreparedStatement.class, new ProfilingPreparedStatementHandler(statement, sql));
        }
        if ("createStatement".equals(method.getName())) {
            Statement statement = (Statement)result;
            return ProfilingConnectionHandler.buildStatementProxy(Statement.class, new ProfilingStatementHandler(statement));
        }
        return result;
    }

    private static Object buildStatementProxy(Class<? extends Statement> stmtClass, InvocationHandler handler) {
        return Proxy.newProxyInstance(ProfilingConnectionHandler.class.getClassLoader(), new Class[]{stmtClass}, handler);
    }
}

