/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.profiling;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Profiler;
import org.sonar.db.profiling.InvocationUtils;
import org.sonar.db.profiling.ProfiledDataSource;
import org.sonar.db.profiling.SqlLogFormatter;

class ProfilingPreparedStatementHandler
implements InvocationHandler {
    private final PreparedStatement statement;
    private final String sql;
    private final Object[] sqlParams;

    ProfilingPreparedStatementHandler(PreparedStatement statement, String sql) {
        this.statement = statement;
        this.sql = sql;
        this.sqlParams = new Object[SqlLogFormatter.countArguments(sql)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().startsWith("execute")) {
            Profiler profiler = Profiler.create((Logger)ProfiledDataSource.SQL_LOGGER).start();
            Object result = null;
            try {
                result = InvocationUtils.invokeQuietly(this.statement, method, args);
            }
            finally {
                profiler.addContext("sql", (Object)SqlLogFormatter.reformatSql(this.sql));
                if (this.sqlParams.length > 0) {
                    profiler.addContext("params", (Object)SqlLogFormatter.reformatParams(this.sqlParams));
                }
                profiler.stopTrace("");
            }
            return result;
        }
        if (method.getName().startsWith("set") && args.length > 1) {
            this.sqlParams[((Integer)args[0]).intValue() - 1] = args[1];
            return InvocationUtils.invokeQuietly(this.statement, method, args);
        }
        return InvocationUtils.invokeQuietly(this.statement, method, args);
    }
}

