/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.profiling;

import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class SqlLogFormatter {
    public static final int PARAM_MAX_WIDTH = 500;
    private static final String PARAM_NULL = "[null]";
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("\\n");

    private SqlLogFormatter() {
    }

    public static String reformatSql(String sql) {
        char[] chars = sql.toCharArray();
        StringBuilder result = new StringBuilder(chars.length);
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\n' || c == '\t') {
                c = ' ';
            }
            if (Character.isWhitespace(c) && i > 0 && Character.isWhitespace(chars[i - 1])) continue;
            result.append(c);
        }
        return result.toString();
    }

    public static String reformatParam(@Nullable Object param) {
        if (param == null) {
            return PARAM_NULL;
        }
        String abbreviated = StringUtils.abbreviate((String)param.toString(), (int)500);
        return NEWLINE_PATTERN.matcher(abbreviated).replaceAll("\\\\n");
    }

    public static String reformatParams(Object[] params) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(SqlLogFormatter.reformatParam(params[i]));
        }
        return sb.toString();
    }

    public static int countArguments(String sql) {
        int argCount = 0;
        for (int i = 0; i < sql.length(); ++i) {
            if (sql.charAt(i) != '?') continue;
            ++argCount;
        }
        return argCount;
    }
}

