/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.issue;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class IssueChangeContext
implements Serializable {
    private final String userUuid;
    private final Date date;
    private final boolean scan;

    private IssueChangeContext(@Nullable String userUuid, Date date, boolean scan) {
        this.userUuid = userUuid;
        this.date = date;
        this.scan = scan;
    }

    @CheckForNull
    public String userUuid() {
        return this.userUuid;
    }

    public Date date() {
        return this.date;
    }

    public boolean scan() {
        return this.scan;
    }

    public static IssueChangeContext createScan(Date date) {
        return new IssueChangeContext(null, date, true);
    }

    public static IssueChangeContext createUser(Date date, @Nullable String userUuid) {
        return new IssueChangeContext(userUuid, date, false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueChangeContext that = (IssueChangeContext)o;
        return this.scan == that.scan && Objects.equals(this.userUuid, that.userUuid) && Objects.equals(this.date, that.date);
    }

    public int hashCode() {
        return Objects.hash(this.userUuid, this.date, this.scan);
    }

    public String toString() {
        return "IssueChangeContext{userUuid='" + this.userUuid + '\'' + ", date=" + this.date + ", scan=" + this.scan + '}';
    }
}

