/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.util;

import com.google.common.base.Joiner;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class ContextException
extends RuntimeException {
    private static final Joiner COMMA_JOINER = Joiner.on(',');
    private final transient ListMultimap<String, Object> context = LinkedListMultimap.create();

    private ContextException(Throwable t) {
        super(t);
    }

    private ContextException(String message, Throwable t) {
        super(message, t);
    }

    private ContextException(String message) {
        super(message);
    }

    private ContextException addContext(ContextException e) {
        this.context.putAll(e.context);
        return this;
    }

    public ContextException addContext(String key, @Nullable Object value) {
        this.context.put(key, value);
        return this;
    }

    public ContextException clearContext(String key) {
        this.context.removeAll(key);
        return this;
    }

    public ContextException setContext(String key, @Nullable Object value) {
        this.clearContext(key);
        return this.addContext(key, value);
    }

    public List<Object> getContext(String key) {
        return this.context.get(key);
    }

    public static ContextException of(Throwable t) {
        if (t instanceof ContextException) {
            return new ContextException(t.getCause()).addContext((ContextException)t);
        }
        return new ContextException(t);
    }

    public static ContextException of(String message, Throwable t) {
        if (t instanceof ContextException) {
            return new ContextException(message, t.getCause()).addContext((ContextException)t);
        }
        return new ContextException(message, t);
    }

    public static ContextException of(String message) {
        return new ContextException(message);
    }

    @Override
    @Nonnull
    public String getMessage() {
        return this.format(super.getMessage());
    }

    @CheckForNull
    public String getRawMessage() {
        return super.getMessage();
    }

    private String format(@Nullable String baseMessage) {
        StringBuilder sb = new StringBuilder();
        Iterator keyIt = this.context.keySet().iterator();
        if (StringUtils.isNotBlank(baseMessage)) {
            sb.append(baseMessage);
            if (keyIt.hasNext()) {
                sb.append(" | ");
            }
        }
        while (keyIt.hasNext()) {
            String key = (String)keyIt.next();
            sb.append(key).append("=");
            List<Object> values = this.getContext(key);
            if (values.size() > 1) {
                sb.append("[").append(COMMA_JOINER.join(values)).append("]");
            } else if (values.size() == 1) {
                sb.append(values.get(0));
            }
            if (!keyIt.hasNext()) continue;
            sb.append(" | ");
        }
        return sb.toString();
    }
}

