/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.sonar.api.config.Configuration;
import org.sonar.api.platform.Server;
import org.sonar.api.utils.HttpDownloader;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.FileUtils;
import org.sonar.core.util.HttpsTrust;

public class DefaultHttpDownloader
extends HttpDownloader {
    private final BaseHttpDownloader downloader;
    private final Integer readTimeout;
    private final Integer connectTimeout;

    public DefaultHttpDownloader(Server server, Configuration config) {
        this(server, config, null);
    }

    public DefaultHttpDownloader(Server server, Configuration config, @Nullable Integer readTimeout) {
        this(server, config, null, readTimeout);
    }

    public DefaultHttpDownloader(Server server, Configuration config, @Nullable Integer connectTimeout, @Nullable Integer readTimeout) {
        this.readTimeout = readTimeout;
        this.connectTimeout = connectTimeout;
        this.downloader = new BaseHttpDownloader(new AuthenticatorFacade(), config, server.getVersion());
    }

    public DefaultHttpDownloader(Configuration config) {
        this(config, null);
    }

    public DefaultHttpDownloader(Configuration config, @Nullable Integer readTimeout) {
        this(config, null, readTimeout);
    }

    public DefaultHttpDownloader(Configuration config, @Nullable Integer connectTimeout, @Nullable Integer readTimeout) {
        this.readTimeout = readTimeout;
        this.connectTimeout = connectTimeout;
        this.downloader = new BaseHttpDownloader(new AuthenticatorFacade(), config, null);
    }

    @Override
    protected String description(URI uri) {
        return String.format("%s (%s)", uri.toString(), this.getProxySynthesis(uri));
    }

    @Override
    protected String[] getSupportedSchemes() {
        return new String[]{"http", "https"};
    }

    @Override
    protected byte[] readBytes(URI uri) {
        return this.download(uri);
    }

    @Override
    protected String readString(URI uri, Charset charset) {
        try {
            return IOUtils.toString(this.downloader.newInputSupplier(uri, this.connectTimeout, this.readTimeout).getInput(), charset);
        }
        catch (IOException e) {
            throw this.failToDownload(uri, e);
        }
    }

    @Override
    public String downloadPlainText(URI uri, String encoding) {
        return this.readString(uri, Charset.forName(encoding));
    }

    @Override
    public byte[] download(URI uri) {
        try {
            return ByteStreams.toByteArray(this.downloader.newInputSupplier(uri, this.connectTimeout, this.readTimeout).getInput());
        }
        catch (IOException e) {
            throw this.failToDownload(uri, e);
        }
    }

    public String getProxySynthesis(URI uri) {
        return BaseHttpDownloader.getProxySynthesis(uri);
    }

    @Override
    public InputStream openStream(URI uri) {
        try {
            return this.downloader.newInputSupplier(uri, this.connectTimeout, this.readTimeout).getInput();
        }
        catch (IOException e) {
            throw this.failToDownload(uri, e);
        }
    }

    @Override
    public void download(URI uri, File toFile) {
        try {
            org.apache.commons.io.FileUtils.copyInputStreamToFile(this.downloader.newInputSupplier(uri, this.connectTimeout, this.readTimeout).getInput(), toFile);
        }
        catch (IOException e) {
            FileUtils.deleteQuietly(toFile);
            throw this.failToDownload(uri, e);
        }
    }

    private SonarException failToDownload(URI uri, IOException e) {
        throw new SonarException(String.format("Fail to download: %s (%s)", uri, this.getProxySynthesis(uri)), e);
    }

    static class ProxyAuthenticator
    extends Authenticator {
        private final PasswordAuthentication auth;

        ProxyAuthenticator(String user, @Nullable String password) {
            this.auth = new PasswordAuthentication(user, password == null ? new char[]{} : password.toCharArray());
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return this.auth;
        }
    }

    static class BaseHttpDownloader {
        private static final String GET = "GET";
        private static final String HTTP_PROXY_USER = "http.proxyUser";
        private static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
        private String userAgent;

        BaseHttpDownloader(AuthenticatorFacade system, Configuration config, @Nullable String userAgent) {
            this.initProxy(system, config);
            this.initUserAgent(userAgent, config);
        }

        private void initProxy(AuthenticatorFacade system, Configuration config) {
            Optional<String> login = config.get(HTTP_PROXY_USER);
            if (login.isPresent()) {
                system.setDefaultAuthenticator(new ProxyAuthenticator(login.get(), config.get(HTTP_PROXY_PASSWORD).orElse(null)));
            }
        }

        private void initUserAgent(@Nullable String sonarVersion, Configuration settings) {
            Optional<String> serverId = settings.get("sonar.core.id");
            this.userAgent = sonarVersion == null ? "SonarQube" : String.format("SonarQube %s # %s", sonarVersion, serverId.orElse(""));
            System.setProperty("http.agent", this.userAgent);
        }

        private static String getProxySynthesis(URI uri) {
            return BaseHttpDownloader.getProxySynthesis(uri, ProxySelector.getDefault());
        }

        @VisibleForTesting
        static String getProxySynthesis(URI uri, ProxySelector proxySelector) {
            List<Proxy> proxies = proxySelector.select(uri);
            if (proxies.size() == 1 && proxies.get(0).type().equals((Object)Proxy.Type.DIRECT)) {
                return "no proxy";
            }
            ArrayList<String> descriptions = Lists.newArrayList();
            for (Proxy proxy : proxies) {
                if (proxy.type() == Proxy.Type.DIRECT) continue;
                descriptions.add((Object)((Object)proxy.type()) + " proxy: " + proxy.address());
            }
            return Joiner.on(", ").join(descriptions);
        }

        public HttpInputSupplier newInputSupplier(URI uri, @Nullable Integer connectTimeoutMillis, @Nullable Integer readTimeoutMillis) {
            return this.newInputSupplier(uri, GET, connectTimeoutMillis, readTimeoutMillis);
        }

        public HttpInputSupplier newInputSupplier(URI uri, String requestMethod, @Nullable Integer connectTimeoutMillis, @Nullable Integer readTimeoutMillis) {
            return this.newInputSupplier(uri, requestMethod, null, null, connectTimeoutMillis, readTimeoutMillis);
        }

        public HttpInputSupplier newInputSupplier(URI uri, String requestMethod, String login, String password, @Nullable Integer connectTimeoutMillis, @Nullable Integer readTimeoutMillis) {
            int read = readTimeoutMillis != null ? readTimeoutMillis : 60000;
            int connect = connectTimeoutMillis != null ? connectTimeoutMillis : 20000;
            return new HttpInputSupplier(uri, requestMethod, this.userAgent, login, password, connect, read);
        }

        private static class HttpInputSupplier {
            private final String login;
            private final String password;
            private final URI uri;
            private final String userAgent;
            private final int connectTimeoutMillis;
            private final int readTimeoutMillis;
            private final String requestMethod;

            HttpInputSupplier(URI uri, String requestMethod, String userAgent, String login, String password, int connectTimeoutMillis, int readTimeoutMillis) {
                this.uri = uri;
                this.requestMethod = requestMethod;
                this.userAgent = userAgent;
                this.login = login;
                this.password = password;
                this.readTimeoutMillis = readTimeoutMillis;
                this.connectTimeoutMillis = connectTimeoutMillis;
            }

            public InputStream getInput() throws IOException {
                Loggers.get(this.getClass()).debug("Download: " + this.uri + " (" + BaseHttpDownloader.getProxySynthesis(this.uri, ProxySelector.getDefault()) + ")");
                HttpURLConnection connection = (HttpURLConnection)this.uri.toURL().openConnection();
                connection.setRequestMethod(this.requestMethod);
                HttpsTrust.INSTANCE.trust(connection);
                connection.setRequestProperty("Accept-Encoding", "gzip");
                if (!Strings.isNullOrEmpty(this.login)) {
                    String encoded = Base64.encodeBase64String((this.login + ":" + this.password).getBytes(StandardCharsets.UTF_8));
                    connection.setRequestProperty("Authorization", "Basic " + encoded);
                }
                connection.setConnectTimeout(this.connectTimeoutMillis);
                connection.setReadTimeout(this.readTimeoutMillis);
                connection.setUseCaches(true);
                connection.setInstanceFollowRedirects(true);
                connection.setRequestProperty("User-Agent", this.userAgent);
                connection.connect();
                String encoding = connection.getContentEncoding();
                int responseCode = connection.getResponseCode();
                if (responseCode >= 400) {
                    InputStream errorResponse = null;
                    try {
                        errorResponse = connection.getErrorStream();
                        if (errorResponse != null) {
                            String errorResponseContent = IOUtils.toString(errorResponse);
                            throw new HttpDownloader.HttpException(this.uri, responseCode, errorResponseContent);
                        }
                        throw new HttpDownloader.HttpException(this.uri, responseCode);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(errorResponse);
                        throw throwable;
                    }
                }
                InputStream resultingInputStream = encoding != null && "gzip".equalsIgnoreCase(encoding) ? new GZIPInputStream(connection.getInputStream()) : connection.getInputStream();
                return resultingInputStream;
            }
        }
    }

    static class AuthenticatorFacade {
        AuthenticatorFacade() {
        }

        void setDefaultAuthenticator(Authenticator authenticator) {
            Authenticator.setDefault(authenticator);
        }
    }
}

