/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import com.google.gson.Gson;
import java.io.File;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.core.platform.PluginInfo;
import org.sonar.scanner.bootstrap.PluginFiles;
import org.sonar.scanner.bootstrap.PluginInstaller;
import org.sonar.scanner.bootstrap.ScannerPlugin;
import org.sonar.scanner.bootstrap.ScannerWsClient;
import org.sonarqube.ws.client.GetRequest;

public class ScannerPluginInstaller
implements PluginInstaller {
    private static final Logger LOG = Loggers.get(ScannerPluginInstaller.class);
    private static final String PLUGINS_WS_URL = "api/plugins/installed";
    private final PluginFiles pluginFiles;
    private final ScannerWsClient wsClient;

    public ScannerPluginInstaller(PluginFiles pluginFiles, ScannerWsClient wsClient) {
        this.pluginFiles = pluginFiles;
        this.wsClient = wsClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ScannerPlugin> installRemotes() {
        Profiler profiler = Profiler.create(LOG).startInfo("Load/download plugins");
        try {
            HashMap<String, ScannerPlugin> result = new HashMap<String, ScannerPlugin>();
            Loaded loaded = this.loadPlugins(result);
            if (!loaded.ok) {
                result.clear();
                loaded = this.loadPlugins(result);
                if (!loaded.ok) {
                    throw new IllegalStateException(String.format("Fail to download plugin [%s]. Not found.", loaded.notFoundPlugin));
                }
            }
            HashMap<String, ScannerPlugin> hashMap = result;
            return hashMap;
        }
        finally {
            profiler.stopInfo();
        }
    }

    private Loaded loadPlugins(Map<String, ScannerPlugin> result) {
        for (InstalledPlugin plugin : this.listInstalledPlugins()) {
            Optional<File> jarFile = this.pluginFiles.get(plugin);
            if (!jarFile.isPresent()) {
                return new Loaded(false, plugin.key);
            }
            PluginInfo info = PluginInfo.create(jarFile.get());
            result.put(info.getKey(), new ScannerPlugin(plugin.key, plugin.updatedAt, info));
        }
        return new Loaded(true, null);
    }

    @Override
    public List<Object[]> installLocals() {
        return Collections.emptyList();
    }

    private InstalledPlugin[] listInstalledPlugins() {
        InstalledPlugins installedPlugins;
        Profiler profiler = Profiler.create(LOG).startInfo("Load plugins index");
        GetRequest getRequest = new GetRequest(PLUGINS_WS_URL);
        try (Reader reader = this.wsClient.call(getRequest).contentReader();){
            installedPlugins = new Gson().fromJson(reader, InstalledPlugins.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to parse response of api/plugins/installed", e);
        }
        profiler.stopInfo();
        return installedPlugins.plugins;
    }

    private static class Loaded {
        private final boolean ok;
        @Nullable
        private final String notFoundPlugin;

        private Loaded(boolean ok, @Nullable String notFoundPlugin) {
            this.ok = ok;
            this.notFoundPlugin = notFoundPlugin;
        }
    }

    static class InstalledPlugin {
        String key;
        String hash;
        long updatedAt;

        InstalledPlugin() {
        }
    }

    private static class InstalledPlugins {
        InstalledPlugin[] plugins;

        private InstalledPlugins() {
        }
    }
}

