/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.ci;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.ci.CiConfiguration;
import org.sonar.scanner.ci.CiVendor;

public class CiConfigurationProvider
extends ProviderAdapter {
    private static final Logger LOG = Loggers.get(CiConfigurationProvider.class);
    private static final String PROP_DISABLED = "sonar.ci.autoconfig.disabled";

    public CiConfiguration provide(Configuration configuration, CiVendor[] ciVendors) {
        boolean disabled = configuration.getBoolean(PROP_DISABLED).orElse(false);
        if (disabled) {
            return new EmptyCiConfiguration();
        }
        List detectedVendors = Arrays.stream(ciVendors).filter(CiVendor::isDetected).collect(Collectors.toList());
        if (detectedVendors.size() > 1) {
            List names = detectedVendors.stream().map(CiVendor::getName).collect(Collectors.toList());
            throw MessageException.of("Multiple CI environments are detected: " + names + ". Please check environment variables or set property " + PROP_DISABLED + " to true.");
        }
        if (detectedVendors.size() == 1) {
            CiVendor vendor = (CiVendor)detectedVendors.get(0);
            LOG.info("Detected {}", (Object)vendor.getName());
            return vendor.loadConfiguration();
        }
        return new EmptyCiConfiguration();
    }

    private static class EmptyCiConfiguration
    implements CiConfiguration {
        private EmptyCiConfiguration() {
        }

        @Override
        public Optional<String> getScmRevision() {
            return Optional.empty();
        }
    }
}

